/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.utils.DBUtils;

public class IdpMetaDataDAO {
    private static Log log = LogFactory.getLog(IdpMetaDataDAO.class);
    private static IdpMetaDataDAO idpMetaDataDAO = new IdpMetaDataDAO();

    private IdpMetaDataDAO() {
    }

    public static IdpMetaDataDAO getInstance() {
        return idpMetaDataDAO;
    }

    public int getResidentIdpId(int tenantId) throws MigrationClientException {
        String sql = "SELECT ID FROM IDP WHERE NAME='LOCAL' AND TENANT_ID=?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        int residentIdpId = -9999;
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            prepStmt = connection.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            prepStmt.setString(1, String.valueOf(tenantId));
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                residentIdpId = rs.getInt("ID");
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationClientException("Error while retrieving resident idp id of tenant : " + tenantId, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return residentIdpId;
    }

    public List<String> getAvailableConfigNames(int tenantId, int residentIdpId) throws MigrationClientException {
        String sql = "SELECT NAME FROM IDP_METADATA WHERE TENANT_ID=? AND IDP_ID=?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        ArrayList<String> residentIdpPropertyNames = new ArrayList<String>();
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            prepStmt = connection.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            prepStmt.setInt(1, tenantId);
            prepStmt.setInt(2, residentIdpId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                residentIdpPropertyNames.add(rs.getString("NAME"));
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationClientException("Error while retrieving resident idp properties of tenant : " + tenantId, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return residentIdpPropertyNames;
    }

    public void addIdpMetaData(List<IdpMetaData> idpMetaDataDAOs) throws MigrationClientException {
        String sql = "INSERT INTO IDP_METADATA(IDP_ID, NAME, VALUE, DISPLAY_NAME, TENANT_ID) values(?,?,?,?,?)";
        PreparedStatement prepStmt = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            prepStmt = connection.prepareStatement(sql, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            for (IdpMetaData idpMetaData : idpMetaDataDAOs) {
                prepStmt.setInt(1, idpMetaData.getIdpId());
                prepStmt.setString(2, idpMetaData.getName());
                prepStmt.setString(3, idpMetaData.getValue());
                prepStmt.setString(4, idpMetaData.getDisplayName());
                prepStmt.setInt(5, idpMetaData.getTenantId());
                prepStmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollBack((Connection)connection);
                throw new MigrationClientException("Error while inserting default resident idp property values.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    public static class IdpMetaData {
        private int idpId;
        private String name;
        private String value;
        private String displayName;
        private int tenantId;

        public IdpMetaData(int idpId, String name, String value, String displayName, int tenantId) {
            this.idpId = idpId;
            this.name = name;
            this.value = value;
            this.displayName = displayName;
            this.tenantId = tenantId;
        }

        public int getIdpId() {
            return this.idpId;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getTenantId() {
            return this.tenantId;
        }
    }
}

