/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530.migrator;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedLocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.LocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.AttributeMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v530.ClaimManager;
import org.wso2.carbon.is.migration.service.v530.bean.Claim;
import org.wso2.carbon.is.migration.service.v530.bean.Dialect;
import org.wso2.carbon.is.migration.service.v530.bean.MappedAttribute;
import org.wso2.carbon.is.migration.service.v540.util.FileBasedClaimBuilder;
import org.wso2.carbon.is.migration.util.Utility;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;

public class ClaimDataMigrator
extends Migrator {
    private static Log log = LogFactory.getLog(ClaimDataMigrator.class);
    private boolean isSuccess = true;
    private int count = 1;
    private static final String CLAIM_CONFIG = "claim-config.xml";
    private ClaimConfig claimConfig;
    private ClaimDialectDAO claimDialectDAO = new ClaimDialectDAO();
    private CacheBackedLocalClaimDAO localClaimDAO = new CacheBackedLocalClaimDAO(new LocalClaimDAO());

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateClaimData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrateClaimData() throws MigrationClientException {
        ArrayList<Claim> claims = new ArrayList<Claim>();
        Connection umConnection = null;
        PreparedStatement loadDialectsStatement = null;
        PreparedStatement loadMappedAttributeStatement = null;
        ResultSet dialects = null;
        ResultSet claimResultSet = null;
        StringBuilder report = new StringBuilder();
        report.append("---------------------------------- WSO2 Identity Server 5.3.0 claim Migration Report -----------------------------------------\n \n");
        report.append("\n\n------------------------------------------------- Validating Existing Claims----------------------------------------------\n \n");
        try {
            umConnection = this.getDataSource().getConnection();
            umConnection.setAutoCommit(false);
            HashMap<String, Map<String, List<String>>> data = new HashMap<String, Map<String, List<String>>>();
            HashMap<Integer, Dialect> dialectMap = new HashMap<Integer, Dialect>();
            try {
                loadDialectsStatement = umConnection.prepareStatement("SELECT * FROM UM_DIALECT");
                dialects = loadDialectsStatement.executeQuery();
                Object inactiveTenants = new ArrayList();
                if (this.isIgnoreForInactiveTenants()) {
                    inactiveTenants = Utility.getInactiveTenants();
                }
                this.processDialects(dialects, (Map<Integer, Dialect>)dialectMap, (List<Integer>)inactiveTenants);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(dialects);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)loadDialectsStatement);
                throw throwable;
            }
            IdentityDatabaseUtil.closeResultSet((ResultSet)dialects);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)loadDialectsStatement);
            for (Map.Entry entry : dialectMap.entrySet()) {
                Dialect dialect = (Dialect)entry.getValue();
                HashMap<String, List<String>> mappedAttributes = new HashMap<String, List<String>>();
                try {
                    loadMappedAttributeStatement = umConnection.prepareStatement("SELECT * FROM UM_CLAIM WHERE UM_DIALECT_ID = ?");
                    loadMappedAttributeStatement.setInt(1, dialect.getDialectId());
                    claimResultSet = loadMappedAttributeStatement.executeQuery();
                    this.processClaimResultSet(claims, claimResultSet, mappedAttributes, dialect.getDialectUri(), dialect.getTenantId());
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeResultSet(claimResultSet);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)loadMappedAttributeStatement);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeResultSet((ResultSet)claimResultSet);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)loadMappedAttributeStatement);
                this.getTenantQualifiedDialectUris(data, mappedAttributes, dialect.getDialectUri(), dialect.getTenantId());
            }
            HashMap<String, Map<String, List<String>>> tenantDialectMappedAttributes = new HashMap<String, Map<String, List<String>>>();
            for (Map.Entry<String, Map<String, List<String>>> entry : data.entrySet()) {
                this.mapAttributesAgainstDialects(report, tenantDialectMappedAttributes, entry);
            }
            this.mapAttributesAgainstTenant(report, tenantDialectMappedAttributes);
        }
        catch (SQLException e) {
            log.error((Object)"Error while validating claim management data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)umConnection);
        }
        this.migrateClaimData(claims, report);
        return this.isSuccess;
    }

    private void processDialects(ResultSet dialects, Map<Integer, Dialect> dialectMap, List<Integer> inactiveTenants) throws SQLException {
        while (dialects.next()) {
            int dialectId = dialects.getInt("UM_ID");
            String dialectUri = dialects.getString("UM_DIALECT_URI");
            int tenantId = dialects.getInt("UM_TENANT_ID");
            if (this.isIgnoreForInactiveTenants() && inactiveTenants.contains(tenantId)) {
                log.info((Object)("Inactive tenant : " + tenantId + " , Skipping claim data migration for dialect : " + dialectUri));
                continue;
            }
            Dialect dialect = new Dialect(dialectId, dialectUri, tenantId);
            dialectMap.put(dialectId, dialect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateClaimData(List<Claim> claims, StringBuilder report) {
        ClaimManager claimManager = ClaimManager.getInstance();
        if (claims != null) {
            report.append("\n\n------------------------------------------------------------------------------ Claim Migration -------------------------------------------------------------------------------\n \n");
            try {
                claimManager.addClaimDialects(claims, report);
                claimManager.addLocalClaims(claims, report);
                this.migrateLocalClaims();
                log.info((Object)"end adding local claims");
                claimManager.addExternalClaim(claims, report);
            }
            catch (MigrationClientException e) {
                log.error((Object)"Error while migrating claim data", (Throwable)e);
            }
        }
        if (!this.isSuccess) {
            try (PrintWriter out = null;){
                out = new PrintWriter("claim-migration.txt");
                out.println(report.toString());
            }
        }
    }

    private void getTenantQualifiedDialectUris(Map<String, Map<String, List<String>>> data, Map<String, List<String>> mappedAttributes, String dialectUri, int tenantId) {
        block2: {
            try {
                dialectUri = dialectUri + "@" + IdentityTenantUtil.getTenantDomain((int)tenantId);
                data.put(dialectUri, mappedAttributes);
            }
            catch (IdentityRuntimeException e) {
                if (!e.getMessage().contains("Can not find the tenant domain for the tenant id")) break block2;
                String errorMessage = "Error while migrating data. " + e.getMessage() + " for tenantId : " + tenantId;
                log.error((Object)errorMessage);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)errorMessage, (Throwable)e);
            }
        }
    }

    private void processClaimResultSet(List<Claim> claims, ResultSet claimResultSet, Map<String, List<String>> mappedAttributes, String dialectUri, int tenantId) throws SQLException {
        try {
            IdentityTenantUtil.getTenantDomain((int)tenantId);
        }
        catch (IdentityRuntimeException e) {
            if (e.getMessage().contains("Can not find the tenant domain for the tenant id")) {
                String errorMessage = "Error while migrating data. " + e.getMessage() + " for tenantId : " + tenantId;
                log.error((Object)errorMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
            }
            return;
        }
        while (claimResultSet.next()) {
            int readOnly;
            boolean isReadOnly;
            int displayOrder;
            int required;
            boolean isRequired;
            int supportedByDefault;
            boolean isSupportedByDefault;
            String attribute = claimResultSet.getString("UM_MAPPED_ATTRIBUTE");
            String claimURI = claimResultSet.getString("UM_CLAIM_URI");
            String displayTag = claimResultSet.getString("UM_DISPLAY_TAG");
            String description = claimResultSet.getString("UM_DESCRIPTION");
            String mappedAttributeDomain = claimResultSet.getString("UM_MAPPED_ATTRIBUTE_DOMAIN");
            String regEx = claimResultSet.getString("UM_REG_EX");
            Claim claimDTO = new Claim(claimURI, displayTag, description, regEx, isSupportedByDefault = (supportedByDefault = claimResultSet.getInt("UM_SUPPORTED")) == 1, isRequired = (required = claimResultSet.getInt("UM_REQUIRED")) == 1, displayOrder = claimResultSet.getInt("UM_DISPLAY_ORDER"), isReadOnly = (readOnly = claimResultSet.getInt("UM_READ_ONLY")) == 1, tenantId, dialectUri);
            if (claims.contains(claimDTO)) {
                for (Claim claim : claims) {
                    if (!claim.equals(claimDTO)) continue;
                    MappedAttribute mappedAttribute = new MappedAttribute(attribute, mappedAttributeDomain);
                    claim.getAttributes().add(mappedAttribute);
                    break;
                }
            } else {
                MappedAttribute mappedAttribute = new MappedAttribute(attribute, mappedAttributeDomain);
                List<MappedAttribute> mappedAttributesList = claimDTO.getAttributes();
                mappedAttributesList.add(mappedAttribute);
                claimDTO.setAttributes(mappedAttributesList);
                claims.add(claimDTO);
            }
            String domainQualifiedAttribute = StringUtils.isBlank((String)mappedAttributeDomain) ? attribute : mappedAttributeDomain + "/" + attribute;
            List<Object> claimURIs = mappedAttributes.get(domainQualifiedAttribute) != null ? mappedAttributes.get(domainQualifiedAttribute) : new ArrayList();
            claimURIs.add(claimURI);
            mappedAttributes.put(domainQualifiedAttribute, claimURIs);
        }
    }

    private void mapAttributesAgainstTenant(StringBuilder report, Map<String, Map<String, List<String>>> tenantDialectMappedAttributes) {
        HashMap claimsToAddMap = new HashMap();
        if (tenantDialectMappedAttributes != null) {
            for (Map.Entry<String, Map<String, List<String>>> entry : tenantDialectMappedAttributes.entrySet()) {
                String tenantDomain = entry.getKey();
                Set<String> claimsToAdd = new HashSet();
                if (claimsToAddMap.get(tenantDomain) != null) {
                    claimsToAdd = (Set)claimsToAddMap.get(tenantDomain);
                }
                if (entry.getValue() != null) {
                    List<String> localAttributes = entry.getValue().get("http://wso2.org/claims");
                    for (Map.Entry<String, List<String>> dialect : entry.getValue().entrySet()) {
                        List<String> remoteClaimAttributes;
                        if ("http://wso2.org/claims".equalsIgnoreCase(dialect.getKey()) || (remoteClaimAttributes = dialect.getValue()) == null) continue;
                        for (String remoteClaimAttribute : remoteClaimAttributes) {
                            if (localAttributes.contains(remoteClaimAttribute)) continue;
                            claimsToAdd.add(remoteClaimAttribute);
                            this.isSuccess = false;
                            report.append("\n\n" + this.count + ")  Mapped Attribute : " + remoteClaimAttribute + " in dialect :" + dialect.getKey() + " is not associated to any of the local claim in tenant domain: " + tenantDomain);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Mapped Attribute : " + remoteClaimAttribute + " in dialect :" + dialect.getKey() + " is not associated to any of the local claim in tenant domain: " + tenantDomain));
                            }
                            ++this.count;
                        }
                    }
                }
                claimsToAddMap.put(tenantDomain, claimsToAdd);
            }
        }
    }

    private void mapAttributesAgainstDialects(StringBuilder report, Map<String, Map<String, List<String>>> tenantDialectMappedAttributes, Map.Entry<String, Map<String, List<String>>> entry) {
        Map<Object, Object> dialectMappedAttributes = new HashMap();
        List<String> attributes = new ArrayList();
        String dialect = entry.getKey();
        String[] split = dialect.split("@");
        dialect = split[0];
        String tenantDomain = split[1];
        if (tenantDialectMappedAttributes.get(tenantDomain) != null) {
            dialectMappedAttributes = tenantDialectMappedAttributes.get(tenantDomain);
        }
        if (dialectMappedAttributes.get(dialect) != null) {
            attributes = (List)dialectMappedAttributes.get(dialect);
        }
        if (entry.getValue() != null) {
            for (Map.Entry<String, List<String>> claimEntry : entry.getValue().entrySet()) {
                String mappedAttribute = claimEntry.getKey();
                if (mappedAttribute == null) continue;
                attributes.add(mappedAttribute.trim());
                if (claimEntry.getValue() == null || claimEntry.getValue().size() <= 1) continue;
                this.isSuccess = false;
                report.append(this.count + ")  Duplicate Mapped Attribute found for dialect :" + dialect + " | Mapped Attribute :" + mappedAttribute + " | Relevant Claims : " + claimEntry.getValue() + " | Tenant Domain :" + tenantDomain);
                report.append("\n\n");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Duplicate Mapped Attribute found for dialect :" + dialect + " | Mapped Attribute :" + mappedAttribute + " | Relevant Claims : " + claimEntry.getValue() + " | Tenant Domain :" + tenantDomain));
                }
                ++this.count;
            }
            dialectMappedAttributes.put(entry.getKey().replace("@" + tenantDomain, ""), attributes);
            tenantDialectMappedAttributes.put(tenantDomain, dialectMappedAttributes);
        }
    }

    private void migrateLocalClaims() throws MigrationClientException {
        String message;
        String filePath = Utility.getDataFilePath(CLAIM_CONFIG, this.getVersionConfig().getVersion());
        try {
            this.claimConfig = FileBasedClaimBuilder.buildClaimMappingsFromConfigFile(filePath);
        }
        catch (IOException | XMLStreamException | UserStoreException e) {
            message = "Error while building claims from config file";
            if (this.isContinueOnError()) {
                log.error((Object)message, e);
            }
            throw new MigrationClientException(message, e);
        }
        if (this.claimConfig.getClaims().isEmpty()) {
            log.info((Object)" WSO2 Product Migration Service Task : No data to migrate related with claim mappings.");
            return;
        }
        try {
            this.migrateLocalClaimData(-1234);
            Set<Tenant> tenants = Utility.getTenants();
            List<Integer> inactiveTenants = Utility.getInactiveTenants();
            boolean ignoreForInactiveTenants = this.isIgnoreForInactiveTenants();
            for (Tenant tenant : tenants) {
                int tenantId = tenant.getId();
                if (ignoreForInactiveTenants && inactiveTenants.contains(tenantId)) {
                    log.info((Object)("Skipping claim data migration for inactive tenant: " + tenantId));
                    continue;
                }
                this.migrateLocalClaimData(tenant.getId());
            }
        }
        catch (ClaimMetadataException | UserStoreException e) {
            message = "Error while migrating claim data";
            if (this.isContinueOnError()) {
                log.error((Object)message, e);
            }
            throw new MigrationClientException(message, e);
        }
    }

    private void migrateLocalClaimData(int tenantId) throws UserStoreException, ClaimMetadataException {
        UserRealm realm = ISMigrationServiceDataHolder.getRealmService().getTenantUserRealm(tenantId);
        String primaryDomainName = realm.getRealmConfiguration().getUserStoreProperty("DomainName");
        if (StringUtils.isBlank((String)primaryDomainName)) {
            primaryDomainName = "PRIMARY";
        }
        HashSet<String> claimDialects = new HashSet<String>();
        for (ClaimDialect claimDialect : this.claimDialectDAO.getClaimDialects(tenantId)) {
            claimDialects.add(claimDialect.getClaimDialectURI());
        }
        HashMap externalClaims = new HashMap();
        Set<Object> existingLocalClaimURIs = new HashSet();
        for (Map.Entry entry : this.claimConfig.getClaims().entrySet()) {
            String claimURI = (String)entry.getKey();
            ClaimMapping claimMapping = (ClaimMapping)entry.getValue();
            String claimDialectURI = claimMapping.getClaim().getDialectURI();
            if ("http://wso2.org/claims".equals(claimDialectURI)) {
                if (existingLocalClaimURIs.isEmpty()) {
                    existingLocalClaimURIs = this.getExistingLocalClaimURIs(tenantId);
                }
                if (existingLocalClaimURIs.contains(claimURI)) {
                    log.warn((Object)(" WSO2 Product Migration Service Task : Local claim: " + claimURI + " already exists in the system for tenant: " + tenantId));
                    continue;
                }
                this.addLocalClaimMapping(tenantId, primaryDomainName, claimURI, claimMapping);
                existingLocalClaimURIs.add(claimURI);
                continue;
            }
            externalClaims.put(entry.getKey(), entry.getValue());
        }
    }

    private Set<String> getExistingLocalClaimURIs(int tenantId) throws ClaimMetadataException {
        HashSet<String> localClaimURIs = new HashSet<String>();
        for (LocalClaim localClaim : this.localClaimDAO.getLocalClaims(tenantId)) {
            localClaimURIs.add(localClaim.getClaimURI());
        }
        return localClaimURIs;
    }

    private void addLocalClaimMapping(int tenantId, String primaryDomainName, String claimURI, ClaimMapping claimMapping) throws ClaimMetadataException {
        ArrayList<AttributeMapping> mappedAttributes = new ArrayList<AttributeMapping>();
        if (StringUtils.isNotBlank((String)claimMapping.getMappedAttribute())) {
            mappedAttributes.add(new AttributeMapping(primaryDomainName, claimMapping.getMappedAttribute()));
        }
        if (claimMapping.getMappedAttributes() != null) {
            for (Map.Entry claimMappingEntry : claimMapping.getMappedAttributes().entrySet()) {
                mappedAttributes.add(new AttributeMapping((String)claimMappingEntry.getKey(), (String)claimMappingEntry.getValue()));
            }
        }
        Map claimProperties = (Map)this.claimConfig.getPropertyHolder().get(claimURI);
        claimProperties.remove("Dialect");
        claimProperties.remove("ClaimURI");
        claimProperties.remove("AttributeID");
        if (!claimProperties.containsKey("DisplayName")) {
            claimProperties.put("DisplayName", "0");
        }
        if (claimProperties.containsKey("SupportedByDefault") && StringUtils.isBlank((String)((String)claimProperties.get("SupportedByDefault")))) {
            claimProperties.put("SupportedByDefault", "true");
        }
        if (claimProperties.containsKey("ReadOnly") && StringUtils.isBlank((String)((String)claimProperties.get("ReadOnly")))) {
            claimProperties.put("ReadOnly", "true");
        }
        if (claimProperties.containsKey("Required") && StringUtils.isBlank((String)((String)claimProperties.get("Required")))) {
            claimProperties.put("Required", "true");
        }
        LocalClaim localClaim = new LocalClaim(claimURI, mappedAttributes, claimProperties);
        this.localClaimDAO.addLocalClaim(localClaim, tenantId);
    }
}

