/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530.migrator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.util.Utility;
import org.xml.sax.SAXException;

public class PermissionDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(PermissionDataMigrator.class);
    private static final String RESOURCES_XML = "resources.xml";

    @Override
    public void migrate() throws MigrationClientException {
        this.migratePermissionData();
    }

    public void migratePermissionData() throws MigrationClientException {
        Document permissionMap = this.getPermissionMap();
        if (permissionMap != null) {
            NodeList permissionsList = permissionMap.getElementsByTagName("permission");
            for (int i = 0; i < permissionsList.getLength(); ++i) {
                Element permission = (Element)permissionsList.item(i);
                this.migrateOldPermission(permission);
            }
        }
    }

    private Document getPermissionMap() {
        Document doc = null;
        try {
            File resourceFile = new File(Utility.getDataFilePath(RESOURCES_XML, this.getVersionConfig().getVersion()));
            BufferedInputStream permissionXmlFile = new BufferedInputStream(new FileInputStream(resourceFile));
            DocumentBuilder dBuilder = Utility.getSecuredDocumentBuilder();
            doc = dBuilder.parse(permissionXmlFile);
        }
        catch (SAXException e) {
            log.error((Object)"Error while parsing permission file content.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while parsing permission file content.", (Throwable)e);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateOldPermission(Element permission) throws MigrationClientException {
        Connection umConnection = null;
        try {
            umConnection = this.getDataSource().getConnection();
            umConnection.setAutoCommit(false);
            String oldPermission = permission.getAttribute("old");
            NodeList newPermList = permission.getElementsByTagName("new");
            ResultSet oldPermissionsRS = this.selectExistingPermissions(oldPermission, umConnection);
            umConnection.commit();
            this.addNewPermissions(oldPermissionsRS, newPermList);
        }
        catch (SQLException e) {
            log.error((Object)"Error while migrating permission data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)umConnection);
        }
    }

    private ResultSet selectExistingPermissions(String permission, Connection umConnection) throws SQLException {
        PreparedStatement selectPermissions = umConnection.prepareStatement("SELECT UM_ID, UM_RESOURCE_ID, UM_ACTION , UM_TENANT_ID, UM_MODULE_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?");
        selectPermissions.setString(1, permission);
        return selectPermissions.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewPermissions(ResultSet oldPermissionsRS, NodeList newPermList) throws MigrationClientException {
        Connection umConnection = null;
        try {
            while (oldPermissionsRS.next()) {
                umConnection = this.getDataSource().getConnection();
                umConnection.setAutoCommit(false);
                String action = oldPermissionsRS.getString("UM_ACTION");
                int tenantId = oldPermissionsRS.getInt("UM_TENANT_ID");
                int moduleId = oldPermissionsRS.getInt("UM_MODULE_ID");
                int umID = oldPermissionsRS.getInt("UM_ID");
                for (int j = 0; j < newPermList.getLength(); ++j) {
                    Element newPerm = (Element)newPermList.item(j);
                    String newPermValue = newPerm.getTextContent();
                    ResultSet newPermissions = this.addNewPermission(umConnection, action, tenantId, moduleId, newPermValue);
                    if (newPermissions.next()) {
                        int newUMId = newPermissions.getInt("UM_ID");
                        this.assignNewPermissionForRoles(umID, newUMId);
                    }
                    IdentityDatabaseUtil.closeResultSet((ResultSet)newPermissions);
                }
                umConnection.commit();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Error while adding new permission data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeConnection(umConnection);
                throw throwable;
            }
            IdentityDatabaseUtil.closeConnection((Connection)umConnection);
        }
        IdentityDatabaseUtil.closeConnection(umConnection);
    }

    private ResultSet addNewPermission(Connection umConnection, String action, int tenantId, int moduleId, String newPermValue) throws SQLException {
        if (!this.isPermissionExists(umConnection, newPermValue, action, tenantId, moduleId)) {
            PreparedStatement addPermission = umConnection.prepareStatement("INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION , UM_TENANT_ID, UM_MODULE_ID) VALUES (?, ?, ?, ?)");
            addPermission.setString(1, newPermValue);
            addPermission.setString(2, action);
            addPermission.setInt(3, tenantId);
            addPermission.setInt(4, moduleId);
            addPermission.execute();
            umConnection.commit();
        }
        return this.selectAddedPermissions(newPermValue, umConnection, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignNewPermissionForRoles(int oldPermUMId, int newPermUMId) throws MigrationClientException {
        Connection umConnection = null;
        try {
            umConnection = this.getDataSource().getConnection();
            umConnection.setAutoCommit(false);
            ResultSet rolesWithExistingPerm = this.selectExistingRolesWithPermissions(oldPermUMId, umConnection);
            while (rolesWithExistingPerm.next()) {
                int isAllowed = rolesWithExistingPerm.getInt("UM_IS_ALLOWED");
                int tenantId = rolesWithExistingPerm.getInt("UM_TENANT_ID");
                int domainId = rolesWithExistingPerm.getInt("UM_DOMAIN_ID");
                String roleName = rolesWithExistingPerm.getString("UM_ROLE_NAME");
                if (this.isPermissionAssignedForRole(umConnection, roleName, newPermUMId, isAllowed, tenantId, domainId)) continue;
                PreparedStatement assignPermission = umConnection.prepareStatement("INSERT INTO UM_ROLE_PERMISSION (UM_PERMISSION_ID,UM_ROLE_NAME, UM_IS_ALLOWED, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?, ?, ?,?, ?)");
                assignPermission.setInt(1, newPermUMId);
                assignPermission.setString(2, roleName);
                assignPermission.setInt(3, isAllowed);
                assignPermission.setInt(4, tenantId);
                assignPermission.setInt(5, domainId);
                assignPermission.execute();
                umConnection.commit();
            }
            IdentityDatabaseUtil.closeResultSet((ResultSet)rolesWithExistingPerm);
            umConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)"Error while assigning new permission data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)umConnection);
        }
    }

    private boolean isPermissionExists(Connection umConnection, String resource, String action, int tenantId, int moduleId) throws SQLException {
        int numberOfRows;
        boolean isExist = false;
        PreparedStatement countPermissions = umConnection.prepareStatement("SELECT COUNT(1) FROM UM_PERMISSION WHERE UM_RESOURCE_ID=? AND UM_ACTION=? AND UM_TENANT_ID=? AND UM_MODULE_ID=?");
        countPermissions.setString(1, resource);
        countPermissions.setString(2, action);
        countPermissions.setInt(3, tenantId);
        countPermissions.setInt(4, moduleId);
        ResultSet countRS = countPermissions.executeQuery();
        if (countRS.next() && (numberOfRows = countRS.getInt(1)) > 0) {
            isExist = true;
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)countRS);
        umConnection.commit();
        return isExist;
    }

    private boolean isPermissionAssignedForRole(Connection umConnection, String roleName, int permID, int isAllowed, int tenantId, int domainId) throws SQLException {
        int numberOfRows;
        boolean isExist = false;
        PreparedStatement countPermissions = umConnection.prepareStatement("SELECT COUNT(1) FROM UM_ROLE_PERMISSION WHERE UM_PERMISSION_ID=? AND UM_ROLE_NAME=? AND UM_IS_ALLOWED=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=?");
        countPermissions.setInt(1, permID);
        countPermissions.setString(2, roleName);
        countPermissions.setInt(3, isAllowed);
        countPermissions.setInt(4, tenantId);
        countPermissions.setInt(5, domainId);
        ResultSet countRS = countPermissions.executeQuery();
        if (countRS.next() && (numberOfRows = countRS.getInt(1)) > 0) {
            isExist = true;
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)countRS);
        umConnection.commit();
        return isExist;
    }

    private ResultSet selectExistingRolesWithPermissions(int permissionId, Connection umConnection) throws SQLException {
        PreparedStatement selectPermissions = umConnection.prepareStatement("SELECT UM_PERMISSION_ID, UM_ROLE_NAME, UM_IS_ALLOWED, UM_TENANT_ID, UM_DOMAIN_ID FROM UM_ROLE_PERMISSION WHERE UM_PERMISSION_ID=?");
        selectPermissions.setInt(1, permissionId);
        return selectPermissions.executeQuery();
    }

    private ResultSet selectAddedPermissions(String permission, Connection umConnection, int tenantId) throws SQLException {
        PreparedStatement selectPermissions = umConnection.prepareStatement("SELECT UM_ID, UM_RESOURCE_ID, UM_ACTION , UM_TENANT_ID, UM_MODULE_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=? AND UM_TENANT_ID=?");
        selectPermissions.setString(1, permission);
        selectPermissions.setInt(2, tenantId);
        return selectPermissions.executeQuery();
    }
}

