/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v540.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.is.migration.service.v540.bean.OAuth2Scope;
import org.wso2.carbon.is.migration.service.v540.bean.OAuth2ScopeBinding;
import org.wso2.carbon.is.migration.service.v540.bean.OAuthConsumerApp;

public class OAuthDAO {
    private static OAuthDAO instance = new OAuthDAO();

    private OAuthDAO() {
    }

    public static OAuthDAO getInstance() {
        return instance;
    }

    public List<OAuthConsumerApp> getAllOAuthConsumerApps(Connection connection) throws SQLException {
        ArrayList<OAuthConsumerApp> consumerApps = new ArrayList<OAuthConsumerApp>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT CONSUMER_KEY, TENANT_ID FROM IDN_OAUTH_CONSUMER_APPS");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                consumerApps.add(new OAuthConsumerApp(resultSet.getString("CONSUMER_KEY"), resultSet.getInt("TENANT_ID")));
            }
            connection.commit();
        }
        return consumerApps;
    }

    public void updateExpiryTimesDefinedForOAuthConsumerApps(Connection connection, List<OAuthConsumerApp> updatedConsumerApps) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET USER_ACCESS_TOKEN_EXPIRE_TIME=?, APP_ACCESS_TOKEN_EXPIRE_TIME=?, REFRESH_TOKEN_EXPIRE_TIME=? WHERE CONSUMER_KEY=?");){
            for (OAuthConsumerApp consumerApp : updatedConsumerApps) {
                preparedStatement.setLong(1, consumerApp.getUserAccessTokenExpiryTime());
                preparedStatement.setLong(2, consumerApp.getApplicationAccessTokenExpiryTime());
                preparedStatement.setLong(3, consumerApp.getRefreshTokenExpiryTime());
                preparedStatement.setString(4, consumerApp.getConsumerKey());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }

    public List<OAuth2Scope> getAllOAuth2Scopes(Connection connection) throws SQLException {
        ArrayList<OAuth2Scope> oAuth2Scopes = new ArrayList<OAuth2Scope>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT SCOPE_ID, SCOPE_KEY, NAME, ROLES FROM IDN_OAUTH2_SCOPE");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                oAuth2Scopes.add(new OAuth2Scope(resultSet.getInt("SCOPE_ID"), resultSet.getString("SCOPE_KEY"), resultSet.getString("NAME"), resultSet.getString("ROLES")));
            }
            connection.commit();
        }
        return oAuth2Scopes;
    }

    public void addOAuth2ScopeBindings(Connection connection, List<OAuth2ScopeBinding> oAuth2ScopeBindings) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IDN_OAUTH2_SCOPE_BINDING (SCOPE_ID, SCOPE_BINDING) VALUES (?, ?)");){
            for (OAuth2ScopeBinding oAuth2ScopeBinding : oAuth2ScopeBindings) {
                preparedStatement.setInt(1, oAuth2ScopeBinding.getScopeId());
                preparedStatement.setString(2, oAuth2ScopeBinding.getScopeBinding());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }

    public void updateOAuth2Scopes(Connection connection, List<OAuth2Scope> updatedOAuth2Scopes) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH2_SCOPE SET NAME = ? WHERE SCOPE_ID = ? ");){
            for (OAuth2Scope oAuth2Scope : updatedOAuth2Scopes) {
                preparedStatement.setString(1, oAuth2Scope.getName());
                preparedStatement.setInt(2, oAuth2Scope.getScopeId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }
}

