/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v540.migrator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedLocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.LocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.AttributeMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v540.util.FileBasedClaimBuilder;
import org.wso2.carbon.is.migration.util.Utility;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;

public class ClaimDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(ClaimDataMigrator.class);
    private static final String CLAIM_CONFIG = "claim-config.xml";
    private ClaimConfig claimConfig;
    private ClaimDialectDAO claimDialectDAO = new ClaimDialectDAO();
    private CacheBackedLocalClaimDAO localClaimDAO = new CacheBackedLocalClaimDAO(new LocalClaimDAO());
    private CacheBackedExternalClaimDAO externalClaimDAO = new CacheBackedExternalClaimDAO(new ExternalClaimDAO());

    @Override
    public void migrate() throws MigrationClientException {
        String message;
        String filePath = Utility.getDataFilePath(CLAIM_CONFIG, this.getVersionConfig().getVersion());
        try {
            this.claimConfig = FileBasedClaimBuilder.buildClaimMappingsFromConfigFile(filePath);
        }
        catch (IOException | XMLStreamException | UserStoreException e) {
            message = "Error while building claims from config file";
            if (this.isContinueOnError()) {
                log.error((Object)message, e);
            }
            throw new MigrationClientException(message, e);
        }
        if (this.claimConfig.getClaims().isEmpty()) {
            log.info((Object)" WSO2 Product Migration Service Task : No data to migrate related with claim mappings.");
            return;
        }
        try {
            this.migrateClaimData(-1234);
            Set<Tenant> tenants = Utility.getTenants();
            List<Integer> inactiveTenants = Utility.getInactiveTenants();
            boolean ignoreForInactiveTenants = this.isIgnoreForInactiveTenants();
            HashSet<Integer> tenantRangeID = new HashSet<Integer>();
            if (Utility.isMigrateTenantRange()) {
                for (Tenant tenant : Utility.getTenants()) {
                    tenantRangeID.add(tenant.getId());
                }
            }
            for (Tenant tenant : tenants) {
                int tenantId = tenant.getId();
                if (ignoreForInactiveTenants && inactiveTenants.contains(tenantId)) {
                    log.info((Object)("Skipping claim data migration for Inactive tenant : " + tenantId));
                    continue;
                }
                if (Utility.isMigrateTenantRange() && !tenantRangeID.contains(tenantId)) {
                    log.info((Object)("Tenant " + tenantId + " is not in range, Skipping claim data migration."));
                    continue;
                }
                this.migrateClaimData(tenant.getId());
            }
        }
        catch (ClaimMetadataException | UserStoreException e) {
            message = "Error while migrating claim data";
            if (this.isContinueOnError()) {
                log.error((Object)message, e);
            }
            throw new MigrationClientException(message, e);
        }
    }

    private void migrateClaimData(int tenantId) throws UserStoreException, ClaimMetadataException {
        String claimDialectURI;
        UserRealm realm = ISMigrationServiceDataHolder.getRealmService().getTenantUserRealm(tenantId);
        String primaryDomainName = realm.getRealmConfiguration().getUserStoreProperty("DomainName");
        if (StringUtils.isBlank((String)primaryDomainName)) {
            primaryDomainName = "PRIMARY";
        }
        HashSet<String> claimDialects = new HashSet<String>();
        for (ClaimDialect claimDialect : this.claimDialectDAO.getClaimDialects(tenantId)) {
            claimDialects.add(claimDialect.getClaimDialectURI());
        }
        HashMap externalClaims = new HashMap();
        Set<Object> existingLocalClaimURIs = new HashSet();
        for (Map.Entry entry : this.claimConfig.getClaims().entrySet()) {
            String claimURI = (String)entry.getKey();
            ClaimMapping claimMapping = (ClaimMapping)entry.getValue();
            claimDialectURI = claimMapping.getClaim().getDialectURI();
            if ("http://wso2.org/claims".equals(claimDialectURI)) {
                if (existingLocalClaimURIs.isEmpty()) {
                    existingLocalClaimURIs = this.getExistingLocalClaimURIs(tenantId);
                }
                if (existingLocalClaimURIs.contains(claimURI)) {
                    log.warn((Object)(" WSO2 Product Migration Service Task : Local claim: " + claimURI + " already exists in the system for tenant: " + tenantId));
                    continue;
                }
                this.addLocalClaimMapping(tenantId, primaryDomainName, claimURI, claimMapping);
                existingLocalClaimURIs.add(claimURI);
                continue;
            }
            externalClaims.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, Set<Object>> existingExternalClaimURIs = new HashMap<String, Set<Object>>();
        for (Map.Entry entry : externalClaims.entrySet()) {
            String claimURI = (String)entry.getKey();
            claimDialectURI = ((ClaimMapping)entry.getValue()).getClaim().getDialectURI();
            if (!claimDialects.contains(claimDialectURI)) {
                this.claimDialectDAO.addClaimDialect(new ClaimDialect(claimDialectURI), tenantId);
                claimDialects.add(claimDialectURI);
                existingExternalClaimURIs.put(claimDialectURI, new HashSet());
            }
            if (existingExternalClaimURIs.get(claimDialectURI) == null) {
                existingExternalClaimURIs.put(claimDialectURI, this.getExistingExternalClaimURIs(tenantId, claimDialectURI));
            }
            if (((Set)existingExternalClaimURIs.get(claimDialectURI)).contains(claimURI)) {
                log.warn((Object)(" WSO2 Product Migration Service Task : External claim: " + claimURI + " already exists in the system for dialect: " + claimDialectURI + " in tenant: " + tenantId));
                continue;
            }
            this.addExternalClaimMapping(tenantId, claimURI, claimDialectURI);
            ((Set)existingExternalClaimURIs.get(claimDialectURI)).add(claimURI);
        }
    }

    private Set<String> getExistingLocalClaimURIs(int tenantId) throws ClaimMetadataException {
        HashSet<String> localClaimURIs = new HashSet<String>();
        for (LocalClaim localClaim : this.localClaimDAO.getLocalClaims(tenantId)) {
            localClaimURIs.add(localClaim.getClaimURI());
        }
        return localClaimURIs;
    }

    private Set<String> getExistingExternalClaimURIs(int tenantId, String claimDialectURI) throws ClaimMetadataException {
        HashSet<String> externalClaimURIs = new HashSet<String>();
        for (ExternalClaim externalClaim : this.externalClaimDAO.getExternalClaims(claimDialectURI, tenantId)) {
            externalClaimURIs.add(externalClaim.getClaimURI());
        }
        return externalClaimURIs;
    }

    private void addLocalClaimMapping(int tenantId, String primaryDomainName, String claimURI, ClaimMapping claimMapping) throws ClaimMetadataException {
        ArrayList<AttributeMapping> mappedAttributes = new ArrayList<AttributeMapping>();
        if (StringUtils.isNotBlank((String)claimMapping.getMappedAttribute())) {
            mappedAttributes.add(new AttributeMapping(primaryDomainName, claimMapping.getMappedAttribute()));
        }
        if (claimMapping.getMappedAttributes() != null) {
            for (Map.Entry claimMappingEntry : claimMapping.getMappedAttributes().entrySet()) {
                mappedAttributes.add(new AttributeMapping((String)claimMappingEntry.getKey(), (String)claimMappingEntry.getValue()));
            }
        }
        Map claimProperties = (Map)this.claimConfig.getPropertyHolder().get(claimURI);
        claimProperties.remove("Dialect");
        claimProperties.remove("ClaimURI");
        claimProperties.remove("AttributeID");
        if (!claimProperties.containsKey("DisplayName")) {
            claimProperties.put("DisplayName", "0");
        }
        if (claimProperties.containsKey("SupportedByDefault") && StringUtils.isBlank((String)((String)claimProperties.get("SupportedByDefault")))) {
            claimProperties.put("SupportedByDefault", "true");
        }
        if (claimProperties.containsKey("ReadOnly") && StringUtils.isBlank((String)((String)claimProperties.get("ReadOnly")))) {
            claimProperties.put("ReadOnly", "true");
        }
        if (claimProperties.containsKey("Required") && StringUtils.isBlank((String)((String)claimProperties.get("Required")))) {
            claimProperties.put("Required", "true");
        }
        LocalClaim localClaim = new LocalClaim(claimURI, mappedAttributes, claimProperties);
        this.localClaimDAO.addLocalClaim(localClaim, tenantId);
    }

    private void addExternalClaimMapping(int tenantId, String claimURI, String claimDialectURI) throws ClaimMetadataException {
        String mappedLocalClaimURI = (String)((Map)this.claimConfig.getPropertyHolder().get(claimURI)).get("MappedLocalClaim");
        ExternalClaim externalClaim = new ExternalClaim(claimDialectURI, claimURI, mappedLocalClaimURI);
        this.externalClaimDAO.addExternalClaim(externalClaim, tenantId);
    }
}

