/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v540.migrator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v540.bean.OAuth2Scope;
import org.wso2.carbon.is.migration.service.v540.bean.OAuth2ScopeBinding;
import org.wso2.carbon.is.migration.service.v540.bean.OAuthConsumerApp;
import org.wso2.carbon.is.migration.service.v540.bean.SpOAuth2ExpiryTimeConfiguration;
import org.wso2.carbon.is.migration.service.v540.dao.OAuthDAO;
import org.wso2.carbon.is.migration.service.v540.util.RegistryUtil;
import org.wso2.carbon.is.migration.util.Utility;
import org.wso2.carbon.user.api.Tenant;

public class OAuthDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(OAuthDataMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        String message;
        try {
            this.migrateOAuthConsumerAppData();
        }
        catch (Exception e) {
            message = "Error occurred while migrating OAuth consumer apps.";
            if (this.isContinueOnError()) {
                log.error((Object)message, (Throwable)e);
            }
            throw new MigrationClientException(message, (Throwable)e);
        }
        try {
            this.migrateOAuth2ScopeData();
        }
        catch (Exception e) {
            message = "Error occurred while migrating OAuth2 scope data.";
            if (this.isContinueOnError()) {
                log.error((Object)message, (Throwable)e);
            }
            throw new MigrationClientException(message, (Throwable)e);
        }
    }

    private void migrateOAuthConsumerAppData() throws MigrationClientException, SQLException {
        List<OAuthConsumerApp> consumerApps;
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 consumer apps table.");
        try (Connection connection = this.getDataSource().getConnection();){
            consumerApps = OAuthDAO.getInstance().getAllOAuthConsumerApps(connection);
        }
        if (consumerApps.isEmpty()) {
            log.info((Object)" WSO2 Product Migration Service Task : No data to migrate in OAuth2 consumer apps table.");
            return;
        }
        ArrayList<OAuthConsumerApp> updatedConsumerApps = new ArrayList<OAuthConsumerApp>();
        long applicationAccessTokenExpiryTime = 3600L;
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"OAuth.AccessTokenDefaultValidityPeriod"))) {
            applicationAccessTokenExpiryTime = Long.parseLong(IdentityUtil.getProperty((String)"OAuth.AccessTokenDefaultValidityPeriod"));
        }
        long userAccessTokenExpiryTime = 3600L;
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"OAuth.UserAccessTokenDefaultValidityPeriod"))) {
            userAccessTokenExpiryTime = Long.parseLong(IdentityUtil.getProperty((String)"OAuth.UserAccessTokenDefaultValidityPeriod"));
        }
        long refreshTokenExpiryTime = 84600L;
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"OAuth.RefreshTokenValidityPeriod"))) {
            refreshTokenExpiryTime = Long.parseLong(IdentityUtil.getProperty((String)"OAuth.RefreshTokenValidityPeriod"));
        }
        boolean ignoreForInactiveTenants = this.isIgnoreForInactiveTenants();
        List<Integer> inactiveTenants = Utility.getInactiveTenants();
        HashSet<Integer> tenantRangeID = new HashSet<Integer>();
        if (Utility.isMigrateTenantRange()) {
            for (Tenant tenant : Utility.getTenants()) {
                tenantRangeID.add(tenant.getId());
            }
        }
        for (OAuthConsumerApp consumerApp : consumerApps) {
            if (ignoreForInactiveTenants && inactiveTenants.contains(consumerApp.getTenantId())) {
                log.info((Object)("Skipping OAuth2 consumer apps table migration for inactive tenant: " + consumerApp.getTenantId()));
                continue;
            }
            if (Utility.isMigrateTenantRange() && !tenantRangeID.contains(consumerApp.getTenantId())) {
                log.info((Object)("Skipping OAuth2 consumer apps table migration for tenant : " + consumerApp.getTenantId()));
                continue;
            }
            SpOAuth2ExpiryTimeConfiguration expiryTimeConfiguration = RegistryUtil.getSpTokenExpiryTimeConfig(consumerApp.getConsumerKey(), consumerApp.getTenantId());
            if (expiryTimeConfiguration.getApplicationAccessTokenExpiryTime() != null) {
                consumerApp.setApplicationAccessTokenExpiryTime(expiryTimeConfiguration.getApplicationAccessTokenExpiryTime() / 1000L);
            } else {
                consumerApp.setApplicationAccessTokenExpiryTime(applicationAccessTokenExpiryTime);
            }
            if (expiryTimeConfiguration.getUserAccessTokenExpiryTime() != null) {
                consumerApp.setUserAccessTokenExpiryTime(expiryTimeConfiguration.getApplicationAccessTokenExpiryTime() / 1000L);
            } else {
                consumerApp.setUserAccessTokenExpiryTime(userAccessTokenExpiryTime);
            }
            if (expiryTimeConfiguration.getRefreshTokenExpiryTime() != null) {
                consumerApp.setRefreshTokenExpiryTime(expiryTimeConfiguration.getApplicationAccessTokenExpiryTime() / 1000L);
            } else {
                consumerApp.setRefreshTokenExpiryTime(refreshTokenExpiryTime);
            }
            updatedConsumerApps.add(consumerApp);
        }
        if (!updatedConsumerApps.isEmpty()) {
            try (Connection connection = this.getDataSource().getConnection();){
                OAuthDAO.getInstance().updateExpiryTimesDefinedForOAuthConsumerApps(connection, updatedConsumerApps);
            }
        }
        log.info((Object)" WSO2 Product Migration Service Task : Migration succeeded for OAuth2 consumer apps table.");
    }

    private void migrateOAuth2ScopeData() throws MigrationClientException, SQLException {
        Throwable throwable;
        Connection connection;
        List<OAuth2Scope> oAuth2Scopes;
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 Scope table.");
        try (Connection connection2 = this.getDataSource().getConnection();){
            oAuth2Scopes = OAuthDAO.getInstance().getAllOAuth2Scopes(connection2);
        }
        if (oAuth2Scopes.isEmpty()) {
            log.info((Object)" WSO2 Product Migration Service Task : No data to migrate in OAuth2 Scope table.");
            return;
        }
        ArrayList<OAuth2ScopeBinding> oAuth2ScopeBindings = new ArrayList<OAuth2ScopeBinding>();
        ArrayList<OAuth2Scope> updatedAuth2Scopes = new ArrayList<OAuth2Scope>();
        for (OAuth2Scope oAuth2Scope : oAuth2Scopes) {
            if (StringUtils.isNotBlank((String)oAuth2Scope.getRoles())) {
                String[] roles;
                for (String role : roles = oAuth2Scope.getRoles().split(",")) {
                    oAuth2ScopeBindings.add(new OAuth2ScopeBinding(oAuth2Scope.getScopeId(), role));
                }
            }
            if (!StringUtils.isBlank((String)oAuth2Scope.getName())) continue;
            oAuth2Scope.setName(oAuth2Scope.getScopeKey());
            updatedAuth2Scopes.add(oAuth2Scope);
        }
        if (!oAuth2ScopeBindings.isEmpty()) {
            connection = this.getDataSource().getConnection();
            throwable = null;
            try {
                OAuthDAO.getInstance().addOAuth2ScopeBindings(connection, oAuth2ScopeBindings);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        if (!updatedAuth2Scopes.isEmpty()) {
            connection = this.getDataSource().getConnection();
            throwable = null;
            try {
                OAuthDAO.getInstance().updateOAuth2Scopes(connection, updatedAuth2Scopes);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        log.info((Object)" WSO2 Product Migration Service Task : Migration succeeded on OAuth2 Scope table.");
    }
}

