/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v540.migrator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v540.bean.Permission;
import org.wso2.carbon.is.migration.service.v540.bean.RolePermission;
import org.wso2.carbon.is.migration.service.v540.bean.UserPermission;
import org.wso2.carbon.is.migration.util.Utility;

public class PermissionMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(PermissionMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        try (Connection connection = this.getDataSource().getConnection();){
            connection.setAutoCommit(false);
            List<Permission> duplicatedPermissions = this.getDuplicatedPermissions(connection);
            if (duplicatedPermissions.isEmpty()) {
                log.info((Object)" WSO2 Product Migration Service Task :  Permission migration is not required.");
                return;
            }
            log.info((Object)(" WSO2 Product Migration Service Task :  Found " + duplicatedPermissions.size() + " duplicated permissions."));
            List<RolePermission> duplicatedRolePermissions = this.getDuplicatedRolePermissions(connection, duplicatedPermissions);
            if (!duplicatedRolePermissions.isEmpty()) {
                log.info((Object)(" WSO2 Product Migration Service Task :  Found " + duplicatedPermissions.size() + " duplicated role permissions."));
                this.deleteDuplicatedRolePermissions(connection, duplicatedRolePermissions);
                log.info((Object)" WSO2 Product Migration Service Task :  Removed duplicated role permissions.");
            }
            this.updateRolePermissionTable(connection, duplicatedPermissions);
            List<UserPermission> duplicatedUserPermissions = this.getDuplicatedUserPermissions(connection, duplicatedPermissions);
            if (!duplicatedUserPermissions.isEmpty()) {
                log.info((Object)(" WSO2 Product Migration Service Task :  Found " + duplicatedUserPermissions.size() + " duplicated user permissions."));
                this.deleteDuplicatedUserPermissions(connection, duplicatedUserPermissions);
                log.info((Object)" WSO2 Product Migration Service Task :  Removed duplicated user permissions.");
            }
            this.updateUserPermissionTable(connection, duplicatedPermissions);
            this.deleteDuplicatedPermissions(connection, duplicatedPermissions);
            connection.commit();
            log.info((Object)" WSO2 Product Migration Service Task :  Permission migration is successful.");
        }
        catch (SQLException e) {
            throw new MigrationClientException("Failed to migrate permissions.", (Throwable)e);
        }
    }

    private List<Permission> getDuplicatedPermissions(Connection connection) throws MigrationClientException, SQLException {
        List<Permission> allPermissions = this.getAllPermissions(connection);
        ArrayList<Permission> uniquePermissions = new ArrayList<Permission>();
        ArrayList<Permission> duplicatedPermissions = new ArrayList<Permission>();
        for (Permission permission : allPermissions) {
            if (uniquePermissions.contains(permission)) {
                permission.setUniqueId(((Permission)uniquePermissions.get(uniquePermissions.indexOf(permission))).getId());
                duplicatedPermissions.add(permission);
                continue;
            }
            uniquePermissions.add(permission);
        }
        return duplicatedPermissions;
    }

    public List<RolePermission> getDuplicatedRolePermissions(Connection connection, List<Permission> duplicatedPermissions) throws MigrationClientException, SQLException {
        List<RolePermission> allRolePermissions = this.getAllRolePermissions(connection);
        ArrayList<RolePermission> uniqueRolePermissions = new ArrayList<RolePermission>();
        ArrayList<RolePermission> duplicatedRolePermissions = new ArrayList<RolePermission>();
        HashMap<Integer, Permission> duplicatedPermissionMap = new HashMap<Integer, Permission>();
        for (Permission permission : duplicatedPermissions) {
            duplicatedPermissionMap.put(permission.getId(), permission);
        }
        for (RolePermission rolePermission : allRolePermissions) {
            if (!duplicatedPermissionMap.containsKey(rolePermission.getPermissionId())) continue;
            rolePermission.setPermissionId(((Permission)duplicatedPermissionMap.get(rolePermission.getPermissionId())).getUniqueId());
        }
        for (RolePermission rolePermission : allRolePermissions) {
            if (uniqueRolePermissions.contains(rolePermission)) {
                duplicatedRolePermissions.add(rolePermission);
                continue;
            }
            uniqueRolePermissions.add(rolePermission);
        }
        return duplicatedRolePermissions;
    }

    private List<UserPermission> getDuplicatedUserPermissions(Connection connection, List<Permission> duplicatedPermissions) throws MigrationClientException, SQLException {
        List<UserPermission> allUserPermissions = this.getAllUserPermissions(connection);
        ArrayList<UserPermission> uniqueUserPermissions = new ArrayList<UserPermission>();
        ArrayList<UserPermission> duplicatedUserPermissions = new ArrayList<UserPermission>();
        HashMap<Integer, Permission> duplicatedPermissionMap = new HashMap<Integer, Permission>();
        for (Permission permission : duplicatedPermissions) {
            duplicatedPermissionMap.put(permission.getId(), permission);
        }
        for (UserPermission userPermission : allUserPermissions) {
            if (!duplicatedPermissionMap.containsKey(userPermission.getPermissionId())) continue;
            userPermission.setPermissionId(((Permission)duplicatedPermissionMap.get(userPermission.getPermissionId())).getUniqueId());
        }
        for (UserPermission userPermission : allUserPermissions) {
            if (uniqueUserPermissions.contains(userPermission)) {
                duplicatedUserPermissions.add(userPermission);
                continue;
            }
            uniqueUserPermissions.add(userPermission);
        }
        return duplicatedUserPermissions;
    }

    private List<Permission> getAllPermissions(Connection connection) throws MigrationClientException, SQLException {
        ArrayList<Permission> allPermissions = new ArrayList<Permission>();
        try (PreparedStatement statement = connection.prepareStatement(this.getPermissionSelectQuery());
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                Permission permission = new Permission(resultSet.getInt("UM_ID"), resultSet.getString("UM_RESOURCE_ID"), resultSet.getString("UM_ACTION"), resultSet.getInt("UM_TENANT_ID"));
                allPermissions.add(permission);
            }
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to retrieve all permissions.", (Throwable)e);
        }
        return allPermissions;
    }

    private List<RolePermission> getAllRolePermissions(Connection connection) throws MigrationClientException, SQLException {
        ArrayList<RolePermission> allRolePermissions = new ArrayList<RolePermission>();
        try (PreparedStatement statement = connection.prepareStatement(this.getRolePermissionSelectQuery());
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                RolePermission rolePermission = new RolePermission(resultSet.getInt("UM_ID"), resultSet.getInt("UM_PERMISSION_ID"), resultSet.getString("UM_ROLE_NAME"), resultSet.getInt("UM_TENANT_ID"), resultSet.getInt("UM_DOMAIN_ID"));
                allRolePermissions.add(rolePermission);
            }
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to retrieve all role permissions.", (Throwable)e);
        }
        return allRolePermissions;
    }

    private List<UserPermission> getAllUserPermissions(Connection connection) throws MigrationClientException, SQLException {
        ArrayList<UserPermission> allUserPermissions = new ArrayList<UserPermission>();
        try (PreparedStatement statement = connection.prepareStatement(this.getUserPermissionSelectQuery());
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                UserPermission userPermission = new UserPermission(resultSet.getInt("UM_ID"), resultSet.getInt("UM_PERMISSION_ID"), resultSet.getString("UM_USER_NAME"), resultSet.getInt("UM_TENANT_ID"));
                allUserPermissions.add(userPermission);
            }
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to retrieve all user permissions.", (Throwable)e);
        }
        return allUserPermissions;
    }

    private String getPermissionSelectQuery() throws MigrationClientException {
        if (Utility.isMigrateTenantRange()) {
            return "SELECT UM_ID, UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID FROM UM_PERMISSION WHERE UM_TENANT_ID IN (" + StringUtils.join(this.getSelectedTenants(), (String)",") + ")";
        }
        return "SELECT UM_ID, UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID FROM UM_PERMISSION";
    }

    private String getRolePermissionSelectQuery() throws MigrationClientException {
        if (Utility.isMigrateTenantRange()) {
            return "SELECT UM_ID, UM_PERMISSION_ID, UM_ROLE_NAME, UM_TENANT_ID, UM_DOMAIN_ID FROM UM_ROLE_PERMISSION WHERE UM_TENANT_ID IN (" + StringUtils.join(this.getSelectedTenants(), (String)",") + ")";
        }
        return "SELECT UM_ID, UM_PERMISSION_ID, UM_ROLE_NAME, UM_TENANT_ID, UM_DOMAIN_ID FROM UM_ROLE_PERMISSION";
    }

    private String getUserPermissionSelectQuery() throws MigrationClientException {
        if (Utility.isMigrateTenantRange()) {
            return "SELECT UM_ID, UM_PERMISSION_ID, UM_USER_NAME, UM_TENANT_ID FROM UM_USER_PERMISSION WHERE UM_TENANT_ID IN (" + StringUtils.join(this.getSelectedTenants(), (String)",") + ")";
        }
        return "SELECT UM_ID, UM_PERMISSION_ID, UM_USER_NAME, UM_TENANT_ID FROM UM_USER_PERMISSION";
    }

    private List<Integer> getSelectedTenants() throws MigrationClientException {
        int startingTenantID = Utility.getMigrationStartingTenantID();
        int endingTenantID = Utility.getMigrationEndingTenantID();
        if (startingTenantID != -1234 && startingTenantID <= 0 || endingTenantID != -1234 && endingTenantID <= 0 || startingTenantID > endingTenantID) {
            throw new MigrationClientException("Provided tenant range is invalid.");
        }
        ArrayList<Integer> selectedTenants = new ArrayList<Integer>();
        if (startingTenantID == -1234) {
            selectedTenants.add(-1234);
            startingTenantID = 1;
        }
        for (int i = startingTenantID; i <= endingTenantID; ++i) {
            selectedTenants.add(i);
        }
        return selectedTenants;
    }

    private void updateRolePermissionTable(Connection connection, List<Permission> permissions) throws SQLException, MigrationClientException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE UM_ROLE_PERMISSION SET UM_PERMISSION_ID = ? WHERE UM_PERMISSION_ID = ? AND UM_TENANT_ID = ?");){
            this.fillPreparedStatement(permissions, statement);
            statement.executeBatch();
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to update permission ids for roles.", (Throwable)e);
        }
    }

    private void updateUserPermissionTable(Connection connection, List<Permission> permissions) throws SQLException, MigrationClientException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE UM_USER_PERMISSION SET UM_PERMISSION_ID = ? WHERE UM_PERMISSION_ID = ? AND UM_TENANT_ID = ?");){
            this.fillPreparedStatement(permissions, statement);
            statement.executeBatch();
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to update permission ids for users.", (Throwable)e);
        }
    }

    private void fillPreparedStatement(List<Permission> permissions, PreparedStatement statement) throws SQLException {
        for (Permission permission : permissions) {
            statement.setInt(1, permission.getUniqueId());
            statement.setInt(2, permission.getId());
            statement.setInt(3, permission.getTenantId());
            statement.addBatch();
        }
    }

    private void deleteDuplicatedPermissions(Connection connection, List<Permission> permissions) throws SQLException, MigrationClientException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM UM_PERMISSION WHERE UM_ID = ?");){
            for (Permission permission : permissions) {
                statement.setInt(1, permission.getId());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to delete duplicated permissions.", (Throwable)e);
        }
    }

    private void deleteDuplicatedRolePermissions(Connection connection, List<RolePermission> duplicatedRolePermissions) throws MigrationClientException, SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM UM_ROLE_PERMISSION WHERE UM_ID = ?");){
            for (RolePermission rolePermission : duplicatedRolePermissions) {
                statement.setInt(1, rolePermission.getId());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to delete duplicated role permissions.", (Throwable)e);
        }
    }

    private void deleteDuplicatedUserPermissions(Connection connection, List<UserPermission> duplicatedUserPermissions) throws MigrationClientException, SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM UM_USER_PERMISSION WHERE UM_ID = ?");){
            for (UserPermission userPermission : duplicatedUserPermissions) {
                statement.setInt(1, userPermission.getId());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            connection.rollback();
            throw new MigrationClientException("Failed to delete duplicated user permissions.", (Throwable)e);
        }
    }
}

