/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v540.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimKey;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;

public class FileBasedClaimBuilder {
    private static final String LOCAL_NAME_DIALECTS = "Dialects";
    private static final String LOCAL_NAME_DIALECT = "Dialect";
    private static final String LOCAL_NAME_CLAIM = "Claim";
    private static final String LOCAL_NAME_CLAIM_URI = "ClaimURI";
    private static final String LOCAL_NAME_ATTR_ID = "AttributeID";
    private static final String ATTR_DIALECT_URI = "dialectURI";

    private FileBasedClaimBuilder() {
    }

    public static ClaimConfig buildClaimMappingsFromConfigFile(String filePath) throws IOException, XMLStreamException, UserStoreException {
        HashMap<ClaimKey, ClaimMapping> claims = new HashMap<ClaimKey, ClaimMapping>();
        HashMap propertyHolder = new HashMap();
        OMElement dom = FileBasedClaimBuilder.getRootElement(filePath);
        Iterator dialectsIterator = dom.getChildrenWithName(new QName(LOCAL_NAME_DIALECTS));
        while (dialectsIterator.hasNext()) {
            OMElement dialects = (OMElement)dialectsIterator.next();
            Iterator dialectIterator = dialects.getChildrenWithName(new QName(LOCAL_NAME_DIALECT));
            while (dialectIterator.hasNext()) {
                OMElement dialect = (OMElement)dialectIterator.next();
                String dialectUri = dialect.getAttributeValue(new QName(ATTR_DIALECT_URI));
                Iterator claimsIterator = dialect.getChildrenWithName(new QName(LOCAL_NAME_CLAIM));
                while (claimsIterator.hasNext()) {
                    String claimUri = null;
                    String attributeId = null;
                    OMElement claimElement = (OMElement)claimsIterator.next();
                    FileBasedClaimBuilder.validateSchema(claimElement);
                    Claim claim = new Claim();
                    claim.setDialectURI(dialectUri);
                    Iterator metadataIterator = claimElement.getChildElements();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    while (metadataIterator.hasNext()) {
                        OMElement metadata = (OMElement)metadataIterator.next();
                        String key = metadata.getQName().toString();
                        String value = metadata.getText();
                        if (key.equals(LOCAL_NAME_CLAIM_URI)) {
                            claim.setClaimUri(value);
                            claimUri = value;
                        }
                        if (key.equals(LOCAL_NAME_ATTR_ID)) {
                            attributeId = value;
                        }
                        properties.put(key, value);
                        properties.put(LOCAL_NAME_DIALECT, dialectUri);
                    }
                    ClaimKey claimKey = new ClaimKey();
                    claimKey.setClaimUri(claimUri);
                    claimKey.setDialectUri(dialectUri);
                    propertyHolder.put(claimKey, properties);
                    ClaimMapping claimMapping = new ClaimMapping();
                    claimMapping.setClaim((org.wso2.carbon.user.api.Claim)claim);
                    FileBasedClaimBuilder.setMappedAttributes(claimMapping, attributeId);
                    claims.put(claimKey, claimMapping);
                }
            }
        }
        ClaimConfig claimConfig = new ClaimConfig();
        claimConfig.setClaimMap(claims);
        claimConfig.setPropertyHolderMap(propertyHolder);
        return claimConfig;
    }

    private static void validateSchema(OMElement claimElement) throws UserStoreException {
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_CLAIM_URI)) == null) {
            throw new UserStoreException("In valid schema <ClaimUri> element not present");
        }
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_ATTR_ID)) == null) {
            throw new UserStoreException("In valid schema <AttributeId> element not present");
        }
    }

    private static OMElement getRootElement(String filePath) throws XMLStreamException, IOException {
        File claimConfigFile = new File(filePath);
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(claimConfigFile));
        return new StAXOMBuilder((InputStream)inStream).getDocumentElement();
    }

    private static void setMappedAttributes(ClaimMapping claimMapping, String mappedAttribute) {
        if (mappedAttribute != null) {
            String[] attributes = mappedAttribute.split(";");
            HashMap<String, String> attrMap = new HashMap<String, String>();
            for (String attribute : attributes) {
                int index = attribute.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
                if (index > 1 && attribute.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) == attribute.lastIndexOf(UserCoreConstants.DOMAIN_SEPARATOR)) {
                    String domain = attribute.substring(0, index);
                    String attrName = attribute.substring(index + 1);
                    attrMap.put(domain.toUpperCase(), attrName);
                    continue;
                }
                claimMapping.setMappedAttribute(attribute);
            }
            if (attrMap.size() > 0) {
                claimMapping.setMappedAttributes(attrMap);
            }
        }
    }
}

