/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v540.util;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.is.migration.service.v540.bean.SpOAuth2ExpiryTimeConfiguration;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryUtil {
    private static Log log = LogFactory.getLog(RegistryUtil.class);
    private static final String TOKEN_EXPIRE_TIME_RESOURCE_PATH = "/identity/config/spTokenExpireTime";
    private static final String USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS = "userAccessTokenExpireTime";
    private static final String REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS = "refreshTokenExpireTime";
    private static final String APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS = "applicationAccessTokenExpireTime";

    private RegistryUtil() {
    }

    public static SpOAuth2ExpiryTimeConfiguration getSpTokenExpiryTimeConfig(String consumerKey, int tenantId) {
        SpOAuth2ExpiryTimeConfiguration spTokenTimeObject;
        block16: {
            spTokenTimeObject = new SpOAuth2ExpiryTimeConfiguration();
            try {
                String errorMsg;
                JSONObject spTimeObject;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SP wise token expiry time feature is applied for tenant id : " + tenantId + "and consumer key : " + consumerKey));
                }
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)IdentityTenantUtil.getTenantDomain((int)tenantId));
                Registry registry = IdentityTenantUtil.getConfigRegistry((int)tenantId);
                if (!registry.resourceExists(TOKEN_EXPIRE_TIME_RESOURCE_PATH)) break block16;
                Resource resource = registry.get(TOKEN_EXPIRE_TIME_RESOURCE_PATH);
                String jsonString = "{}";
                Object consumerKeyObject = resource.getProperties().get(consumerKey);
                if (consumerKeyObject instanceof List && !((List)consumerKeyObject).isEmpty()) {
                    jsonString = ((List)consumerKeyObject).get(0).toString();
                }
                if ((spTimeObject = new JSONObject(jsonString)).length() <= 0) break block16;
                if (spTimeObject.has(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS) && !spTimeObject.isNull(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS)) {
                    try {
                        spTokenTimeObject.setUserAccessTokenExpiryTime(Long.parseLong(spTimeObject.get(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString()));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The user access token expiry time :" + spTimeObject.get(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString() + "  for application id : " + consumerKey));
                        }
                    }
                    catch (NumberFormatException e) {
                        errorMsg = String.format("Invalid value provided as user access token expiry time for consumer key %s, tenant id : %d. Given value: %s, Expected a long value", consumerKey, tenantId, spTimeObject.get(USER_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString());
                        log.error((Object)errorMsg, (Throwable)e);
                    }
                }
                if (spTimeObject.has(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS) && !spTimeObject.isNull(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS)) {
                    try {
                        spTokenTimeObject.setApplicationAccessTokenExpiryTime(Long.parseLong(spTimeObject.get(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString()));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The application access token expiry time :" + spTimeObject.get(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString() + "  for application id : " + consumerKey));
                        }
                    }
                    catch (NumberFormatException e) {
                        errorMsg = String.format("Invalid value provided as application access token expiry time for consumer key %s, tenant id : %d. Given value: %s, Expected a long value ", consumerKey, tenantId, spTimeObject.get(APPLICATION_ACCESS_TOKEN_EXP_TIME_IN_MILLISECONDS).toString());
                        log.error((Object)errorMsg, (Throwable)e);
                    }
                }
                if (!spTimeObject.has(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS) || spTimeObject.isNull(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS)) break block16;
                try {
                    spTokenTimeObject.setRefreshTokenExpiryTime(Long.parseLong(spTimeObject.get(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS).toString()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The refresh token expiry time :" + spTimeObject.get(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS).toString() + " for application id : " + consumerKey));
                    }
                }
                catch (NumberFormatException e) {
                    errorMsg = String.format("Invalid value provided as refresh token expiry time for consumer key %s, tenant id : %d. Given value: %s, Expected a long value", consumerKey, tenantId, spTimeObject.get(REFRESH_TOKEN_EXP_TIME_IN_MILLISECONDS).toString());
                    log.error((Object)errorMsg, (Throwable)e);
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Error while getting data from the registry.", (Throwable)e);
            }
            catch (IdentityException e) {
                log.error((Object)("Error while getting the tenant domain from tenant id : " + tenantId), (Throwable)e);
            }
        }
        return spTokenTimeObject;
    }
}

