/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.is.migration.service.v550.util.EncryptionUtil;
import org.wso2.carbon.is.migration.util.Utility;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;

public class RegistryDataManager {
    private static final String STS_SERVICE_GROUP = "org.wso2.carbon.sts";
    private static final Log log = LogFactory.getLog(RegistryDataManager.class);
    private static final String SERVICE_PRINCIPAL_PASSWORD = "service.principal.password";
    private static final String KERBEROS = "Kerberos";
    private static final String NAME = "name";
    private static final String PASSWORD = "password";
    private static final String SUBSCRIBER_PASSWORD = "subscriberPassword";
    private static final String PRIVATE_KEY_PASS = "privatekeyPass";
    private static final String POLICY_PUBLISHER_RESOURCE_PATH = "/repository/identity/entitlement/publisher/";
    private static final String KEYSTORE_RESOURCE_PATH = "/repository/security/key-stores/";
    private static final String SYSLOG = "/repository/components/org.wso2.carbon.logging/loggers/syslog/SYSLOG_PROPERTIES";
    private static final String SECURITY_POLICY_RESOURCE_PATH = "/services/wso2carbon-sts/policies/";
    private static final String SERVICE_GROUPS_PATH = "/repository/axis2/service-groups/";
    private static final String CARBON_SEC_CONFIG = "CarbonSecConfig";
    private static RegistryDataManager instance = new RegistryDataManager();

    private RegistryDataManager() {
    }

    public static RegistryDataManager getInstance() {
        return instance;
    }

    private void startTenantFlow(Tenant tenant) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(tenant.getId());
        carbonContext.setTenantDomain(tenant.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateSubscriberPassword(boolean migrateActiveTenantsOnly) throws UserStoreException, MigrationClientException {
        try {
            this.migrateSubscriberDataForTenant(-1234);
            log.info((Object)"Policy Subscribers migrated for tenant : carbon.super");
        }
        catch (Exception e) {
            log.error((Object)"Error while migrating Policy Subscribers for tenant : carbon.super", (Throwable)e);
        }
        Set<Tenant> tenants = Utility.getTenants();
        for (Tenant tenant : tenants) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping Subscriber migration!"));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                this.migrateSubscriberDataForTenant(tenant.getId());
                log.info((Object)("Subscribers migrated for tenant : " + tenant.getDomain()));
            }
            catch (Exception e) {
                log.error((Object)("Error while migrating Subscribers for tenant : " + tenant.getDomain()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public void migrateKeyStorePassword(boolean migrateActiveTenantsOnly) throws Exception {
        try {
            this.migrateKeyStorePasswordForTenant(-1234);
            log.info((Object)"Keystore passwords migrated for tenant finished : carbon.super");
        }
        catch (Exception e) {
            log.error((Object)"Error while migrating Keystore passwords for tenant : carbon.super");
            throw e;
        }
        Set<Tenant> tenants = Utility.getTenants();
        for (Tenant tenant : tenants) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping keystore passwords migration!"));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                this.migrateKeyStorePasswordForTenant(tenant.getId());
                log.info((Object)("Keystore passwords migrated for tenant finished : " + tenant.getDomain()));
            }
            catch (Exception e) {
                log.error((Object)("Error while migrating keystore passwords for tenant : " + tenant.getDomain()));
                throw e;
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateSysLogPropertyPassword(boolean migrateActiveTenantsOnly) throws UserStoreException, RegistryException, CryptoException, MigrationClientException {
        try {
            this.migrateSysLogPropertyPasswordForTenant(-1234);
            log.info((Object)"Sys log property password migrated for tenant : carbon.super");
        }
        catch (Exception e) {
            log.error((Object)"Error while migrating Sys log property password for tenant : carbon.super", (Throwable)e);
        }
        Set<Tenant> tenants = Utility.getTenants();
        for (Tenant tenant : tenants) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping SYSLOG_PROPERTIES file migration. "));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                this.migrateSysLogPropertyPasswordForTenant(tenant.getId());
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateServicePrinciplePassword(boolean migrateActiveTenantsOnly) throws CryptoException, RegistryException, UserStoreException, MigrationClientException {
        try {
            this.updateSecurityPolicyPassword(-1234);
            log.info((Object)"Policy Subscribers migrated for tenant : carbon.super");
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error while migrating Policy Subscribers for tenant : carbon.super", (Throwable)e);
        }
        Set<Tenant> tenants = Utility.getTenants();
        for (Tenant tenant : tenants) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping Service Principle Password migration!"));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                this.updateSecurityPolicyPassword(tenant.getId());
                log.info((Object)("Service Principle Passwords migrated for tenant : " + tenant.getDomain()));
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error while migrating Service Principle Passwords for tenant : " + tenant.getDomain()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private void migrateKeyStorePasswordForTenant(int tenantId) throws RegistryException, CryptoException {
        IdentityTenantUtil.getTenantRegistryLoader().loadTenantRegistry(tenantId);
        UserRegistry registry = IdentityTenantUtil.getRegistryService().getGovernanceSystemRegistry(tenantId);
        if (registry.resourceExists(KEYSTORE_RESOURCE_PATH)) {
            Collection keyStoreCollection = (Collection)registry.get(KEYSTORE_RESOURCE_PATH);
            for (String keyStorePath : keyStoreCollection.getChildren()) {
                this.updateRegistryProperties((Registry)registry, keyStorePath, new ArrayList<String>(Arrays.asList(PASSWORD, PRIVATE_KEY_PASS)));
            }
            log.info((Object)("keystore migration successful for tenant : " + IdentityTenantUtil.getTenantDomain((int)tenantId)));
        }
    }

    private void migrateSubscriberDataForTenant(int tenantId) throws RegistryException, CryptoException {
        UserRegistry registry = IdentityTenantUtil.getRegistryService().getGovernanceSystemRegistry(tenantId);
        if (registry.resourceExists(POLICY_PUBLISHER_RESOURCE_PATH)) {
            Collection subscriberCollection = (Collection)registry.get(POLICY_PUBLISHER_RESOURCE_PATH);
            for (String subscriberPath : subscriberCollection.getChildren()) {
                this.updateRegistryProperties((Registry)registry, subscriberPath, new ArrayList<String>(Arrays.asList(SUBSCRIBER_PASSWORD)));
            }
        }
    }

    private void migrateSysLogPropertyPasswordForTenant(int tenantId) throws RegistryException, CryptoException {
        UserRegistry registry = IdentityTenantUtil.getRegistryService().getConfigSystemRegistry(tenantId);
        this.updateRegistryProperties((Registry)registry, SYSLOG, new ArrayList<String>(Arrays.asList(PASSWORD)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityPolicyPassword(int tenantId) throws RegistryException, CryptoException, XMLStreamException {
        InputStream resourceContent = null;
        XMLStreamReader parser = null;
        try {
            UserRegistry registry = IdentityTenantUtil.getRegistryService().getConfigSystemRegistry(tenantId);
            List<String> policyPaths = this.getSTSPolicyPaths((Registry)registry);
            String newEncryptedPassword = null;
            for (String resourcePath : policyPaths) {
                if (!registry.resourceExists(resourcePath)) continue;
                Resource resource = registry.get(resourcePath);
                resourceContent = resource.getContentStream();
                parser = XMLInputFactory.newInstance().createXMLStreamReader(resourceContent);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator it = documentElement.getChildrenWithName(new QName(CARBON_SEC_CONFIG));
                while (it != null && it.hasNext()) {
                    OMElement secConfig = (OMElement)it.next();
                    Iterator kerberosProperties = secConfig.getChildrenWithName(new QName(KERBEROS));
                    Iterator propertySet = null;
                    if (kerberosProperties != null && kerberosProperties.hasNext()) {
                        propertySet = ((OMElement)kerberosProperties.next()).getChildElements();
                    }
                    if (propertySet == null) continue;
                    while (propertySet.hasNext()) {
                        String encryptedPassword;
                        OMElement kbProperty = (OMElement)propertySet.next();
                        if (!SERVICE_PRINCIPAL_PASSWORD.equals(kbProperty.getAttributeValue(new QName(NAME))) || !StringUtils.isNotEmpty((String)(newEncryptedPassword = EncryptionUtil.getNewEncryptedValue(encryptedPassword = kbProperty.getText())))) continue;
                        kbProperty.setText(newEncryptedPassword);
                    }
                }
                if (!StringUtils.isNotEmpty(newEncryptedPassword)) continue;
                resource.setContent((Object)RegistryUtils.encodeString((String)documentElement.toString()));
                registry.beginTransaction();
                registry.put(resourcePath, resource);
                registry.commitTransaction();
            }
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
                if (resourceContent != null) {
                    IdentityIOStreamUtils.closeInputStream(resourceContent);
                }
            }
            catch (XMLStreamException ex) {
                log.error((Object)"Error while closing XML stream", (Throwable)ex);
            }
        }
    }

    private void updateRegistryProperties(Registry registry, String resource, List<String> properties) throws RegistryException, CryptoException {
        if (registry == null || StringUtils.isEmpty((String)resource) || CollectionUtils.isEmpty(properties)) {
            return;
        }
        if (registry.resourceExists(resource)) {
            try {
                registry.beginTransaction();
                Resource resourceObj = registry.get(resource);
                for (String encryptedPropertyName : properties) {
                    String oldValue = resourceObj.getProperty(encryptedPropertyName);
                    String newValue = EncryptionUtil.getNewEncryptedValue(oldValue);
                    if (!StringUtils.isNotEmpty((String)newValue)) continue;
                    resourceObj.setProperty(encryptedPropertyName, newValue);
                }
                registry.put(resource, resourceObj);
                registry.commitTransaction();
            }
            catch (RegistryException e) {
                registry.rollbackTransaction();
                log.error((Object)"Unable to update the registry resource", (Throwable)e);
                throw e;
            }
        }
    }

    private List<String> getSTSPolicyPaths(Registry registry) throws RegistryException {
        Collection serviceGroups;
        ArrayList<String> policyPaths = new ArrayList<String>();
        if (registry.resourceExists(SERVICE_GROUPS_PATH) && (serviceGroups = (Collection)registry.get(SERVICE_GROUPS_PATH)) != null) {
            for (String serviceGroupPath : serviceGroups.getChildren()) {
                String policyCollectionPath;
                Collection policies;
                if (!StringUtils.isNotEmpty((String)serviceGroupPath) || !serviceGroupPath.contains(STS_SERVICE_GROUP) || (policies = (Collection)registry.get(policyCollectionPath = serviceGroupPath + SECURITY_POLICY_RESOURCE_PATH)) == null) continue;
                policyPaths.addAll(Arrays.asList(policies.getChildren()));
            }
        }
        return policyPaths;
    }
}

