/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.is.migration.service.v550.bean.AuthzCodeInfo;

public class AuthzCodeDAO {
    private static AuthzCodeDAO instance = new AuthzCodeDAO();
    private static final String AUTHORIZATION_CODE_HASH = "AUTHORIZATION_CODE_HASH";

    private AuthzCodeDAO() {
    }

    public static AuthzCodeDAO getInstance() {
        return instance;
    }

    public boolean isAuthzCodeHashColumnAvailable(Connection connection) throws SQLException {
        boolean isAuthzCodeColumnsExist = false;
        String sql = connection.getMetaData().getDriverName().contains("MySQL") || connection.getMetaData().getDriverName().contains("H2") ? "SELECT AUTHORIZATION_CODE_HASH FROM IDN_OAUTH2_AUTHORIZATION_CODE LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT AUTHORIZATION_CODE_HASH FROM IDN_OAUTH2_AUTHORIZATION_CODE FETCH FIRST 1 ROWS ONLY" : (connection.getMetaData().getDriverName().contains("MS SQL") || connection.getMetaData().getDriverName().contains("Microsoft") ? "SELECT TOP 1 AUTHORIZATION_CODE_HASH FROM IDN_OAUTH2_AUTHORIZATION_CODE" : (connection.getMetaData().getDriverName().contains("PostgreSQL") ? "SELECT AUTHORIZATION_CODE_HASH FROM IDN_OAUTH2_AUTHORIZATION_CODE LIMIT 1" : (connection.getMetaData().getDriverName().contains("Informix") ? "SELECT FIRST 1 AUTHORIZATION_CODE_HASH FROM IDN_OAUTH2_AUTHORIZATION_CODE" : "SELECT AUTHORIZATION_CODE_HASH FROM IDN_OAUTH2_AUTHORIZATION_CODE WHERE ROWNUM < 2"))));
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    resultSet.findColumn(AUTHORIZATION_CODE_HASH);
                    isAuthzCodeColumnsExist = true;
                }
            }
            catch (SQLException e) {
                isAuthzCodeColumnsExist = false;
            }
        }
        catch (SQLException e) {
            isAuthzCodeColumnsExist = false;
        }
        return isAuthzCodeColumnsExist;
    }

    public void addAuthzCodeHashColumns(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD AUTHORIZATION_CODE_HASH VARCHAR(512)");){
            preparedStatement.executeUpdate();
        }
    }

    public List<AuthzCodeInfo> getAllAuthzCodes(Connection connection) throws SQLException {
        ArrayList<AuthzCodeInfo> authzCodeInfoList = new ArrayList<AuthzCodeInfo>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT AUTHORIZATION_CODE, CODE_ID FROM IDN_OAUTH2_AUTHORIZATION_CODE");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                authzCodeInfoList.add(new AuthzCodeInfo(resultSet.getString("AUTHORIZATION_CODE"), resultSet.getString("CODE_ID")));
            }
            connection.commit();
        }
        return authzCodeInfoList;
    }

    public void updateNewEncryptedAuthzCodes(List<AuthzCodeInfo> updatedAuthzCodeList, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET AUTHORIZATION_CODE=?, AUTHORIZATION_CODE_HASH=? WHERE CODE_ID=?");){
            for (AuthzCodeInfo authzCodeInfo : updatedAuthzCodeList) {
                preparedStatement.setString(1, authzCodeInfo.getAuthorizationCode());
                preparedStatement.setString(2, authzCodeInfo.getAuthorizationCodeHash());
                preparedStatement.setString(3, authzCodeInfo.getCodeId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }

    public void updatePlainTextAuthzCodes(List<AuthzCodeInfo> updatedAuthzCodeList, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET AUTHORIZATION_CODE_HASH=? WHERE CODE_ID=?");){
            for (AuthzCodeInfo authzCodeInfo : updatedAuthzCodeList) {
                preparedStatement.setString(1, authzCodeInfo.getAuthorizationCodeHash());
                preparedStatement.setString(2, authzCodeInfo.getCodeId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }
}

