/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.is.migration.service.v550.bean.BPSProfile;

public class BPSProfileDAO {
    private static BPSProfileDAO instance = new BPSProfileDAO();

    private BPSProfileDAO() {
    }

    public static BPSProfileDAO getInstance() {
        return instance;
    }

    public List<BPSProfile> getAllProfiles(Connection connection) throws SQLException {
        ArrayList<BPSProfile> bpsProfileList = new ArrayList<BPSProfile>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT PASSWORD, PROFILE_NAME, TENANT_ID FROM WF_BPS_PROFILE");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                bpsProfileList.add(new BPSProfile(resultSet.getString("PROFILE_NAME"), resultSet.getInt("TENANT_ID"), resultSet.getString("PASSWORD")));
            }
            connection.commit();
        }
        return bpsProfileList;
    }

    public void updateNewPasswords(List<BPSProfile> updatedBpsProfileList, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE WF_BPS_PROFILE SET PASSWORD=? WHERE PROFILE_NAME=? AND TENANT_ID=?");){
            for (BPSProfile bpsProfile : updatedBpsProfileList) {
                preparedStatement.setString(1, bpsProfile.getPassword());
                preparedStatement.setString(2, bpsProfile.getProfileName());
                preparedStatement.setInt(3, bpsProfile.getTenantId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }
}

