/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.service.v550.bean.ClientSecretInfo;

public class OAuthDAO {
    private static final Log log = LogFactory.getLog(OAuthDAO.class);
    private static OAuthDAO instance = new OAuthDAO();
    private static final String CONSUMER_SECRET_HASH = "CONSUMER_SECRET_HASH";

    private OAuthDAO() {
    }

    public static OAuthDAO getInstance() {
        return instance;
    }

    public boolean isConsumerSecretHashColumnAvailable(Connection connection) throws MigrationClientException {
        String sql = null;
        boolean isConsumerSecretHashColumnsExist = false;
        try {
            sql = connection.getMetaData().getDriverName().contains("MySQL") || connection.getMetaData().getDriverName().contains("H2") ? "SELECT CONSUMER_SECRET_HASH FROM IDN_OAUTH_CONSUMER_APPS LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT CONSUMER_SECRET_HASH FROM IDN_OAUTH_CONSUMER_APPS FETCH FIRST 1 ROWS ONLY" : (connection.getMetaData().getDriverName().contains("MS SQL") || connection.getMetaData().getDriverName().contains("Microsoft") ? "SELECT TOP 1 CONSUMER_SECRET_HASH FROM IDN_OAUTH_CONSUMER_APPS" : (connection.getMetaData().getDriverName().contains("PostgreSQL") ? "SELECT CONSUMER_SECRET_HASH FROM IDN_OAUTH_CONSUMER_APPS LIMIT 1" : (connection.getMetaData().getDriverName().contains("Informix") ? "SELECT FIRST 1 CONSUMER_SECRET_HASH FROM IDN_OAUTH_CONSUMER_APPS" : "SELECT CONSUMER_SECRET_HASH FROM IDN_OAUTH_CONSUMER_APPS WHERE ROWNUM < 2"))));
        }
        catch (Exception e) {
            throw new MigrationClientException("Error while retrieving metadata from connection.", (Throwable)e);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    resultSet.findColumn(CONSUMER_SECRET_HASH);
                    isConsumerSecretHashColumnsExist = true;
                }
            }
            catch (SQLException e) {
                isConsumerSecretHashColumnsExist = false;
                log.error((Object)("Error occured while executing the PreparedStatement." + e.getMessage()));
            }
        }
        catch (SQLException e) {
            isConsumerSecretHashColumnsExist = false;
            log.error((Object)("Error occured while creating the PreparedStatement." + e.getMessage()));
        }
        return isConsumerSecretHashColumnsExist;
    }

    public void deleteConsumerSecretHashColumn(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("ALTER TABLE IDN_OAUTH_CONSUMER_APPS DROP COLUMN CONSUMER_SECRET_HASH");){
            preparedStatement.executeUpdate();
        }
    }

    public List<ClientSecretInfo> getAllClientSecrets(Connection connection) throws SQLException {
        ArrayList<ClientSecretInfo> clientSecretInfoList = new ArrayList<ClientSecretInfo>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT CONSUMER_SECRET, ID FROM IDN_OAUTH_CONSUMER_APPS");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                clientSecretInfoList.add(new ClientSecretInfo(resultSet.getString("CONSUMER_SECRET"), resultSet.getInt("ID")));
            }
            connection.commit();
        }
        return clientSecretInfoList;
    }

    public void updateNewClientSecrets(List<ClientSecretInfo> updatedClientSecretList, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET CONSUMER_SECRET=? WHERE ID=?");){
            for (ClientSecretInfo clientSecretInfo : updatedClientSecretList) {
                preparedStatement.setString(1, clientSecretInfo.getClientSecret());
                preparedStatement.setInt(2, clientSecretInfo.getId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }
}

