/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.is.migration.service.v550.bean.OauthTokenInfo;

public class TokenDAO {
    private static TokenDAO instance = new TokenDAO();
    private static final String ACCESS_TOKEN_HASH = "ACCESS_TOKEN_HASH";
    private static final String REFRESH_TOKEN_HASH = "REFRESH_TOKEN_HASH";

    private TokenDAO() {
    }

    public static TokenDAO getInstance() {
        return instance;
    }

    public boolean isTokenHashColumnsAvailable(Connection connection) throws SQLException {
        boolean isTokenHashColumnsExist = false;
        String sql = connection.getMetaData().getDriverName().contains("MySQL") || connection.getMetaData().getDriverName().contains("H2") ? "SELECT ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN LIMIT 1" : (connection.getMetaData().getDatabaseProductName().contains("DB2") ? "SELECT ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN FETCH FIRST 1 ROWS ONLY" : (connection.getMetaData().getDriverName().contains("MS SQL") || connection.getMetaData().getDriverName().contains("Microsoft") ? "SELECT TOP 1 ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN" : (connection.getMetaData().getDriverName().contains("PostgreSQL") ? "SELECT ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN LIMIT 1" : (connection.getMetaData().getDriverName().contains("Informix") ? "SELECT FIRST 1 ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN" : "SELECT ACCESS_TOKEN_HASH, REFRESH_TOKEN_HASH FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ROWNUM < 2"))));
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    resultSet.findColumn(ACCESS_TOKEN_HASH);
                    resultSet.findColumn(REFRESH_TOKEN_HASH);
                    isTokenHashColumnsExist = true;
                }
            }
            catch (SQLException e) {
                isTokenHashColumnsExist = false;
            }
        }
        catch (SQLException e) {
            isTokenHashColumnsExist = false;
        }
        return isTokenHashColumnsExist;
    }

    public void addAccessTokenHashColumn(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD ACCESS_TOKEN_HASH VARCHAR(512)");){
            preparedStatement.executeUpdate();
        }
    }

    public void addRefreshTokenHashColumn(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD REFRESH_TOKEN_HASH VARCHAR(512)");){
            preparedStatement.executeUpdate();
        }
    }

    public List<OauthTokenInfo> getAllAccessTokens(Connection connection) throws SQLException {
        ArrayList<OauthTokenInfo> oauthTokenInfos = new ArrayList<OauthTokenInfo>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT ACCESS_TOKEN, REFRESH_TOKEN, TOKEN_ID FROM IDN_OAUTH2_ACCESS_TOKEN");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                oauthTokenInfos.add(new OauthTokenInfo(resultSet.getString("ACCESS_TOKEN"), resultSet.getString("REFRESH_TOKEN"), resultSet.getString("TOKEN_ID")));
            }
            connection.commit();
        }
        return oauthTokenInfos;
    }

    public void updateNewEncryptedTokens(List<OauthTokenInfo> updatedOauthTokenList, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET ACCESS_TOKEN=?, REFRESH_TOKEN=?, ACCESS_TOKEN_HASH=?, REFRESH_TOKEN_HASH=? WHERE TOKEN_ID=?");){
            for (OauthTokenInfo oauthTokenInfo : updatedOauthTokenList) {
                preparedStatement.setString(1, oauthTokenInfo.getAccessToken());
                preparedStatement.setString(2, oauthTokenInfo.getRefreshToken());
                preparedStatement.setString(3, oauthTokenInfo.getAccessTokenHash());
                preparedStatement.setString(4, oauthTokenInfo.getRefreshTokenhash());
                preparedStatement.setString(5, oauthTokenInfo.getTokenId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }

    public void updatePlainTextTokens(List<OauthTokenInfo> updatedOauthTokenList, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IDN_OAUTH2_ACCESS_TOKEN SET ACCESS_TOKEN_HASH=?, REFRESH_TOKEN_HASH=? WHERE TOKEN_ID=?");){
            for (OauthTokenInfo oauthTokenInfo : updatedOauthTokenList) {
                preparedStatement.setString(1, oauthTokenInfo.getAccessTokenHash());
                preparedStatement.setString(2, oauthTokenInfo.getRefreshTokenhash());
                preparedStatement.setString(3, oauthTokenInfo.getTokenId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
    }
}

