/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.migrator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v550.bean.BPSProfile;
import org.wso2.carbon.is.migration.service.v550.dao.BPSProfileDAO;

public class BPSProfileDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(BPSProfileDataMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateBPSProfilePassword();
    }

    private void migrateBPSProfilePassword() throws MigrationClientException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on BPS profile table.");
        try {
            List<BPSProfile> bpsProfileList;
            try (Connection connection = this.getDataSource().getConnection();){
                bpsProfileList = BPSProfileDAO.getInstance().getAllProfiles(connection);
            }
            List<BPSProfile> updatedBpsProfileList = this.transformPasswordFromOldToNewEncryption(bpsProfileList);
            try (Connection connection = this.getDataSource().getConnection();){
                BPSProfileDAO.getInstance().updateNewPasswords(updatedBpsProfileList, connection);
            }
        }
        catch (SQLException e) {
            throw new MigrationClientException("Error while retrieving datasource or database connection for BPS profiles table", (Throwable)e);
        }
        catch (CryptoException e) {
            throw new MigrationClientException("Error while checking whether the passwords are encrypted with new encryption algorithm.");
        }
    }

    private List<BPSProfile> transformPasswordFromOldToNewEncryption(List<BPSProfile> bpsProfileList) throws CryptoException {
        ArrayList<BPSProfile> updatedBpsProfileList = new ArrayList<BPSProfile>();
        for (BPSProfile bpsProfile : bpsProfileList) {
            if (CryptoUtil.getDefaultCryptoUtil().base64DecodeAndIsSelfContainedCipherText(bpsProfile.getPassword())) continue;
            byte[] decryptedPassword = CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(bpsProfile.getPassword(), "RSA");
            String newEncryptedPassword = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(decryptedPassword);
            BPSProfile updatedBpsProfile = new BPSProfile(bpsProfile.getProfileName(), bpsProfile.getTenantId(), newEncryptedPassword);
            updatedBpsProfileList.add(updatedBpsProfile);
        }
        return updatedBpsProfileList;
    }
}

