/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.migrator;

import java.io.File;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v550.util.EncryptionUtil;

public class EventPublisherMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(EventPublisherMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateEventPublishers();
    }

    private void migrateEventPublishers() throws MigrationClientException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on event publisher files. ");
        File publisherPath = this.readFiles(System.getProperty("carbon.home") + "/repository/deployment/server/eventpublishers");
        this.migrateData(publisherPath);
        log.info((Object)" WSO2 Product Migration Service Task : Migrating event publishers was successful. ");
    }

    private void migrateData(File folder) throws MigrationClientException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            for (File fileEntry : Objects.requireNonNull(folder.listFiles())) {
                XPathFactory xpathFactory;
                XPath xpath;
                DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
                Document doc = builder.parse(fileEntry);
                NodeList data = this.getEncryptedPayload(doc, xpath = (xpathFactory = XPathFactory.newInstance()).newXPath());
                if (data.getLength() <= 0) continue;
                for (int i = 0; i < data.getLength(); ++i) {
                    String newEncryptedPassword = EncryptionUtil.getNewEncryptedValue(data.item(i).getNodeValue());
                    if (!StringUtils.isNotEmpty((String)newEncryptedPassword)) continue;
                    data.item(i).setNodeValue(newEncryptedPassword);
                }
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.transform(new DOMSource(doc), new StreamResult(new File(fileEntry.getAbsolutePath()).getPath()));
            }
        }
        catch (Exception e) {
            throw new MigrationClientException("Error occurred while migrating data in folder : " + folder.getAbsolutePath() + " . ", (Throwable)e);
        }
    }

    private File readFiles(String path) {
        return new File(path);
    }

    private NodeList getEncryptedPayload(Document doc, XPath xpath) throws Exception {
        try {
            XPathExpression expr = xpath.compile("//*[local-name()='property'][@*[local-name()='encrypted']='true']/text()");
            return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new MigrationClientException("Error has occurred while retriving the payload from file : " + doc.getDocumentURI(), (Throwable)e);
        }
    }
}

