/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.migrator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.oauth.tokenprocessor.HashingPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v550.bean.AuthzCodeInfo;
import org.wso2.carbon.is.migration.service.v550.bean.ClientSecretInfo;
import org.wso2.carbon.is.migration.service.v550.bean.OauthTokenInfo;
import org.wso2.carbon.is.migration.service.v550.dao.AuthzCodeDAO;
import org.wso2.carbon.is.migration.service.v550.dao.OAuthDAO;
import org.wso2.carbon.is.migration.service.v550.dao.TokenDAO;
import org.wso2.carbon.is.migration.service.v550.util.OAuth2Util;

public class OAuthDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(OAuthDataMigrator.class);
    boolean isTokenHashColumnsAvailable = false;
    boolean isAuthzCodeHashColumnAvailable = false;
    boolean isClientSecretHashColumnsAvailable = false;

    @Override
    public void migrate() throws MigrationClientException {
        try {
            this.addHashColumns();
            this.deleteClientSecretHashColumn();
            this.migrateTokens();
            this.migrateAuthorizationCodes();
            this.migrateClientSecrets();
        }
        catch (SQLException e) {
            throw new MigrationClientException("Error while adding hash columns", (Throwable)e);
        }
    }

    public void addHashColumns() throws MigrationClientException, SQLException {
        try (Connection connection = this.getDataSource().getConnection();){
            this.isTokenHashColumnsAvailable = TokenDAO.getInstance().isTokenHashColumnsAvailable(connection);
            this.isAuthzCodeHashColumnAvailable = AuthzCodeDAO.getInstance().isAuthzCodeHashColumnAvailable(connection);
        }
        if (!this.isTokenHashColumnsAvailable) {
            connection = this.getDataSource().getConnection();
            var2_2 = null;
            try {
                TokenDAO.getInstance().addAccessTokenHashColumn(connection);
                TokenDAO.getInstance().addRefreshTokenHashColumn(connection);
                connection.commit();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (var2_2 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        if (!this.isAuthzCodeHashColumnAvailable) {
            connection = this.getDataSource().getConnection();
            var2_2 = null;
            try {
                AuthzCodeDAO.getInstance().addAuthzCodeHashColumns(connection);
                connection.commit();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (var2_2 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
    }

    public void deleteClientSecretHashColumn() throws MigrationClientException, SQLException {
        try (Connection connection = this.getDataSource().getConnection();){
            this.isClientSecretHashColumnsAvailable = OAuthDAO.getInstance().isConsumerSecretHashColumnAvailable(connection);
        }
        if (this.isClientSecretHashColumnsAvailable) {
            connection = this.getDataSource().getConnection();
            var2_2 = null;
            try {
                OAuthDAO.getInstance().deleteConsumerSecretHashColumn(connection);
                connection.commit();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (var2_2 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
    }

    public void migrateTokens() throws MigrationClientException, SQLException {
        List<OauthTokenInfo> oauthTokenList;
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 access token table.");
        try (Connection connection = this.getDataSource().getConnection();){
            oauthTokenList = TokenDAO.getInstance().getAllAccessTokens(connection);
        }
        try {
            if (!this.isTokenHashColumnsAvailable && OAuth2Util.isEncryptionWithTransformationEnabled()) {
                this.migrateOldEncryptedTokens(oauthTokenList);
            }
            if (!this.isTokenHashColumnsAvailable && !OAuth2Util.isTokenEncryptionEnabled()) {
                this.migratePlainTextTokens(oauthTokenList);
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw new MigrationClientException(e.getMessage(), (Throwable)e);
        }
    }

    public void migrateOldEncryptedTokens(List<OauthTokenInfo> oauthTokenList) throws MigrationClientException, SQLException, IdentityOAuth2Exception {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 access token table with encrypted tokens.");
        try {
            List<OauthTokenInfo> updatedOauthTokenList = null;
            updatedOauthTokenList = this.transformFromOldToNewEncryption(oauthTokenList);
            try (Connection connection = this.getDataSource().getConnection();){
                TokenDAO.getInstance().updateNewEncryptedTokens(updatedOauthTokenList, connection);
            }
        }
        catch (CryptoException e) {
            e.printStackTrace();
        }
        catch (IdentityOAuth2Exception e) {
            throw new IdentityOAuth2Exception("Error while migration old encrypted tokens", (Throwable)e);
        }
    }

    public void migratePlainTextTokens(List<OauthTokenInfo> oauthTokenList) throws IdentityOAuth2Exception, MigrationClientException, SQLException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 access token table with plain text tokens.");
        try {
            List<OauthTokenInfo> updatedOauthTokenList = this.generateTokenHashValues(oauthTokenList);
            try (Connection connection = this.getDataSource().getConnection();){
                TokenDAO.getInstance().updatePlainTextTokens(updatedOauthTokenList, connection);
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw new IdentityOAuth2Exception("Error while migration plain text tokens", (Throwable)e);
        }
    }

    private List<OauthTokenInfo> transformFromOldToNewEncryption(List<OauthTokenInfo> oauthTokenList) throws CryptoException, IdentityOAuth2Exception {
        ArrayList<OauthTokenInfo> updatedOauthTokenList = new ArrayList<OauthTokenInfo>();
        for (OauthTokenInfo oauthTokenInfo : oauthTokenList) {
            if (CryptoUtil.getDefaultCryptoUtil().base64DecodeAndIsSelfContainedCipherText(oauthTokenInfo.getAccessToken())) continue;
            byte[] decryptedAccessToken = CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(oauthTokenInfo.getAccessToken(), "RSA");
            String newEncryptedAccesTOken = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(decryptedAccessToken);
            byte[] decryptedRefreshToken = null;
            String newEncryptedRefreshToken = null;
            String refreshToken = oauthTokenInfo.getRefreshToken();
            if (refreshToken != null) {
                decryptedRefreshToken = CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(refreshToken, "RSA");
                newEncryptedRefreshToken = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(decryptedRefreshToken);
            }
            HashingPersistenceProcessor tokenPersistenceProcessor = new HashingPersistenceProcessor();
            String accessTokenHash = null;
            String refreshTokenHash = null;
            accessTokenHash = tokenPersistenceProcessor.getProcessedAccessTokenIdentifier(new String(decryptedAccessToken, Charsets.UTF_8));
            if (refreshToken != null) {
                refreshTokenHash = tokenPersistenceProcessor.getProcessedRefreshToken(new String(decryptedRefreshToken, Charsets.UTF_8));
            }
            OauthTokenInfo updatedOauthTokenInfo = new OauthTokenInfo(newEncryptedAccesTOken, newEncryptedRefreshToken, oauthTokenInfo.getTokenId());
            updatedOauthTokenInfo.setAccessTokenHash(accessTokenHash);
            if (refreshToken != null) {
                updatedOauthTokenInfo.setRefreshTokenhash(refreshTokenHash);
            }
            updatedOauthTokenList.add(updatedOauthTokenInfo);
        }
        return updatedOauthTokenList;
    }

    private List<OauthTokenInfo> generateTokenHashValues(List<OauthTokenInfo> oauthTokenList) throws IdentityOAuth2Exception {
        ArrayList<OauthTokenInfo> updatedOauthTokenList = new ArrayList<OauthTokenInfo>();
        for (OauthTokenInfo oauthTokenInfo : oauthTokenList) {
            String accessToken = oauthTokenInfo.getAccessToken();
            String refreshToken = oauthTokenInfo.getRefreshToken();
            HashingPersistenceProcessor tokenPersistenceProcessor = new HashingPersistenceProcessor();
            String accessTokenHash = tokenPersistenceProcessor.getProcessedAccessTokenIdentifier(accessToken);
            String refreshTokenHash = null;
            if (refreshToken != null) {
                refreshTokenHash = tokenPersistenceProcessor.getProcessedRefreshToken(refreshToken);
            }
            OauthTokenInfo updatedOauthTokenInfo = new OauthTokenInfo(accessToken, refreshToken, oauthTokenInfo.getTokenId());
            updatedOauthTokenInfo.setAccessTokenHash(accessTokenHash);
            updatedOauthTokenInfo.setRefreshTokenhash(refreshTokenHash);
            updatedOauthTokenList.add(updatedOauthTokenInfo);
        }
        return updatedOauthTokenList;
    }

    public void migrateAuthorizationCodes() throws MigrationClientException, SQLException {
        List<AuthzCodeInfo> authzCodeInfoList;
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 authorization code table.");
        try (Connection connection = this.getDataSource().getConnection();){
            authzCodeInfoList = AuthzCodeDAO.getInstance().getAllAuthzCodes(connection);
        }
        try {
            if (!this.isAuthzCodeHashColumnAvailable && OAuth2Util.isEncryptionWithTransformationEnabled()) {
                this.migrateOldEncryptedAuthzCodes(authzCodeInfoList);
            }
            if (!this.isAuthzCodeHashColumnAvailable && !OAuth2Util.isTokenEncryptionEnabled()) {
                this.migratePlainTextAuthzCodes(authzCodeInfoList);
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw new MigrationClientException("Error while checking configurations for encryption with transformation is enabled. ", (Throwable)e);
        }
        catch (SQLException e) {
            throw new MigrationClientException("Error while getting datasource connection. ", (Throwable)e);
        }
    }

    public void migrateOldEncryptedAuthzCodes(List<AuthzCodeInfo> authzCodeInfoList) throws MigrationClientException, SQLException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 authorization table with encrypted authorization codes.");
        try {
            List<AuthzCodeInfo> updatedAuthzCodeInfoList = this.transformAuthzCodeFromOldToNewEncryption(authzCodeInfoList);
            try (Connection connection = this.getDataSource().getConnection();){
                AuthzCodeDAO.getInstance().updateNewEncryptedAuthzCodes(updatedAuthzCodeInfoList, connection);
            }
        }
        catch (CryptoException e) {
            throw new MigrationClientException("Error while encrypting in new encryption algorithm.", (Throwable)e);
        }
        catch (IdentityOAuth2Exception e) {
            throw new MigrationClientException("Error while migrating old encrypted authz codes.", (Throwable)e);
        }
    }

    public void migratePlainTextAuthzCodes(List<AuthzCodeInfo> authzCodeInfoList) throws MigrationClientException, SQLException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 authorization code table with plain text codes.");
        try {
            List<AuthzCodeInfo> updatedAuthzCodeInfoList = this.generateAuthzCodeHashValues(authzCodeInfoList);
            try (Connection connection = this.getDataSource().getConnection();){
                AuthzCodeDAO.getInstance().updatePlainTextAuthzCodes(updatedAuthzCodeInfoList, connection);
            }
        }
        catch (IdentityOAuth2Exception e) {
            throw new MigrationClientException("Error while migration plain text authorization codes.", (Throwable)e);
        }
    }

    private List<AuthzCodeInfo> transformAuthzCodeFromOldToNewEncryption(List<AuthzCodeInfo> authzCodeInfoList) throws CryptoException, IdentityOAuth2Exception {
        ArrayList<AuthzCodeInfo> updatedAuthzCodeInfoList = new ArrayList<AuthzCodeInfo>();
        for (AuthzCodeInfo authzCodeInfo : authzCodeInfoList) {
            if (CryptoUtil.getDefaultCryptoUtil().base64DecodeAndIsSelfContainedCipherText(authzCodeInfo.getAuthorizationCode())) continue;
            byte[] decryptedAuthzCode = CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(authzCodeInfo.getAuthorizationCode(), "RSA");
            String newEncryptedAuthzCode = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(decryptedAuthzCode);
            HashingPersistenceProcessor tokenPersistenceProcessor = new HashingPersistenceProcessor();
            String authzCodeHash = null;
            authzCodeHash = tokenPersistenceProcessor.getProcessedAuthzCode(new String(decryptedAuthzCode, Charsets.UTF_8));
            AuthzCodeInfo updatedAuthzCodeInfo = new AuthzCodeInfo(newEncryptedAuthzCode, authzCodeInfo.getCodeId());
            updatedAuthzCodeInfo.setAuthorizationCodeHash(authzCodeHash);
            updatedAuthzCodeInfoList.add(updatedAuthzCodeInfo);
        }
        return updatedAuthzCodeInfoList;
    }

    private List<AuthzCodeInfo> generateAuthzCodeHashValues(List<AuthzCodeInfo> authzCodeInfoList) throws IdentityOAuth2Exception {
        ArrayList<AuthzCodeInfo> updatedAuthzCodeInfoList = new ArrayList<AuthzCodeInfo>();
        for (AuthzCodeInfo authzCodeInfo : authzCodeInfoList) {
            String authorizationCode = authzCodeInfo.getAuthorizationCode();
            HashingPersistenceProcessor tokenPersistenceProcessor = new HashingPersistenceProcessor();
            String authzCodeHash = tokenPersistenceProcessor.getProcessedAuthzCode(authorizationCode);
            AuthzCodeInfo updatedAuthzCodeInfo = new AuthzCodeInfo(authorizationCode, authzCodeInfo.getCodeId());
            updatedAuthzCodeInfo.setAuthorizationCodeHash(authzCodeHash);
            updatedAuthzCodeInfoList.add(updatedAuthzCodeInfo);
        }
        return updatedAuthzCodeInfoList;
    }

    public void migrateClientSecrets() throws MigrationClientException {
        block31: {
            log.info((Object)" WSO2 Product Migration Service Task : Migration starting on OAuth2 consumer apps table.");
            try {
                try {
                    List<ClientSecretInfo> clientSecretInfoList;
                    if (this.isClientSecretHashColumnsAvailable || !OAuth2Util.isEncryptionWithTransformationEnabled()) break block31;
                    try (Connection connection = this.getDataSource().getConnection();){
                        clientSecretInfoList = OAuthDAO.getInstance().getAllClientSecrets(connection);
                    }
                    List<ClientSecretInfo> updatedClientSecretInfoList = null;
                    try {
                        updatedClientSecretInfoList = this.transformClientSecretFromOldToNewEncryption(clientSecretInfoList);
                    }
                    catch (IdentityOAuth2Exception e) {
                        throw new MigrationClientException("Error while transforming client secret from old to new encryption. ", (Throwable)e);
                    }
                    try (Connection connection = this.getDataSource().getConnection();){
                        OAuthDAO.getInstance().updateNewClientSecrets(updatedClientSecretInfoList, connection);
                    }
                }
                catch (IdentityOAuth2Exception e) {
                    throw new MigrationClientException("Error while checking encryption with transformation is enabled. ", (Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new MigrationClientException("Error while retrieving and updating client secrets. ", (Throwable)e);
            }
            catch (CryptoException e) {
                throw new MigrationClientException("Error while transforming client secret from old to new encryption. ", (Throwable)e);
            }
        }
    }

    private List<ClientSecretInfo> transformClientSecretFromOldToNewEncryption(List<ClientSecretInfo> clientSecretInfoList) throws CryptoException, IdentityOAuth2Exception {
        ArrayList<ClientSecretInfo> updatedClientSecretList = new ArrayList<ClientSecretInfo>();
        for (ClientSecretInfo clientSecretInfo : clientSecretInfoList) {
            if (CryptoUtil.getDefaultCryptoUtil().base64DecodeAndIsSelfContainedCipherText(clientSecretInfo.getClientSecret())) continue;
            byte[] decryptedClientSecret = CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(clientSecretInfo.getClientSecret(), "RSA");
            String newEncryptedClientSecret = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(decryptedClientSecret);
            ClientSecretInfo updatedClientSecretInfo = new ClientSecretInfo(newEncryptedClientSecret, clientSecretInfo.getId());
            updatedClientSecretList.add(updatedClientSecretInfo);
        }
        return updatedClientSecretList;
    }
}

