/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.migrator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v550.RegistryDataManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;

public class SysLogPropertiesMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(SysLogPropertiesMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateSysLogPropertiesPassword();
    }

    private void migrateSysLogPropertiesPassword() throws MigrationClientException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on SYSLOG_PROPERTIES file");
        try {
            RegistryDataManager.getInstance().migrateSysLogPropertyPassword(this.isIgnoreForInactiveTenants());
        }
        catch (UserStoreException e) {
            throw new MigrationClientException("Error while retrieving all tenants. ", (Throwable)e);
        }
        catch (RegistryException e) {
            throw new MigrationClientException("Error while accessing registry and loading SYSLOG_PROPERTIES file. ", (Throwable)e);
        }
        catch (CryptoException e) {
            throw new MigrationClientException("Error while encrypting/decrypting SYSLOG_PROPERTIES password. ", (Throwable)e);
        }
    }
}

