/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.migrator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.v550.util.EncryptionUtil;
import org.wso2.carbon.is.migration.util.Utility;
import org.wso2.carbon.user.api.Tenant;

public class UserStorePasswordMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(UserStorePasswordMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        log.info((Object)" WSO2 Product Migration Service Task : Migration starting on Secondary User Stores");
        this.updateSuperTenantConfigs();
        this.updateTenantConfigs();
    }

    private void updateTenantConfigs() {
        try {
            Set<Tenant> tenants = Utility.getTenants();
            for (Tenant tenant : tenants) {
                File[] userstoreConfigs;
                if (this.isIgnoreForInactiveTenants() && !tenant.isActive()) {
                    log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping secondary userstore migration!"));
                    continue;
                }
                for (File file : userstoreConfigs = this.getUserStoreConfigFiles(tenant.getId())) {
                    if (!file.isFile()) continue;
                    this.updatePassword(file.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while updating secondary user store password for tenant", (Throwable)e);
        }
    }

    private void updateSuperTenantConfigs() {
        try {
            File[] userstoreConfigs;
            for (File file : userstoreConfigs = this.getUserStoreConfigFiles(-1234)) {
                if (!file.isFile()) continue;
                this.updatePassword(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while updating secondary user store password for super tenant", (Throwable)e);
        }
    }

    private File[] getUserStoreConfigFiles(int tenantId) throws FileNotFoundException, IdentityException {
        String carbonHome = System.getProperty("carbon.home");
        String userStorePath = tenantId == -1234 ? Paths.get(carbonHome, "repository", "deployment", "server", "userstores").toString() : Paths.get(carbonHome, "repository", "tenants", String.valueOf(tenantId), "userstores").toString();
        File[] files = new File(userStorePath).listFiles();
        return files != null ? files : new File[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updatePassword(String filePath) throws FileNotFoundException, CryptoException {
        block18: {
            FileInputStream stream;
            XMLStreamReader parser;
            block17: {
                parser = null;
                stream = null;
                log.info((Object)("Migrating password in: " + filePath));
                stream = new FileInputStream(filePath);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator it = documentElement.getChildElements();
                String newEncryptedPassword = null;
                while (it.hasNext()) {
                    String encryptedPassword;
                    OMElement element = (OMElement)it.next();
                    if (!"true".equals(element.getAttributeValue(new QName("encrypted"))) || !"password".equals(element.getAttributeValue(new QName("name"))) && !"ConnectionPassword".equals(element.getAttributeValue(new QName("name"))) || !StringUtils.isNotEmpty((String)(newEncryptedPassword = EncryptionUtil.getNewEncryptedValue(encryptedPassword = element.getText())))) continue;
                    element.setText(newEncryptedPassword);
                }
                if (newEncryptedPassword == null) break block17;
                FileOutputStream outputStream = new FileOutputStream(filePath);
                documentElement.serialize((OutputStream)outputStream);
            }
            try {
                if (parser != null) {
                    parser.close();
                }
                if (stream != null) {
                    IdentityIOStreamUtils.closeInputStream((InputStream)stream);
                }
                break block18;
            }
            catch (XMLStreamException ex) {
                log.error((Object)"Error while closing XML stream", (Throwable)ex);
            }
            break block18;
            catch (XMLStreamException ex) {
                try {
                    log.error((Object)("Error while updating password for: " + filePath));
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            parser.close();
                        }
                        if (stream != null) {
                            IdentityIOStreamUtils.closeInputStream(stream);
                        }
                    }
                    catch (XMLStreamException ex2) {
                        log.error((Object)"Error while closing XML stream", (Throwable)ex2);
                    }
                    throw throwable;
                }
                try {
                    if (parser != null) {
                        parser.close();
                    }
                    if (stream != null) {
                        IdentityIOStreamUtils.closeInputStream((InputStream)stream);
                    }
                }
                catch (XMLStreamException ex3) {
                    log.error((Object)"Error while closing XML stream", (Throwable)ex3);
                }
            }
        }
    }
}

