/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v550.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.tokenprocessor.EncryptionDecryptionPersistenceProcessor;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenPersistenceProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;

public class OAuth2Util {
    private static Log log = LogFactory.getLog(OAuth2Util.class);
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";

    public static boolean isEncryptionWithTransformationEnabled() throws IdentityOAuth2Exception {
        String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
        return cipherTransformation != null && OAuth2Util.isTokenEncryptionEnabled();
    }

    public static boolean isTokenEncryptionEnabled() throws IdentityOAuth2Exception {
        TokenPersistenceProcessor persistenceProcessor = OAuthServerConfiguration.getInstance().getPersistenceProcessor();
        return persistenceProcessor instanceof EncryptionDecryptionPersistenceProcessor;
    }
}

