/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.is.migration.config.Config;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class Utility {
    private static Log log = LogFactory.getLog(Utility.class);

    public static String getMigrationResourceDirectoryPath() {
        Path path = Paths.get(System.getProperty("carbon.home"), "migration-resources");
        return path.toString();
    }

    public static String getDataFilePath(String dataFileName, String version) {
        Path path = Paths.get(Utility.getMigrationResourceDirectoryPath(), version, "data", dataFileName);
        return path.toString();
    }

    public static String getSchemaPath(String schema, String databaseType, String location, String version) {
        Path path = Paths.get(Utility.getMigrationResourceDirectoryPath(), version, "dbscripts", location, schema, databaseType + ".sql");
        return path.toString();
    }

    public static Config loadMigrationConfig(String configFilePath) throws MigrationClientException {
        Config config = null;
        Path path = Paths.get(configFilePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                InputStreamReader in = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
                Yaml yaml = new Yaml();
                yaml.setBeanAccess(BeanAccess.FIELD);
                config = (Config)yaml.loadAs((Reader)in, Config.class);
                if (config == null) {
                    throw new MigrationClientException("Provider is not loaded correctly.");
                }
            }
            catch (IOException e) {
                String errorMessage = "Error occurred while loading the " + Config.class + " yaml file, " + e.getMessage();
                log.error((Object)errorMessage, (Throwable)e);
                throw new MigrationClientException(errorMessage, (Throwable)e);
            }
        }
        return config;
    }

    public static List<Integer> getInactiveTenants() {
        ArrayList<Integer> inactiveTenants = new ArrayList<Integer>();
        try {
            Tenant[] tenants;
            for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
                if (tenant.isActive()) continue;
                inactiveTenants.add(tenant.getId());
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while getting inactive tenant details. Assuming zero inactive tenants.");
            return new ArrayList<Integer>();
        }
        return inactiveTenants;
    }

    public static String setMySQLDBName(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("SELECT DATABASE() FROM DUAL;");
        ResultSet rs = ps.executeQuery();
        String name = null;
        if (rs.next()) {
            name = rs.getString(1);
            ps = conn.prepareStatement("SET @databasename = ?;");
            ps.setString(1, name);
            ps.execute();
        }
        return name;
    }

    public static DocumentBuilder getSecuredDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error while getting document builder.", (Throwable)e);
        }
        return documentBuilder;
    }

    public static Set<Tenant> getTenants() throws MigrationClientException {
        Set<Tenant> tenants;
        try {
            if (Utility.isMigrateTenantRange()) {
                tenants = Utility.getTenantRange(Utility.getMigrationStartingTenantID(), Utility.getMigrationEndingTenantID());
            } else {
                Tenant[] tenantsArray = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants();
                tenants = new HashSet<Tenant>(Arrays.asList(tenantsArray));
            }
        }
        catch (UserStoreException e) {
            String msg = "Error while retrieving the tenants.";
            log.error((Object)msg, (Throwable)e);
            throw new MigrationClientException(msg, (Throwable)e);
        }
        return tenants;
    }

    private static Set<Tenant> getTenantRange(int startingTenantID, int endingTenantID) throws MigrationClientException {
        HashSet<Tenant> tenantsRange = new HashSet<Tenant>();
        try {
            Tenant[] tenants;
            for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
                if (tenant.getId() < startingTenantID || tenant.getId() > endingTenantID) continue;
                tenantsRange.add(tenant);
            }
            if (tenantsRange.isEmpty()) {
                log.info((Object)("No tenant is available within the range (" + startingTenantID + " - " + endingTenantID + ") specified."));
            }
        }
        catch (UserStoreException e) {
            String msg = "Error while getting tenant range (" + startingTenantID + " - " + endingTenantID + ") specified.";
            log.error((Object)msg, (Throwable)e);
            throw new MigrationClientException(msg, (Throwable)e);
        }
        return tenantsRange;
    }

    public static boolean isMigrateTenantRange() {
        return Config.getInstance().isMigrateTenantRange();
    }

    public static int getMigrationStartingTenantID() {
        return Config.getInstance().getMigrationStartingTenantID();
    }

    public static int getMigrationEndingTenantID() {
        return Config.getInstance().getMigrationEndingTenantID();
    }
}

