ALTER TABLE IOS_DEVICE
CHANGE COLUMN UNLOCK_TOKEN UNLOCK_TOKEN VARCHAR(5000) NULL DEFAULT NULL;

-- -----------------------------------------------------
-- Table IOS_DEVICE_PROFILE
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS IOS_DEVICE_PROFILE (
  ID INT NOT NULL AUTO_INCREMENT,
  OPERATION_ID VARCHAR(10) NOT NULL,
  OPERATION_CODE VARCHAR(1000) NULL,
  PROFILE_ID VARCHAR(1000) NULL,
  DEVICE_IDENTIFICATION VARCHAR(300) DEFAULT NULL,
  PROPERTIES TEXT DEFAULT NULL,
  PRIMARY KEY (ID)
);

-- -----------------------------------------------------
-- Table IOS_ENROLLMENT_TOKEN
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS IOS_ENROLLMENT_TOKEN (
  TENANT_DOMAIN VARCHAR(255) NOT NULL,
  CHALLENGE_TOKEN VARCHAR(45) NOT NULL,
  DEVICE_ID VARCHAR(45) DEFAULT NULL,
  ACCESS_TOKEN VARCHAR(100) NOT NULL,
  REFRESH_TOKEN VARCHAR(100) NOT NULL,
  USERNAME VARCHAR(255) NOT NULL,
  CLIENT_CREDENTIALS VARCHAR(255) NOT NULL,
  AGENT_AVAILABLE VARCHAR(10) NOT NULL,
  UNIQUE (TENANT_DOMAIN, CHALLENGE_TOKEN),
  PRIMARY KEY (CHALLENGE_TOKEN)
) ENGINE = InnoDB;

-- -----------------------------------------------------
-- Table IOS_DEP_PROFILE
-- -----------------------------------------------------
CREATE TABLE IOS_DEP_PROFILE (
  ID INT NOT NULL AUTO_INCREMENT,
  UUID VARCHAR(100) DEFAULT NULL,
  PROFILE_NAME VARCHAR(200) DEFAULT NULL,
  TENANT_DOMAIN VARCHAR(255) NOT NULL,
  PROFILE_CONTENT Text DEFAULT NULL,
  UNIQUE (UUID),
  PRIMARY KEY (ID)
);

-- -----------------------------------------------------
-- Table IOS_PRE_ENROLLED_DEVICE
-- -----------------------------------------------------
CREATE TABLE IOS_PRE_ENROLLED_DEVICE (
  ID INT NOT NULL AUTO_INCREMENT,
  SERIAL VARCHAR(45) DEFAULT NULL,
  DEVICE_IDENTIFIER VARCHAR(45) DEFAULT NULL,
  USERNAME VARCHAR(255),
  TENANT_DOMAIN VARCHAR(255) NOT NULL,
  STATUS VARCHAR(100) DEFAULT NULL,
  DEP_PROFILE_ID INT DEFAULT NULL,
  PROFILE_ASSIGN_TIME TIMESTAMP NULL,
  PROFILE_PUSH_TIME TIMESTAMP NULL,
  DEVICE_ASSIGNED_TIME TIMESTAMP NULL,
  DEVICE_ASSIGNED_BY VARCHAR(100) DEFAULT NULL,
  NEED_BASIC_AUTH INT DEFAULT 0,
  IS_AGENT_REQUIRED INT DEFAULT 0,
  OS VARCHAR(45) DEFAULT NULL,
  DEVICE_FAMILY VARCHAR(45) DEFAULT NULL,
  DEVICE_MODEL VARCHAR(45) DEFAULT NULL,
  DESCRIPTION VARCHAR(200) DEFAULT NULL,
  COLOR VARCHAR(200) DEFAULT NULL,
  UNIQUE (SERIAL),
  PRIMARY KEY (ID),
  CONSTRAINT fk_IOS_PRE_ENROLLED_DEVICE_IOS_DEP_PROFILE
    FOREIGN KEY (DEP_PROFILE_ID)
    REFERENCES IOS_DEP_PROFILE (ID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
);