ALTER TABLE AM_SUBSCRIPTION_KEY_MAPPING MODIFY ACCESS_TOKEN VARCHAR(512);
ALTER TABLE AM_APPLICATION_REGISTRATION MODIFY TOKEN_SCOPE VARCHAR(1500);

CREATE TABLE IF NOT EXISTS `AM_CERTIFICATE_METADATA` (
  `TENANT_ID` INT(11) NOT NULL,
  `ALIAS` VARCHAR(45) NOT NULL,
  `END_POINT` VARCHAR(100) NOT NULL,
  CONSTRAINT PK_ALIAS PRIMARY KEY (`ALIAS`),
  CONSTRAINT END_POINT_CONSTRAINT UNIQUE (`END_POINT`)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS AM_APPLICATION_GROUP_MAPPING (
    APPLICATION_ID INTEGER NOT NULL,
    GROUP_ID VARCHAR(512)NOT NULL,
    TENANT VARCHAR(255),
    PRIMARY KEY (APPLICATION_ID,GROUP_ID,TENANT),
    FOREIGN KEY (APPLICATION_ID) REFERENCES AM_APPLICATION(APPLICATION_ID) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS AM_USAGE_UPLOADED_FILES (
  TENANT_DOMAIN varchar(255) NOT NULL,
  FILE_NAME varchar(255) NOT NULL,
  FILE_TIMESTAMP TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FILE_PROCESSED tinyint(1) DEFAULT FALSE,
  FILE_CONTENT MEDIUMBLOB DEFAULT NULL,
  PRIMARY KEY (TENANT_DOMAIN, FILE_NAME, FILE_TIMESTAMP)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS AM_API_LC_PUBLISH_EVENTS (
    ID INTEGER(11) NOT NULL AUTO_INCREMENT,
    TENANT_DOMAIN VARCHAR(500) NOT NULL,
    API_ID VARCHAR(500) NOT NULL,
    EVENT_TIME TIMESTAMP NOT NULL,
    PRIMARY KEY (ID)
) ENGINE=InnoDB;


CREATE TABLE IF NOT EXISTS  IDN_SAML2_ASSERTION_STORE (
  ID INTEGER NOT NULL AUTO_INCREMENT,
  SAML2_ID  VARCHAR(255) ,
  SAML2_ISSUER  VARCHAR(255) ,
  SAML2_SUBJECT  VARCHAR(255) ,
  SAML2_SESSION_INDEX  VARCHAR(255) ,
  SAML2_AUTHN_CONTEXT_CLASS_REF  VARCHAR(255) ,
  SAML2_ASSERTION  VARCHAR(4096) ,
  PRIMARY KEY (ID)
)ENGINE INNODB;