ALTER TABLE DM_OPERATION
ADD COLUMN INITIATED_BY VARCHAR(100) NULL DEFAULT NULL AFTER OPERATION_CODE;

CREATE INDEX IDX_DEVICE_TYPE_PROVIDER ON DM_DEVICE_TYPE (NAME, PROVIDER_TENANT_ID);
CREATE INDEX IDX_DEVICE_TYPE_DEVICE_NAME ON DM_DEVICE_TYPE(ID, NAME);


ALTER TABLE DM_DEVICE_APPLICATION_MAPPING
ADD COLUMN ENROLMENT_ID INT(11) NULL AFTER DEVICE_ID,
ADD COLUMN APP_PROPERTIES BLOB NULL AFTER TENANT_ID,
ADD COLUMN MEMORY_USAGE INT(11) NULL AFTER APP_PROPERTIES,
ADD COLUMN IS_ACTIVE TINYINT NULL AFTER MEMORY_USAGE;

SET SQL_SAFE_UPDATES = 0;

UPDATE DM_DEVICE_APPLICATION_MAPPING dam,
    DM_ENROLMENT de,
    DM_APPLICATION da
SET
    dam.ENROLMENT_ID = de.ID,
    dam.MEMORY_USAGE = da.MEMORY_USAGE,
    dam.APP_PROPERTIES = da.APP_PROPERTIES,
    dam.IS_ACTIVE = da.IS_ACTIVE
WHERE
    dam.APPLICATION_ID = da.ID
	AND dam.DEVICE_ID = de.DEVICE_ID
    AND de.STATUS = 'ACTIVE';

SET SQL_SAFE_UPDATES = 1;


-- This should run only after the 3.1.0 is shutdown completely.

ALTER TABLE DM_DEVICE_APPLICATION_MAPPING
CHANGE COLUMN IS_ACTIVE IS_ACTIVE TINYINT(4) NOT NULL ,
ADD INDEX FK_DM_APP_MAP_DM_ENROL_idx (ENROLMENT_ID ASC);
ALTER TABLE DM_DEVICE_APPLICATION_MAPPING
ADD CONSTRAINT FK_DM_APP_MAP_DM_ENROL
  FOREIGN KEY (ENROLMENT_ID)
  REFERENCES DM_ENROLMENT (ID)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

-- Change the notification --

ALTER TABLE DM_NOTIFICATION
DROP FOREIGN KEY fk_dm_operation_notification;
ALTER TABLE DM_NOTIFICATION
CHANGE COLUMN OPERATION_ID OPERATION_ID INT(11) NULL ,
ADD COLUMN LAST_UPDATED_TIMESTAMP TIMESTAMP NULL AFTER DESCRIPTION;


ALTER TABLE DM_NOTIFICATION
CHANGE COLUMN LAST_UPDATED_TIMESTAMP LAST_UPDATED_TIMESTAMP TIMESTAMP NOT NULL ;

-- Change the device info ---

ALTER TABLE DM_DEVICE_INFO
ADD COLUMN ENROLMENT_ID INT(11) NULL AFTER DEVICE_ID;

SET SQL_SAFE_UPDATES = 0;


UPDATE DM_DEVICE_INFO di,
    DM_ENROLMENT de
SET
    di.ENROLMENT_ID = de.ID
WHERE
    di.DEVICE_ID = de.DEVICE_ID
        AND de.STATUS = 'ACTIVE';

SET SQL_SAFE_UPDATES = 1;

-- This should run only after the 3.1.0 is shutdown completely.

ALTER TABLE DM_DEVICE_INFO
CHANGE COLUMN ENROLMENT_ID ENROLMENT_ID INT(11) NOT NULL,
ADD INDEX DM_DEVICE_LOCATION_DM_ENROLLMENT_idx (ENROLMENT_ID ASC);
ALTER TABLE DM_DEVICE_INFO
ADD CONSTRAINT DM_DEVICE_LOCATION_DM_ENROLLMENT
  FOREIGN KEY (ENROLMENT_ID)
  REFERENCES DM_ENROLMENT (ID)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


-- Change the device location ---

ALTER TABLE DM_DEVICE_LOCATION
CHANGE COLUMN STREET1 STREET1 VARCHAR(255) NULL DEFAULT NULL ,
CHANGE COLUMN STREET2 STREET2 VARCHAR(255) NULL DEFAULT NULL ,
ADD COLUMN ENROLMENT_ID INT(11) NULL AFTER DEVICE_ID,
ADD COLUMN GEO_HASH VARCHAR(45) NULL AFTER UPDATE_TIMESTAMP,
ADD INDEX DM_DEVICE_LOCATION_GEO_hashx (GEO_HASH ASC);


SET SQL_SAFE_UPDATES = 0;


UPDATE DM_DEVICE_LOCATION di,
    DM_ENROLMENT de
SET
    di.ENROLMENT_ID = de.ID
WHERE
    di.DEVICE_ID = de.DEVICE_ID
        AND de.STATUS = 'ACTIVE';

SET SQL_SAFE_UPDATES = 1;

-- This should run only after the 3.1.0 is shutdown completely.

ALTER TABLE DM_DEVICE_LOCATION
CHANGE COLUMN ENROLMENT_ID ENROLMENT_ID INT(11) NOT NULL ,
ADD INDEX DM_DEVICE_LOCATION_DM_ENROLLMENT_idx (ENROLMENT_ID ASC);
ALTER TABLE DM_DEVICE_LOCATION
ADD CONSTRAINT FK_DM_DEVICE_LOCATION_DM_ENROLLMENT
  FOREIGN KEY (ENROLMENT_ID)
  REFERENCES DM_ENROLMENT (ID)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


-- Changes to the device details --

ALTER TABLE DM_DEVICE_DETAIL
CHANGE COLUMN CONNECTION_TYPE CONNECTION_TYPE VARCHAR(50) NULL DEFAULT NULL ,
ADD COLUMN ENROLMENT_ID INT(11) NULL AFTER DEVICE_ID;


SET SQL_SAFE_UPDATES = 0;


UPDATE DM_DEVICE_DETAIL di,
    DM_ENROLMENT de
SET
    di.ENROLMENT_ID = de.ID
WHERE
    di.DEVICE_ID = de.DEVICE_ID
        AND de.STATUS = 'ACTIVE';

SET SQL_SAFE_UPDATES = 1;

-- This should run only after the 3.1.0 is shutdown completely.

ALTER TABLE DM_DEVICE_DETAIL
CHANGE COLUMN ENROLMENT_ID ENROLMENT_ID INT(11) NOT NULL ,
ADD INDEX FK_DM_ENROLMENT_DEVICE_DETAILS_idx (ENROLMENT_ID ASC);
ALTER TABLE DM_DEVICE_DETAIL
ADD CONSTRAINT FK_DM_ENROLMENT_DEVICE_DETAILS
  FOREIGN KEY (ENROLMENT_ID)
  REFERENCES DM_ENROLMENT (ID)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

-- TEMP TABLE REQUIRED FOR DATA ARCHIVAL JOB
CREATE TABLE IF NOT EXISTS DM_ARCHIVED_OPERATIONS (
    ID INTEGER NOT NULL,
    CREATED_TIMESTAMP TIMESTAMP NOT NULL,
    PRIMARY KEY (ID)
)ENGINE = InnoDB;