BEGIN
  DECLARE const_name VARCHAR(128);
  DECLARE STMT VARCHAR(200);
  select CONSTNAME into const_name from SYSCAT.TABCONST WHERE TABNAME='IDN_OAUTH1A_REQUEST_TOKEN' AND TYPE = 'F';
  SET STMT = 'ALTER TABLE IDN_OAUTH1A_REQUEST_TOKEN DROP FOREIGN KEY ' ||  const_name;
  PREPARE S1 FROM STMT;
  EXECUTE S1;
END
/

BEGIN
  DECLARE const_name VARCHAR(128);
  DECLARE STMT VARCHAR(200);
  select CONSTNAME into const_name from SYSCAT.TABCONST WHERE TABNAME='IDN_OAUTH1A_ACCESS_TOKEN' AND TYPE = 'F';
  SET STMT = 'ALTER TABLE IDN_OAUTH1A_ACCESS_TOKEN DROP FOREIGN KEY ' ||  const_name;
  PREPARE S1 FROM STMT;
  EXECUTE S1;
END
/

BEGIN
  DECLARE const_name VARCHAR(128);
  DECLARE STMT VARCHAR(200);
  select CONSTNAME into const_name from SYSCAT.TABCONST WHERE TABNAME='IDN_OAUTH2_ACCESS_TOKEN' AND TYPE = 'F';
  SET STMT = 'ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN DROP FOREIGN KEY ' ||  const_name;
  PREPARE S1 FROM STMT;
  EXECUTE S1;
END
/

BEGIN
  DECLARE const_name VARCHAR(128);
  DECLARE STMT VARCHAR(200);
  select CONSTNAME into const_name from SYSCAT.TABCONST WHERE TABNAME='IDN_OAUTH2_AUTHORIZATION_CODE' AND TYPE = 'F';
  SET STMT = 'ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE DROP FOREIGN KEY ' ||  const_name;
  PREPARE S1 FROM STMT;
  EXECUTE S1;
END
/

CREATE TABLE IDP_METADATA (
  ID INTEGER NOT NULL,
  IDP_ID INTEGER NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  VALUE VARCHAR(255),
  DISPLAY_NAME VARCHAR(255),
  TENANT_ID INTEGER DEFAULT -1,
  PRIMARY KEY (ID),
  CONSTRAINT IDP_METADATA_CONSTRAINT UNIQUE (IDP_ID, NAME),
  FOREIGN KEY (IDP_ID) REFERENCES IDP(ID) ON DELETE CASCADE)
/

CREATE SEQUENCE IDP_METADATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE TRIGGER IDP_METADATA_TRIG NO CASCADE
BEFORE INSERT
ON IDP_METADATA
REFERENCING NEW AS NEW
FOR EACH ROW MODE DB2SQL
  BEGIN ATOMIC
    SET (NEW.ID) = (NEXTVAL FOR IDP_METADATA_SEQ);
  END
/

INSERT INTO IDP_METADATA (IDP_ID, NAME, VALUE, DISPLAY_NAME, TENANT_ID) SELECT ID, 'SessionIdleTimeout', '15',
  'Session Idle Timeout', -1234 FROM IDP WHERE TENANT_ID = -1234 AND NAME = 'LOCAL'
/

INSERT INTO IDP_METADATA (IDP_ID, NAME, VALUE, DISPLAY_NAME, TENANT_ID) SELECT ID, 'RememberMeTimeout', '20160', 'RememberMe Timeout', -1234 FROM IDP WHERE TENANT_ID = -1234 AND NAME = 'LOCAL'
/

CREATE TABLE SP_METADATA (
  ID INTEGER NOT NULL,
  SP_ID INTEGER NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  VALUE VARCHAR(255) NOT NULL,
  DISPLAY_NAME VARCHAR(255),
  TENANT_ID INTEGER DEFAULT -1,
  PRIMARY KEY (ID),
  CONSTRAINT SP_METADATA_CONSTRAINT UNIQUE (SP_ID, NAME),
  FOREIGN KEY (SP_ID) REFERENCES SP_APP(ID) ON DELETE CASCADE)
/
CREATE SEQUENCE SP_METADATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE TRIGGER SP_METADATA_TRIG NO CASCADE
BEFORE INSERT
ON SP_METADATA
REFERENCING NEW AS NEW
FOR EACH ROW MODE DB2SQL
  BEGIN ATOMIC
    SET (NEW.ID) = (NEXTVAL FOR SP_METADATA_SEQ);
  END
/

ALTER TABLE IDN_OAUTH_CONSUMER_APPS DROP PRIMARY KEY
/

ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD ID INTEGER NOT NULL DEFAULT 0
/
CREATE SEQUENCE IDN_OAUTH_CONSUMER_APPS_SEQUENCE START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE TRIGGER IDN_OAUTH_CONSUMER_APPS_TRIGGER NO CASCADE BEFORE INSERT ON IDN_OAUTH_CONSUMER_APPS REFERENCING NEW AS NEW FOR EACH ROW MODE DB2SQL BEGIN ATOMIC SET (NEW.ID) = (NEXTVAL FOR IDN_OAUTH_CONSUMER_APPS_SEQUENCE); END
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_OAUTH_CONSUMER_APPS')
/
UPDATE IDN_OAUTH_CONSUMER_APPS SET ID = IDN_OAUTH_CONSUMER_APPS_SEQUENCE.NEXTVAL
/

ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD USER_DOMAIN VARCHAR(50)
/
ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD PRIMARY KEY (ID)
/
ALTER TABLE IDN_OAUTH_CONSUMER_APPS ADD CONSTRAINT CONSUMER_KEY_CONSTRAINT UNIQUE (CONSUMER_KEY)
/

ALTER TABLE IDN_OAUTH1A_REQUEST_TOKEN ADD CONSUMER_KEY_ID INTEGER
/
UPDATE IDN_OAUTH1A_REQUEST_TOKEN set CONSUMER_KEY_ID = (select CONSUMER_APPS.ID from IDN_OAUTH_CONSUMER_APPS CONSUMER_APPS where CONSUMER_APPS.CONSUMER_KEY = IDN_OAUTH1A_REQUEST_TOKEN.CONSUMER_KEY)
/
ALTER TABLE IDN_OAUTH1A_REQUEST_TOKEN DROP COLUMN CONSUMER_KEY
/
ALTER TABLE IDN_OAUTH1A_REQUEST_TOKEN ADD CONSTRAINT IDN_OAUTH1A_REQUEST_TOKEN_F1 FOREIGN KEY(CONSUMER_KEY_ID) REFERENCES IDN_OAUTH_CONSUMER_APPS(ID) ON DELETE CASCADE
/
ALTER TABLE IDN_OAUTH1A_REQUEST_TOKEN ADD TENANT_ID INTEGER DEFAULT -1
/

ALTER TABLE IDN_OAUTH1A_ACCESS_TOKEN ADD CONSUMER_KEY_ID INTEGER
/
UPDATE IDN_OAUTH1A_ACCESS_TOKEN set CONSUMER_KEY_ID = (select CONSUMER_APPS.ID from IDN_OAUTH_CONSUMER_APPS CONSUMER_APPS where CONSUMER_APPS.CONSUMER_KEY = IDN_OAUTH1A_ACCESS_TOKEN.CONSUMER_KEY)
/
ALTER TABLE IDN_OAUTH1A_ACCESS_TOKEN DROP COLUMN CONSUMER_KEY
/
ALTER TABLE IDN_OAUTH1A_ACCESS_TOKEN ADD CONSTRAINT IDN_OAUTH1A_ACCESS_TOKEN_F1 FOREIGN KEY (CONSUMER_KEY_ID) REFERENCES IDN_OAUTH_CONSUMER_APPS(ID) ON DELETE CASCADE
/
ALTER TABLE IDN_OAUTH1A_ACCESS_TOKEN ADD TENANT_ID INTEGER DEFAULT -1
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN DROP PRIMARY KEY
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD TOKEN_ID VARCHAR (255)
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD CONSUMER_KEY_ID INTEGER NOT NULL WITH DEFAULT 0
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD GRANT_TYPE VARCHAR (50)
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD SUBJECT_IDENTIFIER VARCHAR(255)
/
UPDATE IDN_OAUTH2_ACCESS_TOKEN set CONSUMER_KEY_ID = (select CONSUMER_APPS.ID from IDN_OAUTH_CONSUMER_APPS CONSUMER_APPS where CONSUMER_APPS.CONSUMER_KEY = IDN_OAUTH2_ACCESS_TOKEN.CONSUMER_KEY)
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN DROP UNIQUE CON_APP_KEY
/

BEGIN
  DECLARE CONTINUE HANDLER FOR SQLSTATE '42704'
  BEGIN END;
  EXECUTE IMMEDIATE 'DROP INDEX IDX_AT_CK_AU';
END
/

BEGIN
  DECLARE CONTINUE HANDLER FOR SQLSTATE '42704'
  BEGIN END;
  EXECUTE IMMEDIATE 'DROP INDEX IDX_OAUTH_ACCTKN_CONK_UTYPE';
END
/

ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN DROP COLUMN CONSUMER_KEY
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD TENANT_ID INTEGER NOT NULL WITH DEFAULT -1
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD USER_DOMAIN VARCHAR(50) NOT NULL WITH DEFAULT 'PRIMARY'
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD REFRESH_TOKEN_TIME_CREATED TIMESTAMP
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_OAUTH2_ACCESS_TOKEN')
/
UPDATE IDN_OAUTH2_ACCESS_TOKEN SET REFRESH_TOKEN_TIME_CREATED = TIME_CREATED
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD REFRESH_TOKEN_VALIDITY_PERIOD BIGINT
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_OAUTH2_ACCESS_TOKEN')
/
UPDATE IDN_OAUTH2_ACCESS_TOKEN SET REFRESH_TOKEN_VALIDITY_PERIOD = 84600000
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD TOKEN_SCOPE_HASH VARCHAR (32) NOT NULL WITH DEFAULT 'DEFAULT'
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ALTER COLUMN TOKEN_STATE_ID  SET DATA TYPE VARCHAR (128)
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_OAUTH2_ACCESS_TOKEN')
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD CONSTRAINT CON_APP_KEY UNIQUE (CONSUMER_KEY_ID,AUTHZ_USER,TENANT_ID,USER_DOMAIN,USER_TYPE,TOKEN_SCOPE_HASH,TOKEN_STATE,TOKEN_STATE_ID)
/
CREATE INDEX IDX_AT_CK_AU ON IDN_OAUTH2_ACCESS_TOKEN(CONSUMER_KEY_ID, AUTHZ_USER, TOKEN_STATE, USER_TYPE)
/
CREATE INDEX IDX_TC ON IDN_OAUTH2_ACCESS_TOKEN(TIME_CREATED)
/
ALTER TABLE IDN_OAUTH2_ACCESS_TOKEN ADD FOREIGN KEY (CONSUMER_KEY_ID) REFERENCES IDN_OAUTH_CONSUMER_APPS(ID) ON DELETE CASCADE
/
ALTER TABLE IDN_OAUTH2_RESOURCE_SCOPE ADD TENANT_ID INTEGER DEFAULT -1
/
ALTER TABLE IDN_OPENID_ASSOCIATIONS ADD TENANT_ID INTEGER DEFAULT -1
/
ALTER TABLE IDN_THRIFT_SESSION ADD TENANT_ID INTEGER DEFAULT -1
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD CONSUMER_KEY_ID INTEGER
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD TENANT_ID INTEGER
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD USER_DOMAIN VARCHAR(50) NOT NULL WITH DEFAULT 'PRIMARY'
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD STATE VARCHAR (25) DEFAULT 'ACTIVE'
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD TOKEN_ID VARCHAR(255)
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD CODE_ID VARCHAR (255) NOT NULL WITH DEFAULT 'DEFAULT'
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD SUBJECT_IDENTIFIER VARCHAR(255)
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE DROP PRIMARY KEY
/
UPDATE IDN_OAUTH2_AUTHORIZATION_CODE set CONSUMER_KEY_ID = (select ID from IDN_OAUTH_CONSUMER_APPS where IDN_OAUTH_CONSUMER_APPS.CONSUMER_KEY = IDN_OAUTH2_AUTHORIZATION_CODE.CONSUMER_KEY)
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE DROP COLUMN CONSUMER_KEY
/
ALTER TABLE IDN_OAUTH2_AUTHORIZATION_CODE ADD FOREIGN KEY (CONSUMER_KEY_ID) REFERENCES IDN_OAUTH_CONSUMER_APPS(ID) ON DELETE CASCADE
/

CREATE TABLE IDN_OAUTH2_ACCESS_TOKEN_SCOPE (
  TOKEN_ID VARCHAR (255) NOT NULL,
  TOKEN_SCOPE VARCHAR (60) NOT NULL,
  TENANT_ID INTEGER DEFAULT -1,
  PRIMARY KEY (TOKEN_ID, TOKEN_SCOPE))
/

ALTER TABLE IDN_IDENTITY_USER_DATA  ALTER COLUMN DATA_VALUE DROP NOT NULL
/

UPDATE IDN_ASSOCIATED_ID set IDN_ASSOCIATED_ID.IDP_ID = (SELECT IDP.ID FROM IDP WHERE IDP.NAME = IDN_ASSOCIATED_ID.IDP_ID AND IDP.TENANT_ID = IDN_ASSOCIATED_ID.TENANT_ID )
/

BEGIN
DECLARE const_name VARCHAR(128);
DECLARE STMT VARCHAR(200);
select CONSTNAME into const_name from SYSCAT.TABCONST WHERE TABNAME='IDN_ASSOCIATED_ID' AND TYPE = 'U';
SET STMT = 'ALTER TABLE IDN_ASSOCIATED_ID DROP UNIQUE ' ||  const_name;
PREPARE S1 FROM STMT;
EXECUTE S1;
END
/
ALTER TABLE IDN_ASSOCIATED_ID ALTER COLUMN IDP_ID SET DATA TYPE INTEGER
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_ASSOCIATED_ID')
/
ALTER TABLE IDN_ASSOCIATED_ID ADD CONSTRAINT IDN_ASSOCIATED_ID_U1 UNIQUE (IDP_USER_ID, TENANT_ID, IDP_ID)
/
ALTER TABLE IDN_ASSOCIATED_ID ADD DOMAIN_NAME VARCHAR(255) NOT NULL WITH DEFAULT 'PRIMARY'
/
ALTER TABLE IDN_ASSOCIATED_ID ADD FOREIGN KEY (IDP_ID )  REFERENCES IDP (ID) ON DELETE CASCADE
/

DELETE FROM IDN_AUTH_SESSION_STORE
/
ALTER TABLE IDN_AUTH_SESSION_STORE ADD OPERATION VARCHAR(10) NOT NULL WITH DEFAULT 'INVALID'
/
ALTER TABLE IDN_AUTH_SESSION_STORE ADD TENANT_ID INTEGER DEFAULT -1
/
ALTER TABLE IDN_AUTH_SESSION_STORE ALTER COLUMN TIME_CREATED  SET DATA TYPE BIGINT
/
ALTER TABLE IDN_AUTH_SESSION_STORE ALTER COLUMN TIME_CREATED  SET NOT NULL
/
ALTER TABLE IDN_AUTH_SESSION_STORE DROP PRIMARY KEY
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_AUTH_SESSION_STORE')
/
ALTER TABLE IDN_AUTH_SESSION_STORE ADD PRIMARY KEY (SESSION_ID, SESSION_TYPE, TIME_CREATED, OPERATION)
/

ALTER TABLE SP_APP ADD IS_USE_TENANT_DOMAIN_SUBJECT CHAR(1) DEFAULT '1'
/
ALTER TABLE SP_APP ADD IS_USE_USER_DOMAIN_SUBJECT CHAR(1) DEFAULT '1'
/
ALTER TABLE SP_APP ADD IS_DUMB_MODE CHAR(1) DEFAULT '0'
/

INSERT INTO IDP_AUTHENTICATOR (TENANT_ID, IDP_ID, NAME) SELECT -1234, ID, 'IDPProperties' FROM IDP WHERE TENANT_ID=-1234 AND NAME='LOCAL'
/
INSERT INTO IDP_AUTHENTICATOR (TENANT_ID, IDP_ID, NAME) SELECT -1234, ID, 'passivests' FROM IDP WHERE TENANT_ID=-1234 AND NAME='LOCAL'
/
INSERT INTO  IDP_AUTHENTICATOR_PROPERTY (TENANT_ID, AUTHENTICATOR_ID, PROPERTY_KEY,PROPERTY_VALUE, IS_SECRET ) SELECT -1234, IDP_AUTHENTICATOR.ID , 'IdPEntityId', 'localhost', '0' FROM IDP_AUTHENTICATOR,IDP WHERE IDP_AUTHENTICATOR.TENANT_ID = -1234 AND IDP_AUTHENTICATOR.NAME = 'passivests' AND IDP.NAME='LOCAL' AND IDP.ID = IDP_AUTHENTICATOR.IDP_ID
/

ALTER TABLE SP_INBOUND_AUTH ALTER COLUMN INBOUND_AUTH_KEY DROP NOT NULL
/
ALTER TABLE IDP_PROVISIONING_ENTITY ADD ENTITY_LOCAL_ID VARCHAR(255)
/

CREATE TABLE IDN_USER_ACCOUNT_ASSOCIATION (
  ASSOCIATION_KEY VARCHAR(255) NOT NULL,
  TENANT_ID INTEGER NOT NULL,
  DOMAIN_NAME VARCHAR(255) NOT NULL,
  USER_NAME VARCHAR(255) NOT NULL,
  PRIMARY KEY (TENANT_ID, DOMAIN_NAME, USER_NAME))
/


CREATE TABLE FIDO_DEVICE_STORE (
  TENANT_ID INTEGER NOT NULL,
  DOMAIN_NAME VARCHAR(255) NOT NULL,
  USER_NAME VARCHAR(45) NOT NULL,
  TIME_REGISTERED TIMESTAMP,
  KEY_HANDLE VARCHAR(200) NOT NULL,
  DEVICE_DATA VARCHAR(2048) NOT NULL,
  PRIMARY KEY (TENANT_ID, DOMAIN_NAME, USER_NAME, KEY_HANDLE))
/

CREATE TABLE WF_REQUEST (
  UUID VARCHAR (45) NOT NULL,
  CREATED_BY VARCHAR (255),
  TENANT_ID INTEGER NOT NULL DEFAULT -1,
  OPERATION_TYPE VARCHAR (50),
  CREATED_AT TIMESTAMP,
  UPDATED_AT TIMESTAMP,
  STATUS VARCHAR (30),
  REQUEST BLOB,
  PRIMARY KEY (UUID))
/

CREATE TABLE WF_BPS_PROFILE (
  PROFILE_NAME VARCHAR(45) NOT NULL,
  HOST_URL VARCHAR(45),
  USERNAME VARCHAR(45),
  PASSWORD VARCHAR(255),
  CALLBACK_HOST VARCHAR (45),
  TENANT_ID INTEGER NOT NULL DEFAULT -1,
  PRIMARY KEY (PROFILE_NAME, TENANT_ID))
/

CREATE TABLE WF_WORKFLOW(
  ID VARCHAR (45) NOT NULL,
  WF_NAME VARCHAR (45),
  DESCRIPTION VARCHAR (255),
  TEMPLATE_ID VARCHAR (45),
  IMPL_ID VARCHAR (45),
  TENANT_ID INTEGER NOT NULL DEFAULT -1,
  PRIMARY KEY (ID))
/

CREATE TABLE WF_WORKFLOW_ASSOCIATION(
  ID INTEGER NOT NULL,
  ASSOC_NAME VARCHAR (45),
  EVENT_ID VARCHAR(45),
  ASSOC_CONDITION VARCHAR (2000),
  WORKFLOW_ID VARCHAR (45),
  IS_ENABLED CHAR (1) DEFAULT '1',
  TENANT_ID INTEGER DEFAULT -1,
  PRIMARY KEY(ID),
  FOREIGN KEY (WORKFLOW_ID) REFERENCES WF_WORKFLOW(ID)ON DELETE CASCADE)
/

CREATE SEQUENCE WF_WORKFLOW_ASSOCIATION_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/

CREATE TRIGGER WF_WORKFLOW_ASSOCIATION_TRIG NO CASCADE
BEFORE INSERT
ON WF_WORKFLOW_ASSOCIATION
REFERENCING NEW AS NEW
FOR EACH ROW MODE DB2SQL
  BEGIN ATOMIC
    SET (NEW.ID) = (NEXTVAL FOR WF_WORKFLOW_ASSOCIATION_SEQ);
  END
/

CREATE TABLE WF_WORKFLOW_CONFIG_PARAM(
  WORKFLOW_ID VARCHAR (45) NOT NULL,
  PARAM_NAME VARCHAR (45) NOT NULL,
  PARAM_VALUE VARCHAR (1000),
  PARAM_QNAME VARCHAR (45) NOT NULL,
  PARAM_HOLDER VARCHAR (45) NOT NULL,
  TENANT_ID INTEGER DEFAULT -1,
  PRIMARY KEY (WORKFLOW_ID, PARAM_NAME, PARAM_QNAME, PARAM_HOLDER),
  FOREIGN KEY (WORKFLOW_ID) REFERENCES WF_WORKFLOW(ID)ON DELETE CASCADE)
/

CREATE TABLE WF_REQUEST_ENTITY_RELATIONSHIP(
  REQUEST_ID VARCHAR (45) NOT NULL,
  ENTITY_NAME VARCHAR (255) NOT NULL,
  ENTITY_TYPE VARCHAR (50) NOT NULL,
  TENANT_ID INTEGER NOT NULL DEFAULT -1,
  PRIMARY KEY(REQUEST_ID, ENTITY_NAME, ENTITY_TYPE, TENANT_ID),
  FOREIGN KEY (REQUEST_ID) REFERENCES WF_REQUEST(UUID)ON DELETE CASCADE)
/

CREATE TABLE WF_WORKFLOW_REQUEST_RELATION(
  RELATIONSHIP_ID VARCHAR (45) NOT NULL,
  WORKFLOW_ID VARCHAR (45),
  REQUEST_ID VARCHAR (45),
  UPDATED_AT TIMESTAMP,
  STATUS VARCHAR (30),
  TENANT_ID INTEGER DEFAULT -1,
  PRIMARY KEY (RELATIONSHIP_ID),
  FOREIGN KEY (WORKFLOW_ID) REFERENCES WF_WORKFLOW(ID)ON DELETE CASCADE,
  FOREIGN KEY (REQUEST_ID) REFERENCES WF_REQUEST(UUID)ON DELETE CASCADE)
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE SP_INBOUND_AUTH')
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_OAUTH1A_REQUEST_TOKEN')
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_OAUTH1A_ACCESS_TOKEN')
/
CALL SYSPROC.ADMIN_CMD('REORG TABLE IDN_IDENTITY_USER_DATA')
/