sp_rename 'IDN_OAUTH2_SCOPE.NAME', 'DISPLAY_NAME', 'COLUMN';
sp_rename 'IDN_OAUTH2_SCOPE.SCOPE_KEY', 'NAME', 'COLUMN';
ALTER TABLE IDN_OAUTH2_SCOPE ALTER COLUMN NAME VARCHAR(255) NOT NULL;
ALTER TABLE IDN_OAUTH2_SCOPE ALTER COLUMN DISPLAY_NAME VARCHAR(255) NOT NULL;
ALTER TABLE IDN_OAUTH2_SCOPE DROP COLUMN ROLES;
UPDATE IDN_OAUTH2_SCOPE SET TENANT_ID = -1 WHERE TENANT_ID = 0;
CREATE UNIQUE INDEX SCOPE_INDEX ON IDN_OAUTH2_SCOPE (NAME, TENANT_ID);

DECLARE @Command NVARCHAR(max), @ConstaintName NVARCHAR(max), @TableName NVARCHAR(max),@ColumnName NVARCHAR(max)
SET @TableName = 'IDN_OAUTH2_SCOPE'
SET @ColumnName ='TENANT_ID'
SELECT @ConstaintName = name
    FROM sys.default_constraints
    WHERE parent_object_id = object_id(@TableName)

SELECT @Command = 'ALTER TABLE '+@TableName+' drop constraint '+ @ConstaintName

IF @Command IS NOT NULL
BEGIN
    EXECUTE sp_executeSQL @Command
    SELECT @Command = 'ALTER TABLE '+@TableName+' ADD CONSTRAINT '+@ConstaintName+' DEFAULT -1 FOR ' + @ColumnName
    EXECUTE sp_executeSQL @Command
END

DECLARE @COMMAND1 NVARCHAR(200);SELECT TOP 1 @COMMAND1= 'ALTER TABLE IDN_OAUTH2_RESOURCE_SCOPE DROP CONSTRAINT ' + RC.CONSTRAINT_NAME + ';' FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KF ON RC.CONSTRAINT_NAME = KF.CONSTRAINT_NAME JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KP ON RC.UNIQUE_CONSTRAINT_NAME = KP.CONSTRAINT_NAME WHERE KF.TABLE_NAME = 'IDN_OAUTH2_RESOURCE_SCOPE' AND KP.TABLE_NAME='IDN_OAUTH2_SCOPE';EXEC (@COMMAND1);

ALTER TABLE IDN_OAUTH2_RESOURCE_SCOPE ALTER COLUMN SCOPE_ID INTEGER NOT NULL;
ALTER TABLE IDN_OAUTH2_RESOURCE_SCOPE ADD FOREIGN KEY (SCOPE_ID) REFERENCES IDN_OAUTH2_SCOPE(SCOPE_ID) ON DELETE CASCADE;
