/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.examples.MessageReceiverListenerImpl;
import org.jsmpp.examples.util.Concatenation;
import org.jsmpp.examples.util.Gsm0338;
import org.jsmpp.examples.util.Ucs2;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.util.HexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitMultipartMultilangualExample {
    private static final Logger log = LoggerFactory.getLogger(SubmitMultipartMultilangualExample.class);
    private static final Random RANDOM = new Random();
    private static final Charset UCS2_CHARSET = StandardCharsets.UTF_16BE;
    private static final Charset ISO_LATIN_CHARSET = StandardCharsets.ISO_8859_1;
    private static final int MAX_SINGLE_MSG_CHAR_SIZE_7BIT = 160;
    private static final int MAX_SINGLE_MSG_CHAR_SIZE_UCS2 = 70;

    public static void main(String[] args) throws IOException, InterruptedException {
        new SubmitMultipartMultilangualExample().sendAndWait();
    }

    private void sendAndWait() throws IOException, InterruptedException {
        ESMClass esmClass;
        Object messages;
        GeneralDataCoding dataCoding;
        String sourceMsisdn = "1616";
        String destinationMsisdn = "666111222";
        MessageClass messageClass = MessageClass.CLASS1;
        String messageBody = "Lorem ipsum dolor sit amet enim. Etiam ullamcorper. Suspendisse a pellentesque dui, non felis. Maecenas malesuada elit lectus felis, malesuada ultricies. Curabitur et ligula. Ut molestie a, ultricies porta urna.";
        boolean use16bitReference = false;
        Charset smscDefaultCharset = ISO_LATIN_CHARSET;
        SMPPSession session = new SMPPSession();
        session.addSessionStateListener((SessionStateListener)new SessionStateListenerImpl());
        session.setMessageReceiverListener((MessageReceiverListener)new MessageReceiverListenerImpl());
        try {
            session.connectAndBind("localhost", 2775, new BindParameter(BindType.BIND_TRX, "smppclient", "password", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
        }
        catch (IOException e) {
            throw new IOException("Failed connect and bind to host", e);
        }
        if (Gsm0338.isBasicEncodeable(messageBody)) {
            dataCoding = new GeneralDataCoding(Alphabet.ALPHA_DEFAULT, messageClass);
            if (Gsm0338.countSeptets(messageBody) > 160) {
                messages = Concatenation.splitGsm7bit(messageBody, smscDefaultCharset, RANDOM.nextInt(), use16bitReference);
                esmClass = new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.UDHI);
            } else {
                messages = new byte[][]{messageBody.getBytes(smscDefaultCharset)};
                esmClass = new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.DEFAULT);
            }
        } else if (Ucs2.isUcs2Encodable(messageBody)) {
            dataCoding = new GeneralDataCoding(Alphabet.ALPHA_UCS2, messageClass);
            if (messageBody.length() > 70) {
                messages = Concatenation.splitUcs2(messageBody, RANDOM.nextInt(), use16bitReference);
                esmClass = new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.UDHI);
            } else {
                messages = new byte[][]{messageBody.getBytes(UCS2_CHARSET)};
                esmClass = new ESMClass(MessageMode.DEFAULT, MessageType.DEFAULT, GSMSpecificFeature.DEFAULT);
            }
        } else {
            log.error("The message '{}' contains non-encodeable characters", (Object)messageBody);
            return;
        }
        log.info("Sending message '{}'", (Object)messageBody);
        log.info("Message is {} characters long and will be sent as {} messages with data coding {}", new Object[]{messageBody.length(), ((byte[][])messages).length, HexUtil.convertByteToHexString((byte)dataCoding.toByte())});
        for (byte[] message : messages) {
            String messageId = this.submitMessage(session, message, sourceMsisdn, destinationMsisdn, (DataCoding)dataCoding, esmClass);
            log.info("Message submitted, message_id is {}", (Object)messageId);
        }
        log.info("Entering listening mode. Press Enter to finish...");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            log.error("I/O error occurred", (Throwable)iOException);
        }
        session.unbindAndClose();
    }

    private String submitMessage(SMPPSession session, byte[] message, String sourceMsisdn, String destinationMsisdn, DataCoding dataCoding, ESMClass esmClass) {
        String messageId = null;
        try {
            SubmitSmResult submitSmResult = session.submitShortMessage("CMT", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, sourceMsisdn, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, destinationMsisdn, esmClass, (byte)0, (byte)1, null, null, new RegisteredDelivery(SMSCDeliveryReceipt.SUCCESS_FAILURE), (byte)0, dataCoding, (byte)0, message, new OptionalParameter[0]);
            messageId = submitSmResult.getMessageId();
        }
        catch (PDUException e) {
            log.error("Invalid PDU parameter", (Throwable)e);
        }
        catch (ResponseTimeoutException e) {
            log.error("Response timeout", (Throwable)e);
        }
        catch (InvalidResponseException e) {
            log.error("Receive invalid response", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            log.error("Receive negative response", (Throwable)e);
        }
        catch (IOException e) {
            log.error("I/O error occurred", (Throwable)e);
        }
        return messageId;
    }

    private static class SessionStateListenerImpl
    implements SessionStateListener {
        private SessionStateListenerImpl() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            log.info("Session {} state changed from {} to {}", new Object[]{source.getSessionId(), oldState, newState});
        }
    }
}

