/*
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.jsmpp.bean;

import java.util.Objects;

/**
 * Raw data coding is intended for reserved coding groups.
 * 
 * @author uudashr
 * 
 */
public class RawDataCoding implements DataCoding {
    private final byte value;
    
    /**
     * Construct with specified value from PDU.
     * 
     * @param value is the byte value from PDU.
     */
    public RawDataCoding(byte value) {
        this.value = value;
    }
    
    public byte toByte() {
        return value;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RawDataCoding)) {
            return false;
        }
        final RawDataCoding that = (RawDataCoding) o;
        return value == that.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return "DataCoding:" + (0xff & toByte());
    }
}
