/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.eclipse.tycho.model.ProductConfiguration;
import org.wso2.maven.p2.generate.utils.FileManagementUtil;

public class MaterializeProductMojo
extends AbstractMojo {
    protected MavenProject project;
    private URL metadataRepository;
    private URL artifactRepository;
    private File productConfigurationFile;
    private URL targetPath;
    private ProductConfiguration productConfiguration;
    private String profile;
    private P2ApplicationLauncher launcher;
    private int forkedProcessTimeoutInSeconds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.profile == null) {
                this.profile = "WSO2CarbonProfile";
            }
            this.deployRepository();
            File profileConfigIni = FileManagementUtil.getProfileConfigIniFile(this.targetPath.getPath(), this.profile);
            FileManagementUtil.changeConfigIniProperty(profileConfigIni, "eclipse.p2.data.area", "@config.dir/../../p2/");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", e);
        }
    }

    private void regenerateCUs() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Regenerating config.ini");
        Properties props = new Properties();
        String id = this.productConfiguration.getId();
        this.setPropertyIfNotNull(props, "osgi.bundles", this.getFeaturesOsgiBundles());
        this.setPropertyIfNotNull(props, "osgi.bundles.defaultStartLevel", "4");
        if (this.profile == null) {
            this.profile = "profile";
        }
        this.setPropertyIfNotNull(props, "eclipse.p2.profile", this.profile);
        this.setPropertyIfNotNull(props, "eclipse.product", id);
        this.setPropertyIfNotNull(props, "eclipse.p2.data.area", "@config.dir/../p2/");
        this.setPropertyIfNotNull(props, "eclipse.application", this.productConfiguration.getApplication());
        File configsFolder = new File(this.targetPath.toString(), "configuration");
        configsFolder.mkdirs();
        File configIni = new File(configsFolder, "config.ini");
        try {
            FileOutputStream fos = new FileOutputStream(configIni);
            props.store(fos, "Product Runtime Configuration File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private String getFeaturesOsgiBundles() {
        String bundles = "org.eclipse.equinox.common@2:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start,org.eclipse.equinox.ds@1:start,org.eclipse.equinox.simpleconfigurator@1:start";
        return bundles;
    }

    private void deployRepository() throws Exception {
        this.productConfiguration = ProductConfiguration.read((File)this.productConfigurationFile);
        P2ApplicationLauncher launcher = this.launcher;
        launcher.setWorkingDirectory(this.project.getBasedir());
        launcher.setApplicationName("org.eclipse.equinox.p2.director");
        launcher.addArguments(new String[]{"-metadataRepository", this.metadataRepository.toExternalForm(), "-artifactRepository", this.metadataRepository.toExternalForm(), "-installIU", this.productConfiguration.getId(), "-profileProperties", "org.eclipse.update.install.features=true", "-profile", this.profile.toString(), "-bundlepool", this.targetPath.toExternalForm(), "-shared", this.targetPath.toExternalForm() + File.separator + "p2", "-destination", this.targetPath.toExternalForm() + File.separator + this.profile, "-p2.os", "linux", "-p2.ws", "gtk", "-p2.arch", "x86", "-roaming"});
        int result = launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }
}

