/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.wso2.maven.p2.Feature;
import org.wso2.maven.p2.P2Profile;
import org.wso2.maven.p2.P2Repository;
import org.wso2.maven.p2.generate.utils.FileManagementUtil;

public class ProfileGenMojo
extends AbstractMojo {
    private String destination;
    private String profile;
    private URL metadataRepository;
    private URL artifactRepository;
    private ArrayList features;
    private boolean deleteOldProfileFiles = true;
    private P2Repository p2Repository;
    private MavenProject project;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private P2Profile p2Profile;
    private MavenProjectHelper projectHelper;
    private P2ApplicationLauncher launcher;
    private int forkedProcessTimeoutInSeconds;
    private File FOLDER_TARGET;
    private File FOLDER_TEMP;
    private File FOLDER_TEMP_REPO_GEN;
    private File FILE_FEATURE_PROFILE;
    private File p2AgentDir;
    private final String STREAM_TYPE_IN = "inputStream";
    private final String STREAM_TYPE_ERROR = "errorStream";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.profile == null) {
                this.profile = "WSO2CarbonProfile";
            }
            this.createAndSetupPaths();
            this.rewriteEclipseIni();
            this.getLog().info((CharSequence)"Running Equinox P2 Director Application");
            this.installFeatures(this.getIUsToInstall());
            File profileConfigIni = FileManagementUtil.getProfileConfigIniFile(this.destination, this.profile);
            FileManagementUtil.changeConfigIniProperty(profileConfigIni, "eclipse.p2.data.area", "@config.dir/../../p2/");
            if (this.deleteOldProfileFiles) {
                this.deleteOldProfiles();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        this.performMopUp();
    }

    private String getIUsToInstall() throws MojoExecutionException {
        String installUIs = "";
        for (Object featureObj : this.features) {
            Feature f = featureObj instanceof Feature ? (Feature)featureObj : (featureObj instanceof String ? Feature.getFeature(featureObj.toString()) : (Feature)featureObj);
            installUIs = installUIs + f.getId().trim() + "/" + f.getVersion().trim() + ",";
        }
        if (installUIs.length() == 0) {
            installUIs = installUIs.substring(0, installUIs.length() - 1);
        }
        return installUIs;
    }

    private String getPublisherApplication() {
        return "org.eclipse.equinox.p2.director";
    }

    private void installFeatures(String installUIs) throws Exception {
        P2ApplicationLauncher launcher = this.launcher;
        launcher.setWorkingDirectory(this.project.getBasedir());
        launcher.setApplicationName(this.getPublisherApplication());
        this.addArguments(launcher, installUIs);
        int result = launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    private void addArguments(P2ApplicationLauncher launcher, String installUIs) throws IOException, MalformedURLException {
        launcher.addArguments(new String[]{"-metadataRepository", this.metadataRepository.toExternalForm(), "-artifactRepository", this.artifactRepository.toExternalForm(), "-profileProperties", "org.eclipse.update.install.features=true", "-installIU", installUIs, "-bundlepool", this.destination, "-shared", this.destination + File.separator + "p2", "-destination", this.destination + File.separator + this.profile, "-profile", this.profile.toString(), "-roaming"});
    }

    private void createAndSetupPaths() throws Exception {
        this.FOLDER_TARGET = new File(this.project.getBasedir(), "target");
        String timestampVal = String.valueOf(new Date().getTime());
        this.FOLDER_TEMP = new File(this.FOLDER_TARGET, "tmp." + timestampVal);
        this.FOLDER_TEMP_REPO_GEN = new File(this.FOLDER_TEMP, "temp_repo");
        this.FILE_FEATURE_PROFILE = new File(this.FOLDER_TARGET, this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
    }

    private void deleteOldProfiles() {
        String profileFolderName;
        File profileFolder;
        if (!this.destination.endsWith("/")) {
            this.destination = this.destination + "/";
        }
        if ((profileFolder = new File(profileFolderName = this.destination + "p2/org.eclipse.equinox.p2.engine/profileRegistry/" + this.profile + ".profile")).isDirectory()) {
            Object[] profileFileList = profileFolder.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".profile");
                }
            });
            Arrays.sort(profileFileList);
            for (int i = 0; i < profileFileList.length - 1; ++i) {
                File profileFile = new File(profileFolderName, (String)profileFileList[i]);
                profileFile.delete();
            }
        }
    }

    private void rewriteEclipseIni() {
        File eclipseIni = null;
        String profileLocation = this.destination + File.separator + this.profile;
        eclipseIni = new File(profileLocation + File.separator + "null.ini");
        if (eclipseIni.exists()) {
            this.rewriteFile(eclipseIni, profileLocation);
            return;
        }
        eclipseIni = new File(profileLocation + File.separator + "eclipse.ini");
        if (eclipseIni.exists()) {
            this.rewriteFile(eclipseIni, profileLocation);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteFile(File file, String profileLocation) {
        file.delete();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileWriter(file));
            pw.write("-install\n");
            pw.write(profileLocation);
            pw.flush();
        }
    }

    private void deployArtifact() {
        if (this.FILE_FEATURE_PROFILE != null && this.FILE_FEATURE_PROFILE.exists()) {
            this.project.getArtifact().setFile(this.FILE_FEATURE_PROFILE);
            this.projectHelper.attachArtifact(this.project, "zip", null, this.FILE_FEATURE_PROFILE);
        }
    }

    private void performMopUp() {
        try {
            FileUtils.deleteDirectory((File)this.FOLDER_TEMP);
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)new MojoExecutionException("Unable complete mop up operation", e));
        }
    }

    public class InputStreamHandler
    implements Runnable {
        String streamType;
        InputStream inputStream;

        public InputStreamHandler(String name, InputStream is) {
            this.streamType = name;
            this.inputStream = is;
        }

        public void start() {
            Thread thread = new Thread(this);
            thread.start();
        }

        @Override
        public void run() {
            try {
                String s;
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((s = bufferedReader.readLine()) != null) {
                    if ("inputStream".equals(this.streamType)) {
                        ProfileGenMojo.this.getLog().info((CharSequence)s);
                        continue;
                    }
                    if (!"errorStream".equals(this.streamType)) continue;
                    ProfileGenMojo.this.getLog().error((CharSequence)s);
                }
                this.inputStream.close();
            }
            catch (Exception ex) {
                ProfileGenMojo.this.getLog().error((CharSequence)("Problem reading the " + this.streamType + "."), (Throwable)ex);
            }
        }
    }
}

