/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2;

import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class FeatureArtifact {
    private String groupId;
    private String artifactId;
    private String version;
    private Artifact artifact;
    private String featureId;
    private String featureVersion;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    protected static FeatureArtifact getFeatureArtifact(String featureArtifactDefinition, FeatureArtifact featureArtifact) throws MojoExecutionException {
        String[] split = featureArtifactDefinition.split(":");
        if (split.length > 1) {
            featureArtifact.setGroupId(split[0]);
            featureArtifact.setArtifactId(split[1]);
            if (split.length == 3) {
                featureArtifact.setVersion(split[2]);
            }
            return featureArtifact;
        }
        throw new MojoExecutionException("Insufficient artifact information provided to determine the feature: " + featureArtifactDefinition);
    }

    public static FeatureArtifact getFeatureArtifact(String featureArtifactDefinition) throws MojoExecutionException {
        return FeatureArtifact.getFeatureArtifact(featureArtifactDefinition, new FeatureArtifact());
    }

    public void resolveVersion(MavenProject project) throws MojoExecutionException {
        List dependencies;
        if (this.version == null) {
            dependencies = project.getDependencies();
            for (Dependency dependancy : dependencies) {
                if (!dependancy.getGroupId().equalsIgnoreCase(this.getGroupId()) || !dependancy.getArtifactId().equalsIgnoreCase(this.getArtifactId())) continue;
                this.setVersion(dependancy.getVersion());
            }
        }
        if (this.version == null) {
            dependencies = project.getDependencyManagement().getDependencies();
            for (Dependency dependancy : dependencies) {
                if (!dependancy.getGroupId().equalsIgnoreCase(this.getGroupId()) || !dependancy.getArtifactId().equalsIgnoreCase(this.getArtifactId())) continue;
                this.setVersion(dependancy.getVersion());
            }
        }
        if (this.version == null) {
            throw new MojoExecutionException("Could not find the version for " + this.getGroupId() + ":" + this.getArtifactId());
        }
        Properties properties = project.getProperties();
        for (Object key : properties.keySet()) {
            this.version = this.version.replaceAll(Pattern.quote("${" + key + "}"), properties.get(key).toString());
        }
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureVersion(String featureVersion) {
        this.featureVersion = featureVersion;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }
}

