/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2;

import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.p2.generate.feature.Bundle;

public class CatFeature {
    private String id;
    private String version;
    private MavenProject project;
    private boolean versionReplaced = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() throws MojoExecutionException {
        if (!this.versionReplaced) {
            this.replaceProjectKeysInVersion(this.project);
        }
        return Bundle.getOSGIVersion(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void replaceProjectKeysInVersion(MavenProject project) throws MojoExecutionException {
        if (this.version == null) {
            throw new MojoExecutionException("Could not find the version for featureId: " + this.getId());
        }
        Properties properties = project.getProperties();
        for (Object key : properties.keySet()) {
            this.version = this.version.replaceAll(Pattern.quote("${" + key + "}"), properties.get(key).toString());
        }
        this.versionReplaced = true;
    }
}

