/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.generate.feature;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.wso2.maven.p2.generate.feature.Bundle;
import org.wso2.maven.p2.generate.utils.P2Utils;

public class ImportFeature {
    private String featureId;
    private String featureVersion;
    private String compatibility;
    private Artifact artifact;
    private boolean isOptional;

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setCompatibility(String compatibility) {
        this.compatibility = compatibility;
    }

    public String getCompatibility() {
        return this.compatibility;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean optional) {
        this.isOptional = optional;
    }

    protected static ImportFeature getFeature(String featureDefinition) throws MojoExecutionException {
        String[] split = featureDefinition.split(":");
        ImportFeature feature = new ImportFeature();
        if (split.length > 0) {
            feature.setFeatureId(split[0]);
            String match = "equivalent";
            if (split.length > 1) {
                if (P2Utils.isMatchString(split[1])) {
                    match = split[1].toUpperCase();
                    if (match.equalsIgnoreCase("optional")) {
                        feature.setOptional(true);
                    }
                    if (split.length > 2) {
                        feature.setFeatureVersion(split[2]);
                    }
                } else {
                    feature.setFeatureVersion(split[1]);
                    if (split.length > 2 && P2Utils.isMatchString(split[2]) && (match = split[2].toUpperCase()).equalsIgnoreCase("optional")) {
                        feature.setOptional(true);
                    }
                }
            }
            feature.setCompatibility(match);
            return feature;
        }
        throw new MojoExecutionException("Insufficient feature artifact information provided to determine the feature: " + featureDefinition);
    }

    public void setFeatureVersion(String version) {
        if (this.featureVersion == null || this.featureVersion.equals("")) {
            this.featureVersion = Bundle.getOSGIVersion(version);
        }
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }
}

