/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2;

import java.io.File;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.UnArchiver;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.eclipse.tycho.model.ProductConfiguration;

public class PublishProductMojo
extends AbstractMojo {
    protected MavenProject project;
    private URL metadataRepository;
    private URL artifactRepository;
    private String executable;
    private UnArchiver deflater;
    private File productConfigurationFile;
    private ProductConfiguration productConfiguration;
    private P2ApplicationLauncher launcher;
    private int forkedProcessTimeoutInSeconds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.publishProduct();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", e);
        }
    }

    private void publishProduct() throws Exception {
        this.productConfiguration = ProductConfiguration.read((File)this.productConfigurationFile);
        P2ApplicationLauncher launcher = this.launcher;
        launcher.setWorkingDirectory(this.project.getBasedir());
        launcher.setApplicationName("org.eclipse.equinox.p2.publisher.ProductPublisher");
        launcher.addArguments(new String[]{"-metadataRepository", this.metadataRepository.toString(), "-artifactRepository", this.metadataRepository.toString(), "-productFile", this.productConfigurationFile.getCanonicalPath(), "-executables", this.executable.toString(), "-publishArtifacts", "-configs", "gtk.linux.x86", "-flavor", "tooling", "-append"});
        int result = launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }
}

