/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ServiceContext;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.carbon.application.mgt.stub.upload.types.carbon.UploadedFileItem;
import org.wso2.carbon.stub.ApplicationAdminStub;
import org.wso2.carbon.stub.AuthenticationAdminStub;
import org.wso2.carbon.stub.CarbonAppUploaderStub;
import org.wso2.maven.car.artifact.CarbonServer;

public class DeployCarMojo
extends AbstractMojo {
    private static final String EXTENSION_CAR = ".car";
    private String trustStorePath;
    private String trustStorePassword;
    private String trustStoreType;
    private String serverUrl;
    private String userName;
    private String password;
    private File target;
    private File archiveLocation;
    public String finalName;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private String operation;
    private List<CarbonServer> carbonServers;
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping CAR artifact deployment to Carbon Server(s).");
            return;
        }
        if (this.carbonServers == null) {
            this.deployCAR();
        } else if (this.carbonServers != null && this.carbonServers.isEmpty()) {
            this.deployCAR();
        } else {
            for (CarbonServer server : this.carbonServers) {
                this.getLog().info((CharSequence)"Deploying to Server...");
                this.getLog().info((CharSequence)("TSPath=" + server.getTrustStorePath()));
                if (server.getTrustStorePath() != null) {
                    this.trustStorePath = server.getTrustStorePath();
                }
                this.getLog().info((CharSequence)("TSPWD=" + server.getTrustStorePassword()));
                if (server.getTrustStorePassword() != null) {
                    this.trustStorePassword = server.getTrustStorePassword();
                }
                this.getLog().info((CharSequence)("TSType=" + server.getTrustStoreType()));
                if (server.getTrustStoreType() != null) {
                    this.trustStoreType = server.getTrustStoreType();
                }
                this.getLog().info((CharSequence)("Server URL=" + server.getServerUrl()));
                if (server.getServerUrl() != null) {
                    this.serverUrl = server.getServerUrl();
                }
                this.getLog().info((CharSequence)("UserName=" + server.getUserName()));
                if (server.getUserName() != null) {
                    this.userName = server.getUserName();
                }
                this.getLog().info((CharSequence)("Password=" + server.getPassword()));
                if (server.getPassword() != null) {
                    this.password = server.getPassword();
                }
                this.getLog().info((CharSequence)("Operation=" + server.getOperation()));
                if (server.getOperation() != null) {
                    this.operation = server.getOperation();
                }
                this.deployCAR();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deployCAR() throws MojoExecutionException {
        this.setSystemProperties();
        List buildPlugins = this.project.getBuildPlugins();
        for (Plugin plugin : buildPlugins) {
            String artifactId = plugin.getArtifactId();
            if (!artifactId.equals("maven-car-plugin")) continue;
            Xpp3Dom configurationNode = (Xpp3Dom)plugin.getConfiguration();
            Xpp3Dom finalNameNode = configurationNode.getChild("finalName");
            if (finalNameNode == null) break;
            this.finalName = finalNameNode.getValue();
            this.getLog().info((CharSequence)("Final Name of C-App: " + this.finalName + EXTENSION_CAR));
            break;
        }
        File carFile = null;
        if (null != this.archiveLocation) {
            if (!this.archiveLocation.isFile() || !this.archiveLocation.getName().endsWith(EXTENSION_CAR)) throw new MojoExecutionException("Archive location is not a valid file");
            carFile = this.archiveLocation;
        } else {
            carFile = this.finalName == null ? new File(this.target + File.separator + this.project.getArtifactId() + "_" + this.project.getVersion() + EXTENSION_CAR) : new File(this.target + File.separator + this.finalName + EXTENSION_CAR);
        }
        if (this.operation.equalsIgnoreCase("deploy")) {
            try {
                this.deployCApp(this.userName, this.password, this.serverUrl, carFile);
                this.getLog().info((CharSequence)("Uploading " + carFile.getName() + " to " + this.serverUrl + " completed successfully."));
                return;
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Uploading " + carFile.getName() + " to " + this.serverUrl + " Failed."), (Throwable)e);
                throw new MojoExecutionException("Deploying " + carFile.getName() + " to " + this.serverUrl + " Failed.", e);
            }
        }
        try {
            this.unDeployCAR(this.userName, this.password, this.serverUrl);
            this.getLog().info((CharSequence)("Deleting " + carFile.getName() + " to " + this.serverUrl + " completed successfully."));
            return;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Deleting " + carFile.getName() + " to " + this.serverUrl + " Failed."), (Throwable)e);
            throw new MojoExecutionException("Deleting " + carFile.getName() + " to " + this.serverUrl + " Failed.", e);
        }
    }

    private void printParams() {
        if (!this.carbonServers.isEmpty()) {
            for (CarbonServer server : this.carbonServers) {
                this.getLog().info((CharSequence)"Server:");
                this.getLog().info((CharSequence)("TSPath=" + server.getTrustStorePath()));
                this.getLog().info((CharSequence)("TSPWD=" + server.getTrustStorePassword()));
                this.getLog().info((CharSequence)("TSType=" + server.getTrustStoreType()));
                this.getLog().info((CharSequence)("Server URL=" + server.getServerUrl()));
                this.getLog().info((CharSequence)("UserName=" + server.getUserName()));
                this.getLog().info((CharSequence)("Password=" + server.getPassword()));
                this.getLog().info((CharSequence)("Operation=" + server.getOperation()));
                if (server.getUserName() != null) continue;
                this.getLog().info((CharSequence)"HIT THE GROUNDS!");
            }
        }
    }

    private void setSystemProperties() {
        System.setProperty("javax.net.ssl.trustStore", this.trustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        System.setProperty("javax.net.ssl.trustStoreType", this.trustStoreType);
    }

    private String createSessionCookie(String serverURL, String username, String pwd) throws Exception {
        URL url = new URL(serverURL);
        AuthenticationAdminStub authenticationStub = new AuthenticationAdminStub(serverURL + "/services/AuthenticationAdmin");
        authenticationStub._getServiceClient().getOptions().setManageSession(true);
        if (authenticationStub.login(username, pwd, url.getHost())) {
            ServiceContext serviceContext = authenticationStub._getServiceClient().getLastOperationContext().getServiceContext();
            String sessionCookie = (String)serviceContext.getProperty("Cookie");
            this.getLog().info((CharSequence)("Authentication to " + serverURL + " successful."));
            return sessionCookie;
        }
        return null;
    }

    private CarbonAppUploaderStub getCarbonAppUploaderStub(String username, String pwd, String url) throws Exception, AxisFault, MalformedURLException {
        String sessionCookie = this.createSessionCookie(url, username, pwd);
        CarbonAppUploaderStub carbonAppUploaderStub = new CarbonAppUploaderStub(this.serverUrl + "/services/CarbonAppUploader");
        carbonAppUploaderStub._getServiceClient().getOptions().setManageSession(true);
        carbonAppUploaderStub._getServiceClient().getOptions().setProperty("Cookie", (Object)sessionCookie);
        return carbonAppUploaderStub;
    }

    public void deployCApp(String username, String pwd, String url, File carFile) throws Exception {
        CarbonAppUploaderStub carbonAppUploaderStub = this.getCarbonAppUploaderStub(username, pwd, url);
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        DataHandler param = new DataHandler(carFile.toURI().toURL());
        uploadedFileItem.setDataHandler(param);
        uploadedFileItem.setFileName(carFile.getName());
        uploadedFileItem.setFileType("jar");
        UploadedFileItem[] fileItems = new UploadedFileItem[]{uploadedFileItem};
        this.getLog().info((CharSequence)("Uploading " + carFile.getName() + " to " + this.serverUrl + "..."));
        carbonAppUploaderStub.uploadApp(fileItems);
    }

    public void unDeployCAR(String username, String pwd, String serverURL) throws Exception {
        ApplicationAdminStub appAdminStub = this.getApplicationAdminStub(serverURL, username, pwd);
        String[] existingApplications = appAdminStub.listAllApplications();
        if (existingApplications != null && Arrays.asList(existingApplications).contains(this.project.getArtifactId() + "_" + this.project.getVersion())) {
            appAdminStub.deleteApplication(this.project.getArtifactId() + "_" + this.project.getVersion());
            this.getLog().info((CharSequence)("Located the C-App " + this.project.getArtifactId() + "_" + this.project.getVersion() + " and undeployed..."));
        }
    }

    private ApplicationAdminStub getApplicationAdminStub(String serverURL, String username, String pwd) throws Exception, AxisFault, MalformedURLException {
        String sessionCookie = this.createSessionCookie(serverURL, username, pwd);
        ApplicationAdminStub appAdminStub = new ApplicationAdminStub(this.serverUrl + "/services/ApplicationAdmin");
        appAdminStub._getServiceClient().getOptions().setManageSession(true);
        appAdminStub._getServiceClient().getOptions().setProperty("Cookie", (Object)sessionCookie);
        return appAdminStub;
    }
}

