/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugin.datasource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.mojo.AbstractPOMGenMojo;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.plugin.datasource.DSSArtifact;
import org.wso2.maven.plugin.datasource.utils.DSSMavenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcePOMGenMojo
extends AbstractPOMGenMojo {
    public MavenProject project;
    public MavenProjectHelper projectHelper;
    public File outputLocation;
    public File artifactLocation;
    public File moduleProject;
    public String groupId;
    public String typeList;
    private static final String ARTIFACT_TYPE = "datasource/datasource";

    private List<DSSArtifact> retrieveArtifacts() {
        return DSSMavenUtils.retrieveArtifacts(this.getArtifactLocation());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<DSSArtifact> artifacts = this.retrieveArtifacts();
        ArrayList<Artifact> mappedArtifacts = new ArrayList<Artifact>();
        for (DSSArtifact dssArtifact : artifacts) {
            Artifact artifact = new Artifact();
            artifact.setName(dssArtifact.getName());
            artifact.setVersion(dssArtifact.getVersion());
            artifact.setType(dssArtifact.getType());
            artifact.setServerRole(dssArtifact.getServerRole());
            artifact.setFile(dssArtifact.getFile());
            artifact.setSource(new File(this.getArtifactLocation(), "artifact.xml"));
            mappedArtifacts.add(artifact);
        }
        super.processArtifacts(mappedArtifacts);
    }

    protected void copyResources(MavenProject project, File projectLocation, Artifact artifact) throws IOException {
        File dataServiceArtifact = this.processTokenReplacement(artifact);
        if (dataServiceArtifact == null) {
            dataServiceArtifact = artifact.getFile();
        }
        FileUtils.copyFile((File)dataServiceArtifact, (File)new File(projectLocation, artifact.getFile().getName()));
    }

    protected void addPlugins(MavenProject artifactMavenProject, Artifact artifact) {
        Plugin plugin = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.wso2.maven", (String)"maven-datasource-plugin", (String)"1.0.0", (boolean)true);
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom aritfact = CAppMavenUtils.createConfigurationNode((Xpp3Dom)configuration, (String)"artifact");
        aritfact.setValue(artifact.getFile().getName());
    }

    protected String getArtifactType() {
        return ARTIFACT_TYPE;
    }
}

