/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugin.datasource.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.maven.plugin.datasource.DSSArtifact;
import org.wso2.maven.plugin.datasource.DSSProjectArtifacts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSSMavenUtils {
    private static List<String> excludeList = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(DSSMavenUtils.class.getName());

    public static List<DSSArtifact> retrieveArtifacts(File path) {
        return DSSMavenUtils.retrieveArtifacts(new File(path, "artifact.xml"), new ArrayList<DSSArtifact>());
    }

    private static List<DSSArtifact> retrieveArtifacts(File path, List<DSSArtifact> artifacts) {
        if (path.exists()) {
            if (path.isFile()) {
                DSSProjectArtifacts artifact = new DSSProjectArtifacts();
                try {
                    artifact.fromFile(path);
                    for (DSSArtifact dssArtifact : artifact.getAllDSSArtifacts()) {
                        if (dssArtifact.getVersion() == null || dssArtifact.getType() == null) continue;
                        artifacts.add(dssArtifact);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Unable to Retrieve Artifact");
                }
            } else {
                File[] files;
                for (File file : files = path.listFiles()) {
                    if (excludeList.contains(file.getName())) continue;
                    DSSMavenUtils.retrieveArtifacts(file, artifacts);
                }
            }
        }
        return artifacts;
    }

    static {
        excludeList.add(".svn");
    }
}

