/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;
import org.wso2.config.mapper.util.FileUtils;

@Mojo(name="config-mapper-parser")
public class ConfigMapParserMojo
extends AbstractMojo {
    @Parameter(property="miVersion")
    private String miVersion;

    public void execute() throws MojoExecutionException {
        try {
            boolean isDownloaded = this.downloadTemplates();
            if (!isDownloaded) {
                return;
            }
            String templatePath = "ConfigMapResources" + File.separator + "templates";
            File deplymentTomlFile = new File("deployment.toml");
            boolean isDeploymentTomlFileExist = deplymentTomlFile.exists();
            File templateDirectory = new File(templatePath);
            boolean isTemplateDirectoryExist = templateDirectory.exists();
            boolean isParsedSuccessfully = false;
            if (isDeploymentTomlFileExist && isTemplateDirectoryExist) {
                this.getLog().info((CharSequence)"ConfigParser for deployment.toml file has been started");
                this.runConfigMapParser(deplymentTomlFile, templatePath);
                isParsedSuccessfully = true;
                this.getLog().info((CharSequence)"ConfigParser successfully parsed the deployment.toml file");
            } else {
                this.getLog().warn((CharSequence)"Required files not found for the Config Parser: deployment.toml file or template files");
            }
            if (isParsedSuccessfully) {
                ArrayList<String> parsedOutputFileList = new ArrayList<String>();
                this.listFilesForFolder(new File("CarbonHome"), parsedOutputFileList);
                this.updateDockerFile(parsedOutputFileList);
                this.getLog().info((CharSequence)"Dockerfile successfully updated with the config files");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while parsing the deployment.toml file \n" + e);
        }
    }

    private boolean downloadTemplates() throws ConfigParserException, ZipException {
        boolean isDownloaded = true;
        String sourceURL = "http://product-dist.wso2.com/p2/templates/" + this.miVersion + "/" + "templates.zip";
        FileUtils.deleteDirectory((File)new File("ConfigMapResources"));
        File tempFile = new File("ConfigMapResources");
        if (!tempFile.mkdirs()) {
            return false;
        }
        try (InputStream inputStream = new URL(sourceURL).openStream();){
            if (inputStream.available() == 0) {
                isDownloaded = false;
            } else {
                String templateZipLocation = "ConfigMapResources" + File.separator + "templates.zip";
                Files.copy(inputStream, Paths.get(templateZipLocation, new String[0]), new CopyOption[0]);
                ZipFile zipFile = new ZipFile(templateZipLocation);
                zipFile.extractAll("ConfigMapResources");
                File templateZipFile = new File(templateZipLocation);
                if (!templateZipFile.delete()) {
                    this.getLog().warn((CharSequence)"Templates zip file can not delete from the resource path");
                }
            }
        }
        catch (IOException e) {
            isDownloaded = false;
            this.getLog().error((CharSequence)"Error while downloading the templates for config mapper", (Throwable)e);
        }
        return isDownloaded;
    }

    private void runConfigMapParser(File deploymentToml, String templatePath) throws ConfigParserException, IOException {
        Context context = new Context();
        ConfigParser.ConfigPaths.setPaths((String)"deployment.toml", (String)templatePath, (String)"CarbonHome");
        Map configMap = ConfigParser.parse((Context)context);
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        FileUtils.deleteDirectory((File)new File("CarbonHome"));
        for (Map.Entry entry : configMap.entrySet()) {
            String fileSource = (String)entry.getValue();
            String filePath = (String)entry.getKey();
            String fileFromOutput = "CarbonHome" + File.separator + filePath;
            File tempFile = new File(fileFromOutput);
            tempFile.getParentFile().mkdirs();
            tempFile.createNewFile();
            Files.write(Paths.get(fileFromOutput, new String[0]), fileSource.getBytes(), new OpenOption[0]);
            metaDataMap.put(filePath, DigestUtils.md5Hex((String)((String)entry.getValue())));
        }
        String tomlFileSource = new String(Files.readAllBytes(Paths.get("deployment.toml", new String[0])), StandardCharsets.UTF_8);
        String tomlOutputPath = "conf" + File.separator + "deployment.toml";
        metaDataMap.put(tomlOutputPath, DigestUtils.md5Hex((String)tomlFileSource));
        String confDirPath = "CarbonHome" + File.separator + "conf" + File.separator + "deployment.toml";
        File destinationFile = new File(confDirPath);
        Files.copy(deploymentToml.toPath(), destinationFile.toPath(), new CopyOption[0]);
        this.generateMetadataFolder(metaDataMap);
    }

    private void generateMetadataFolder(Map<String, String> metaDataMap) throws IOException {
        String templateFilePath = "CarbonHome" + File.separator + ".metadata" + File.separator + "metadata_config.properties";
        File tempFile = new File(templateFilePath);
        if (!tempFile.getParentFile().mkdirs() || !tempFile.createNewFile()) {
            throw new IOException("Creating .metadata directory in CarbonHome path failed");
        }
        try (FileOutputStream output = new FileOutputStream(templateFilePath);){
            Properties prop = new Properties();
            for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
                prop.setProperty(entry.getKey(), entry.getValue());
            }
            prop.store(output, null);
        }
        catch (IOException e) {
            throw new IOException("Exception while writing to the metadata_config.properties\n" + e);
        }
    }

    private void updateDockerFile(List<String> parsedOutputFileList) throws IOException {
        String dockerFileBaseEntries = this.getBaseImageInDockerfile();
        StringBuilder builder = new StringBuilder(dockerFileBaseEntries);
        builder.append(System.lineSeparator()).append("#[DO NOT REMOVE] Auto generated Docker commands for config-map parser").append(System.lineSeparator());
        String splitPattern = Pattern.quote(System.getProperty("file.separator"));
        for (String filePath : parsedOutputFileList) {
            String[] filePathSeparateList = filePath.split(splitPattern);
            StringBuilder innerBuilder = new StringBuilder();
            for (int x = 1; x < filePathSeparateList.length - 1; ++x) {
                innerBuilder.append(filePathSeparateList[x]).append("/");
            }
            innerBuilder.append(filePathSeparateList[filePathSeparateList.length - 1]);
            builder.append("COPY  --chown=wso2carbon:wso2 ").append(filePath.replaceAll(splitPattern, "/")).append(" ${WSO2_SERVER_HOME}/").append(innerBuilder.toString());
            builder.append(System.lineSeparator());
        }
        builder.append("RUN mkdir ${WSO2_SERVER_HOME}/repository/resources/conf/.metadata");
        builder.append(System.lineSeparator());
        builder.append("COPY  --chown=wso2carbon:wso2 ").append("CarbonHome").append("/").append(".metadata").append("/").append("metadata_config.properties").append(" ${WSO2_SERVER_HOME}/repository/resources/conf/.metadata").append(System.lineSeparator());
        builder.append("#[DO NOT REMOVE] End of auto generated Docker commands for config-map parser").append(System.lineSeparator());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
             FileOutputStream outputStream = new FileOutputStream(new File("Dockerfile"));){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new IOException("Exception while writing to the Dockerfile \n" + e);
        }
    }

    private void listFilesForFolder(File folder, List<String> outputList) {
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File fileEntry : listOfFiles) {
                if (fileEntry.isDirectory()) {
                    this.listFilesForFolder(fileEntry, outputList);
                    continue;
                }
                if (!fileEntry.isFile() || fileEntry.isHidden()) continue;
                outputList.add(fileEntry.getPath());
            }
        }
    }

    private String getBaseImageInDockerfile() throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferReader = new BufferedReader(new FileReader("Dockerfile"));){
            String currentLine;
            while ((currentLine = bufferReader.readLine()) != null) {
                if (currentLine.contains("#[DO NOT REMOVE] Auto generated Docker commands for config-map parser")) {
                    String autoGenerateCommandLine;
                    while ((autoGenerateCommandLine = bufferReader.readLine()) != null && !autoGenerateCommandLine.contains("#[DO NOT REMOVE] End of auto generated Docker commands for config-map parser")) {
                    }
                    continue;
                }
                builder.append(currentLine).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new IOException("Exception while writing to the Dockerfile \n" + e);
        }
        return builder.toString();
    }
}

