/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import net.consensys.cava.toml.Toml;
import net.consensys.cava.toml.TomlParseResult;
import net.consensys.cava.toml.TomlTable;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wso2.ciphertool.CipherTool;
import org.wso2.config.mapper.ConfigMapParserConstants;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

@Mojo(name="config-mapper-parser")
public class ConfigMapParserMojo
extends AbstractMojo {
    @Parameter(property="miVersion")
    private String miVersion;
    @Parameter(property="keystoreName")
    private String keystoreName;
    @Parameter(property="keystoreAlias")
    private String keystoreAlias;
    @Parameter(property="keystorePassword")
    private String keystorePassword;
    @Parameter(property="keystoreType")
    private String keystoreType;
    @Parameter(property="cipher")
    private String cipherTransformation;
    @Parameter(property="projectLocation")
    private String projectLocation;
    @Parameter(property="executeCipherTool")
    private Boolean executeCipherTool;

    public void execute() throws MojoExecutionException {
        try {
            this.projectLocation = this.projectLocation + File.separator;
            boolean isDownloaded = this.downloadTemplates();
            if (!isDownloaded) {
                this.getLog().error((CharSequence)("Error while downloading ConfigMapper templates for version " + this.miVersion));
                this.updateDockerfileAsDefault();
                return;
            }
            this.copyResourcesToTarget();
            System.setProperty("avoidResolvingEnvAndSysVariables", "true");
            String templatePath = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "ConfigMapResources" + File.separator + "templates";
            File deploymentTomlFile = new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "deployment.toml");
            boolean isDeploymentTomlFileExist = deploymentTomlFile.exists();
            File templateDirectory = new File(templatePath);
            boolean isTemplateDirectoryExist = templateDirectory.exists();
            if (this.executeCipherTool.booleanValue()) {
                this.initializeSystemProperties();
                if (this.cipherTransformation == null) {
                    this.cipherTransformation = "RSA/ECB/OAEPwithSHA1andMGF1Padding";
                }
                String[] args = new String[]{"-Dconfigure", "-Dorg.wso2.CipherTransformation=" + this.cipherTransformation};
                PrintStream originalStream = System.out;
                PrintStream dummyStream = new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                });
                System.setOut(dummyStream);
                CipherTool.main((String[])args);
                System.setOut(originalStream);
                this.getLog().info((CharSequence)"ConfigParser successfully encrypted all the given secrets");
                this.getLog().info((CharSequence)"Secret Configurations are written to the property file successfully");
                this.updateSecretConf();
                this.createPasswordTmpFile();
            }
            boolean isParsedSuccessfully = false;
            if (isDeploymentTomlFileExist && isTemplateDirectoryExist) {
                this.getLog().info((CharSequence)"ConfigParser for deployment.toml file has been started");
                this.runConfigMapParser(deploymentTomlFile, templatePath);
                isParsedSuccessfully = true;
                this.getLog().info((CharSequence)"ConfigParser successfully parsed the deployment.toml file");
            } else {
                this.getLog().warn((CharSequence)"Required files not found for the Config Parser: deployment.toml file or template files");
            }
            if (isParsedSuccessfully) {
                ArrayList<String> parsedOutputFileList = new ArrayList<String>();
                this.listFilesForFolder(new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome"), parsedOutputFileList);
                this.updateDockerFile(parsedOutputFileList, this.executeCipherTool);
                this.getLog().info((CharSequence)"Dockerfile successfully updated with the config files");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while parsing the deployment.toml file \n" + e);
        }
    }

    private void copyResourcesToTarget() throws MojoExecutionException {
        try {
            File sourceDir = new File(this.projectLocation + ConfigMapParserConstants.ORIGINAL_DOCKER_FOLDER_PATH);
            File targetDir = new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR);
            FileUtils.copyDirectory((File)sourceDir, (File)targetDir);
            FileUtils.copyFile((File)new File(this.projectLocation + "deployment", "deployment.toml"), (File)new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR, "deployment.toml"));
            FileUtils.copyDirectory((File)new File(this.projectLocation + "deployment", "libs"), (File)new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR, "libs"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while parsing the deployment.toml file \n" + e);
        }
    }

    private boolean downloadTemplates() throws ZipException, IOException {
        boolean isDownloaded = true;
        String sourceURL = "https://product-dist.wso2.com/p2/templates/" + this.miVersion + "/" + "templates.zip";
        String resourcesPath = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "ConfigMapResources";
        FileUtils.deleteDirectory((File)new File(resourcesPath));
        File tempFile = new File(resourcesPath);
        if (!tempFile.mkdirs()) {
            return false;
        }
        try (InputStream inputStream = new URL(sourceURL).openConnection().getInputStream();){
            String templateZipLocation = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "ConfigMapResources" + File.separator + "templates.zip";
            Files.copy(inputStream, Paths.get(templateZipLocation, new String[0]), new CopyOption[0]);
            ZipFile zipFile = new ZipFile(templateZipLocation);
            zipFile.extractAll(resourcesPath);
            File templateZipFile = new File(templateZipLocation);
            if (!templateZipFile.delete()) {
                this.getLog().warn((CharSequence)"Templates zip file can not delete from the resource path");
            }
        }
        catch (IOException e) {
            isDownloaded = false;
            this.getLog().error((CharSequence)"Error while downloading the templates for config mapper", (Throwable)e);
        }
        return isDownloaded;
    }

    private void runConfigMapParser(File deploymentToml, String templatePath) throws ConfigParserException, IOException {
        Context context = new Context();
        ConfigParser.ConfigPaths.setPaths((String)(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "deployment.toml"), (String)templatePath, (String)(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome"));
        Map configMap = ConfigParser.parse((Context)context);
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        FileUtils.deleteDirectory((File)new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome"));
        for (Map.Entry entry : configMap.entrySet()) {
            String fileSource = (String)entry.getValue();
            String filePath = (String)entry.getKey();
            String fileFromOutput = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome" + File.separator + filePath;
            File tempFile = new File(fileFromOutput);
            tempFile.getParentFile().mkdirs();
            tempFile.createNewFile();
            Files.write(Paths.get(fileFromOutput, new String[0]), fileSource.getBytes(), new OpenOption[0]);
            metaDataMap.put(filePath, DigestUtils.md5Hex((String)((String)entry.getValue())));
        }
        String tomlFileSource = new String(Files.readAllBytes(Paths.get(this.projectLocation, ConfigMapParserConstants.TEMP_DOCKER_DIR, "deployment.toml")), StandardCharsets.UTF_8);
        String tomlOutputPath = "conf" + File.separator + "deployment.toml";
        metaDataMap.put(tomlOutputPath, DigestUtils.md5Hex((String)tomlFileSource));
        String confDirPath = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome" + File.separator + "conf" + File.separator + "deployment.toml";
        File destinationFile = new File(confDirPath);
        Files.copy(deploymentToml.toPath(), destinationFile.toPath(), new CopyOption[0]);
        this.generateMetadataFolder(metaDataMap);
    }

    private void generateMetadataFolder(Map<String, String> metaDataMap) throws IOException {
        String templateFilePath = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome" + File.separator + ".metadata" + File.separator + "metadata_config.properties";
        File tempFile = new File(templateFilePath);
        if (!tempFile.getParentFile().mkdirs() || !tempFile.createNewFile()) {
            throw new IOException("Creating .metadata directory in " + this.projectLocation + "CarbonHome" + " path failed");
        }
        try (FileOutputStream output = new FileOutputStream(templateFilePath);){
            Properties prop = new Properties();
            for (Map.Entry<String, String> entry : metaDataMap.entrySet()) {
                prop.setProperty(entry.getKey(), entry.getValue());
            }
            prop.store(output, null);
        }
        catch (IOException e) {
            throw new IOException("Exception while writing to the metadata_config.properties\n" + e);
        }
        String referenceFilePath = this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "CarbonHome" + File.separator + ".metadata" + File.separator + "references.properties";
        File referenceFile = new File(referenceFilePath);
        if (!referenceFile.exists() && !referenceFile.createNewFile()) {
            throw new IOException("Creating references.properties in .metadata directory path failed");
        }
    }

    private void updateDockerFile(List<String> parsedOutputFileList, boolean deploymentHasSecrets) throws IOException {
        String dockerFileBaseEntries = this.getBaseImageInDockerfile();
        StringBuilder builder = new StringBuilder(dockerFileBaseEntries);
        builder.append(System.lineSeparator()).append("#[DO NOT REMOVE] Auto generated Docker commands for config-map parser").append(System.lineSeparator());
        for (String filePath : parsedOutputFileList) {
            String[] filePathSeparateList = filePath.split(ConfigMapParserConstants.SPLIT_PATTERN);
            StringBuilder innerBuilder = new StringBuilder();
            for (int x = 3; x < filePathSeparateList.length - 1; ++x) {
                innerBuilder.append(filePathSeparateList[x]).append("/");
            }
            innerBuilder.append(filePathSeparateList[filePathSeparateList.length - 1]);
            builder.append("COPY  --chown=wso2carbon:wso2 ").append(filePath.replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/").replaceAll(Pattern.quote(ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator), "")).append(" ${WSO2_SERVER_HOME}/").append(innerBuilder.toString());
            builder.append(System.lineSeparator());
        }
        if (deploymentHasSecrets) {
            String secretConfLocalLocation = Paths.get("resources", "secret-conf.properties").toString().replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/");
            String secretConfRuntimeLocation = Paths.get(" ${WSO2_SERVER_HOME}/", "conf", "security", "secret-conf.properties").toString().replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/");
            builder.append("COPY  --chown=wso2carbon:wso2 ").append(secretConfLocalLocation).append(secretConfRuntimeLocation).append(System.lineSeparator());
            String passwordTmpLocalLocation = Paths.get("resources", "password-tmp").toString().replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/");
            String passwordTmpRuntimeLocation = Paths.get(" ${WSO2_SERVER_HOME}/", "password-tmp").toString().replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/");
            builder.append("COPY  --chown=wso2carbon:wso2 ").append(passwordTmpLocalLocation).append(passwordTmpRuntimeLocation).append(System.lineSeparator());
        }
        builder.append("RUN mkdir ${WSO2_SERVER_HOME}/repository/resources/conf/.metadata");
        builder.append(System.lineSeparator());
        builder.append("COPY  --chown=wso2carbon:wso2 ").append("CarbonHome").append("/").append(".metadata").append("/").append("metadata_config.properties").append(" ${WSO2_SERVER_HOME}/repository/resources/conf/.metadata").append(System.lineSeparator());
        builder.append("COPY  --chown=wso2carbon:wso2 ").append("CarbonHome").append("/").append(".metadata").append("/").append("references.properties").append(" ${WSO2_SERVER_HOME}/repository/resources/conf/.metadata").append(System.lineSeparator());
        builder.append("#[DO NOT REMOVE] End of auto generated Docker commands for config-map parser").append(System.lineSeparator());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
             FileOutputStream outputStream = new FileOutputStream(new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "Dockerfile"));){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new IOException("Exception while writing to the Dockerfile \n" + e);
        }
    }

    private void listFilesForFolder(File folder, List<String> outputList) {
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File fileEntry : listOfFiles) {
                if (fileEntry.isDirectory() && !fileEntry.getName().equals(".metadata")) {
                    this.listFilesForFolder(fileEntry, outputList);
                    continue;
                }
                if (!fileEntry.isFile() || fileEntry.isHidden()) continue;
                outputList.add(StringUtils.substringAfter((String)fileEntry.getPath(), (String)this.projectLocation));
            }
        }
    }

    private String getBaseImageInDockerfile() throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferReader = new BufferedReader(new FileReader(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "Dockerfile"));){
            String currentLine;
            while ((currentLine = bufferReader.readLine()) != null) {
                if (currentLine.contains("#[DO NOT REMOVE] Auto generated Docker commands for config-map parser")) {
                    String autoGenerateCommandLine;
                    while ((autoGenerateCommandLine = bufferReader.readLine()) != null && !autoGenerateCommandLine.contains("#[DO NOT REMOVE] End of auto generated Docker commands for config-map parser")) {
                    }
                    continue;
                }
                builder.append(currentLine).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new IOException("Exception while writing to the Dockerfile \n" + e);
        }
        return builder.toString();
    }

    private void updateDockerfileAsDefault() throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.getBaseImageInDockerfile().getBytes(StandardCharsets.UTF_8));
             OutputStream outputStream = Files.newOutputStream(new File(this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "Dockerfile").toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            this.getLog().warn((CharSequence)"Updated Dockerfile to default");
        }
        catch (IOException e) {
            throw new IOException("Exception while making the Dockerfile to default \n" + e);
        }
    }

    public Map<String, String> getSecretsFromConfiguration(String configFilePath) throws IOException {
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
        TomlParseResult result = Toml.parse((Path)Paths.get(configFilePath, new String[0]));
        TomlTable table = result.getTable("secrets");
        if (table != null) {
            table.dottedKeySet().forEach(key -> context.put((String)key, table.getString(key)));
        }
        return context;
    }

    private void initializeSystemProperties() throws MojoExecutionException {
        String secretConfFile;
        String keystoreLocation;
        if (this.isKeystoreParametersAvailable()) {
            System.setProperty("external.system.properties", Boolean.TRUE.toString());
            keystoreLocation = Paths.get(this.projectLocation, ConfigMapParserConstants.TEMP_DOCKER_DIR, "resources", this.keystoreName).toString();
            secretConfFile = Paths.get(this.projectLocation, ConfigMapParserConstants.TEMP_DOCKER_DIR, "resources", "secret-conf.properties").toString();
            File keystore = new File(keystoreLocation);
            if (!keystore.exists()) {
                throw new MojoExecutionException("Keystore file is not available in " + keystoreLocation);
            }
            keystoreLocation = keystore.getAbsolutePath();
        } else {
            throw new MojoExecutionException("Keystore parameters have not been defined in pom.xml");
        }
        String cipherTextPropFile = "conf/security/cipher-text.properties";
        System.setProperty("primary.key.location", keystoreLocation.replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/"));
        System.setProperty("primary.key.alias", this.keystoreAlias);
        System.setProperty("primary.key.type", this.keystoreType);
        System.setProperty("keystore.password", this.keystorePassword);
        System.setProperty("deployment.config.file.path", this.projectLocation + ConfigMapParserConstants.TEMP_DOCKER_DIR + File.separator + "deployment.toml");
        System.setProperty("secret.conf.properties.file", secretConfFile.replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/"));
        System.setProperty("secretRepositories.file.location", cipherTextPropFile);
    }

    private boolean isKeystoreParametersAvailable() {
        return this.keystoreName != null && this.keystoreAlias != null && this.keystorePassword != null && this.keystoreType != null;
    }

    private void updateSecretConf() throws MojoExecutionException {
        String secretConfLocation = Paths.get(this.projectLocation, ConfigMapParserConstants.TEMP_DOCKER_DIR, "resources", "secret-conf.properties").toString();
        Properties secretConfProperties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(secretConfLocation);){
            secretConfProperties.load(inputStream);
            String defaultKeystoreLocation = Paths.get(".", "repository", "resources", "security", this.keystoreName).toString().replaceAll(ConfigMapParserConstants.SPLIT_PATTERN, "/");
            secretConfProperties.setProperty("keystore.identity.location", defaultKeystoreLocation);
            FileOutputStream outputStream = new FileOutputStream(secretConfLocation);
            secretConfProperties.store(outputStream, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while modifying secret-conf.properties file in " + secretConfLocation);
        }
    }

    private void createPasswordTmpFile() throws MojoExecutionException {
        String passwordTempFileLocation = Paths.get(this.projectLocation, ConfigMapParserConstants.TEMP_DOCKER_DIR, "resources", "password-tmp").toString();
        try (FileWriter fileWriter = new FileWriter(passwordTempFileLocation);){
            fileWriter.write(this.keystorePassword);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while creating " + passwordTempFileLocation);
        }
    }
}

