/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.mojo;

import java.io.File;
import java.io.IOException;
import java.sql.Time;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.model.ArtifactDependency;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.capp.utils.CAppUtils;

public abstract class AbstractPOMGenMojo
extends AbstractMojo {
    private static final String SYNAPSE_TYPE = "synapse/configuration";
    public MavenProject project;
    public MavenProjectHelper projectHelper;
    public File outputLocation;
    public File artifactLocation;
    public File moduleProject;
    public String groupId;
    public String typeList;
    private MavenProject mavenModuleProject;
    private File projectLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Artifact> artifacts = this.retrieveArtifacts();
        this.processArtifacts(artifacts);
    }

    protected abstract String getArtifactType();

    private String getArtifactPostFix() {
        if (SYNAPSE_TYPE.equalsIgnoreCase(this.getArtifactType())) {
            return this.getArtifactType().substring(0, this.getArtifactType().indexOf("/"));
        }
        return this.getArtifactType().substring(this.getArtifactType().indexOf("/") + 1);
    }

    protected void processArtifacts(List<Artifact> artifacts) throws MojoExecutionException {
        if (artifacts.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(System.currentTimeMillis() + " Artifacts list is empty. Nothing to process"));
            }
            File projectLocation = new File(this.getOutputLocation() + "");
            projectLocation.mkdirs();
            this.setProjectLocation(projectLocation);
            this.getMavenModuleProject();
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)(new Time(System.currentTimeMillis()) + " Artifacts list is not empty. Start processing"));
            }
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equalsIgnoreCase(this.getArtifactType())) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Creating maven project for artifact "));
                }
                this.getLog().info((CharSequence)("Creating maven project for artifact " + artifact.getName() + ":" + artifact.getVersion() + "..."));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Trying to generate the Maven Project..."));
                }
                this.getLog().info((CharSequence)"\tgenerating maven project...");
                File projectLocation = new File(this.getOutputLocation() + File.separator + this.getArtifactPostFix(), artifact.getName());
                projectLocation.mkdirs();
                this.setProjectLocation(projectLocation);
                MavenProject artifactMavenProject = this.createMavenProjectForCappArtifact(artifact, artifacts, projectLocation);
                artifactMavenProject.setDistributionManagement(this.project.getDistributionManagement());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Maven Project generation completed"));
                }
                if (artifactMavenProject == null) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Generated Maven project is not null"));
                }
                try {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " copying resources..."));
                    }
                    this.getLog().info((CharSequence)"\tcopying resources...");
                    String artifactAsMavenModule = CAppMavenUtils.getMavenModuleRelativePath((File)this.getModuleProject(), (File)projectLocation);
                    List existingModules = this.getMavenModuleProject().getModules();
                    if (!existingModules.contains(artifactAsMavenModule)) {
                        existingModules.add(artifactAsMavenModule);
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Module list is updated with new module."));
                    }
                    List repositories = this.project.getRepositories();
                    artifactMavenProject.getModel().getRepositories().addAll(repositories);
                    artifactMavenProject.getModel().getPluginRepositories().addAll(repositories);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Maven project successfully updated with Repositories"));
                    }
                    CAppMavenUtils.saveMavenProject((MavenProject)artifactMavenProject, (File)new File(projectLocation, "pom.xml"));
                    CAppMavenUtils.saveMavenProject((MavenProject)this.getMavenModuleProject(), (File)this.getModuleProject());
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Maven projects successfully saved"));
                    }
                    this.copyResources(artifactMavenProject, projectLocation, artifact);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error creating maven project for artifact '" + artifact.getName() + "'", e);
                }
            }
        }
    }

    protected abstract void copyResources(MavenProject var1, File var2, Artifact var3) throws IOException;

    protected MavenProject createMavenProjectForCappArtifact(Artifact artifact, List<Artifact> artifacts, File projectLocation) throws MojoExecutionException {
        MavenProject artifactMavenProject = CAppMavenUtils.createMavenProject(artifact, this.getGroupId() + "." + this.getArtifactPostFix(), this.getArtifactType());
        this.addDependencies(artifactMavenProject, artifact, projectLocation);
        this.addPlugins(artifactMavenProject, artifact);
        this.addMavenDependencies(artifactMavenProject, artifact, artifacts);
        return artifactMavenProject;
    }

    protected void addMavenDependencies(MavenProject artifactMavenProject, Artifact artifact, List<Artifact> artifacts) throws MojoExecutionException {
        List<ArtifactDependency> dependencies = artifact.getDependencies();
        for (ArtifactDependency dependency : dependencies) {
            String dGroupId = this.getGroupId();
            String dArtifactId = dependency.getName();
            String dVersion = dependency.getVersion();
            String scope = "capp";
            String type = this.getExtensionOfDependency(artifacts, dependency);
            this.addMavenDependency(artifactMavenProject, dGroupId, dArtifactId, dVersion, scope, type);
        }
    }

    protected void addMavenDependency(MavenProject artifactMavenProject, String dGroupId, String dArtifactId, String dVersion, String scope, String type) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dGroupId);
        mavenDependency.setArtifactId(dArtifactId);
        mavenDependency.setVersion(dVersion);
        mavenDependency.setScope(scope);
        if (type != null) {
            mavenDependency.setType(type);
        }
        artifactMavenProject.getDependencies().add(mavenDependency);
    }

    protected void addDependencies(MavenProject artifactMavenProject, Artifact artifact, File projectLocation) {
    }

    protected String getExtensionOfDependency(List<Artifact> artifacts, ArtifactDependency dependency) {
        String type = null;
        String artifactType = null;
        for (Artifact existingArtifact : artifacts) {
            if (!existingArtifact.getName().equals(dependency.getName()) || !existingArtifact.getVersion().equals(dependency.getVersion())) continue;
            artifactType = existingArtifact.getType();
        }
        if (artifactType != null && this.getTypeList().containsKey(artifactType)) {
            type = this.getTypeList().get(artifactType);
        }
        return type;
    }

    protected abstract void addPlugins(MavenProject var1, Artifact var2);

    private List<Artifact> retrieveArtifacts() {
        return CAppUtils.retrieveArtifacts(this.getArtifactLocation());
    }

    private MavenProject getMavenModuleProject() throws MojoExecutionException {
        if (this.mavenModuleProject == null) {
            try {
                if (!this.getModuleProject().exists()) {
                    if (this.groupId == null) {
                        this.groupId = this.project.getGroupId();
                    }
                    this.mavenModuleProject = CAppMavenUtils.createMavenProject((String)this.groupId, (String)(this.getProject().getArtifactId() + "_module"), (String)this.getProject().getVersion(), (String)"pom");
                    this.mavenModuleProject.getModel().setDistributionManagement(this.project.getDistributionManagement());
                    CAppMavenUtils.saveMavenProject((MavenProject)this.mavenModuleProject, (File)this.getModuleProject());
                }
                this.mavenModuleProject = CAppMavenUtils.getMavenProject((File)this.getModuleProject());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error retrieving module parent project: " + this.getModuleProject().toString(), e);
            }
        }
        return this.mavenModuleProject;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() throws MojoExecutionException {
        if (this.groupId == null) {
            this.groupId = this.getMavenModuleProject().getGroupId();
        }
        return this.groupId;
    }

    public void setModuleProject(File moduleProject) {
        this.moduleProject = moduleProject;
    }

    public File getModuleProject() {
        if (!this.moduleProject.getName().equalsIgnoreCase("pom.xml")) {
            this.moduleProject = new File(this.moduleProject, "pom.xml");
        }
        return this.moduleProject;
    }

    public void setArtifactLocation(File artifactLocation) {
        this.artifactLocation = artifactLocation;
    }

    public File getArtifactLocation() {
        return this.artifactLocation;
    }

    public void setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
    }

    public File getOutputLocation() {
        if (!this.outputLocation.exists()) {
            this.outputLocation.mkdirs();
        }
        return this.outputLocation;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setTypeList(String typeList) {
        this.typeList = typeList;
    }

    public Map<String, String> getTypeList() {
        HashMap<String, String> types = new HashMap<String, String>();
        if (this.typeList != null) {
            String[] typeSet;
            for (String type : typeSet = this.typeList.split(",")) {
                String[] typeData = type.split("=");
                types.put(typeData[0], typeData[1]);
            }
        }
        return types;
    }

    public void setProjectLocation(File projectLocation) {
        this.projectLocation = projectLocation;
    }

    public File getProjectLocation() {
        return this.projectLocation;
    }

    protected File processTokenReplacement(Artifact artifact) throws IOException {
        File artifactFile = artifact.getFile();
        return this.processTokenReplacement(artifactFile);
    }

    protected File processTokenReplacement(File file) throws IOException {
        if (file.exists()) {
            Properties mavenProperties = this.getProject().getModel().getProperties();
            String fileContent = FileUtils.getContentAsString((File)file);
            String newFileContent = this.replaceTokens(fileContent, mavenProperties);
            File tempFile = FileUtils.createTempFile();
            FileUtils.writeContent((File)tempFile, (String)newFileContent);
            return tempFile;
        }
        return file;
    }

    public String replaceTokens(String content, Properties mavenProperties) {
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group(0).replaceAll("^\\$\\{", "");
            String value = (String)mavenProperties.get(match = match.replaceAll("\\}$", ""));
            if (value == null || value.trim().equals("")) continue;
            matcher.appendReplacement(sb, value);
            this.getLog().info((CharSequence)("Replacing the token: " + match + " with value: " + value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

