/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.LibraryArtifact;
import org.wso2.maven.capp.model.ProjectMapping;
import org.wso2.maven.core.model.AbstractXMLDoc;

public class BundlesDataInfo
extends AbstractXMLDoc {
    private static final String EXPORT_PACKAGES_TAG = "export-packages";
    private static final String EXPORT_PACKAGE_TAG = "export-package";
    private List<ProjectMapping> projects;
    private List<LibraryArtifact> libraries;
    private File base;
    private String fragmentHost = null;

    public String getFragmentHost() {
        return this.fragmentHost;
    }

    public void setFragmentHost(String fragmentHost) {
        this.fragmentHost = fragmentHost;
    }

    protected String getDefaultName() {
        return null;
    }

    public void loadFromFile(File file) throws FactoryConfigurationError, Exception {
        this.setBase(file.getParentFile());
        this.deserialize(new FileInputStream(file));
    }

    public void deserialize(InputStream stream) throws FactoryConfigurationError, Exception {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement documentElement = builder.getDocumentElement();
        this.deserialize(documentElement);
    }

    protected void deserialize(OMElement documentElement) throws Exception {
        try {
            String fragmentHostAttribute = this.getAttribute(documentElement, "fragment-host");
            this.setFragmentHost(fragmentHostAttribute);
            List childElements = this.getChildElements(documentElement, "jar");
            for (OMElement element : childElements) {
                String jarName = this.getAttribute(element, "name");
                this.addJarToList(jarName, element);
            }
            childElements = this.getChildElements(documentElement, "project");
            for (OMElement element : childElements) {
                String projectName = this.getAttribute(element, "name");
                this.addProjectToList(projectName, element);
            }
        }
        catch (IOException e) {
            throw new Exception("Error occured while trying to process libraries in the bundle data info file.", e);
        }
    }

    public void addJarToList(String jarName, OMElement jarElement) {
        String[] jarPath = jarName.split("/");
        File fileLocation = this.getBase();
        for (String pathSegment : jarPath) {
            fileLocation = new File(fileLocation, pathSegment);
        }
        LibraryArtifact libraryArtifact = new LibraryArtifact("dummy.groupid", jarPath[jarPath.length - 1], "1.0.0", fileLocation);
        if (jarElement != null) {
            List exportPackageElements = this.getChildElements(jarElement, EXPORT_PACKAGE_TAG);
            for (OMElement packageElement : exportPackageElements) {
                libraryArtifact.getPackages().add(packageElement.getText());
            }
        }
        if (libraryArtifact.getPackages().size() == 0) {
            // empty if block
        }
        this.getLibraries().add(libraryArtifact);
    }

    public void addProjectToList(String projectName, OMElement projectElement) throws MojoExecutionException, IOException {
        ProjectMapping projectMapping = this.getProjectMapping(projectName);
        if (projectMapping != null) {
            LibraryArtifact libraryArtifact = new LibraryArtifact(projectMapping.getGroupId(), projectMapping.getArtifactId(), projectMapping.getVersion());
            if (projectElement != null) {
                List exportPackageElements = this.getChildElements(projectElement, EXPORT_PACKAGE_TAG);
                for (OMElement packageElement : exportPackageElements) {
                    libraryArtifact.getPackages().add(packageElement.getText());
                }
            }
            if (libraryArtifact.getPackages().size() == 0) {
                File artifactFile = libraryArtifact.getArtifactFile();
                this.addPackagesToLibraryArtifact(libraryArtifact, artifactFile);
            }
            this.getLibraries().add(libraryArtifact);
        }
    }

    private void addPackagesToLibraryArtifact(LibraryArtifact libraryArtifact, File artifactFile) throws IOException {
        if (artifactFile != null) {
            Map processJarList = FileUtils.processJarList((File[])new File[]{artifactFile});
            for (ArrayList packageList : processJarList.values()) {
                libraryArtifact.getPackages().addAll(packageList);
            }
        }
    }

    private ProjectMapping getProjectMapping(String projectName) {
        for (ProjectMapping mapping : this.getProjects()) {
            if (!mapping.getProjectName().equals(projectName)) continue;
            return mapping;
        }
        return null;
    }

    protected String serialize() {
        return null;
    }

    public List<LibraryArtifact> getLibraries() {
        if (this.libraries == null) {
            this.libraries = new ArrayList<LibraryArtifact>();
        }
        return this.libraries;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public File getBase() {
        return this.base;
    }

    public List<String> getAllPackages() {
        ArrayList<String> allPackages = new ArrayList<String>();
        List<LibraryArtifact> libraries = this.getLibraries();
        for (LibraryArtifact libraryArtifact : libraries) {
            List<String> packages = libraryArtifact.getPackages();
            for (String packageString : packages) {
                if (allPackages.contains(packageString)) continue;
                allPackages.add(packageString);
            }
        }
        return allPackages;
    }

    public String getAllPackagesString() {
        StringBuffer sb = new StringBuffer();
        List<String> allPackages = this.getAllPackages();
        for (String packageString : allPackages) {
            if ("".equals(sb.toString())) {
                sb.append(packageString);
                continue;
            }
            sb.append(",").append(packageString);
        }
        return sb.toString();
    }

    public void setProjects(List<ProjectMapping> projects) {
        this.projects = projects;
    }

    public List<ProjectMapping> getProjects() {
        return this.projects;
    }
}

