/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.unittest;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.Base64;

class SynapseTestCaseFileReader {
    private static Log log;

    private SynapseTestCaseFileReader() {
    }

    static String processArtifactData(String synapseTestCaseFilePath) {
        try {
            QName qualifiedTestCases;
            OMElement testCasesNode;
            Iterator testCaseIterator;
            String synapseTestCaseFileAsString = FileUtils.readFileToString((File)new File(synapseTestCaseFilePath));
            OMElement importedXMLFile = AXIOMUtil.stringToOM((String)synapseTestCaseFileAsString);
            if (SynapseTestCaseFileReader.getLog().isDebugEnabled()) {
                SynapseTestCaseFileReader.getLog().debug((CharSequence)"Checking SynapseTestCase file contains artifact data");
            }
            if (!(testCaseIterator = (testCasesNode = importedXMLFile.getFirstChildWithName(qualifiedTestCases = new QName("", "test-cases", ""))).getChildElements()).hasNext()) {
                return "no-test-cases";
            }
            QName qualifiedArtifacts = new QName("", "artifacts", "");
            OMElement artifactsNode = importedXMLFile.getFirstChildWithName(qualifiedArtifacts);
            SynapseTestCaseFileReader.processTestArtifactData(artifactsNode);
            SynapseTestCaseFileReader.processSupportiveArtifactData(artifactsNode);
            SynapseTestCaseFileReader.processRegistryResourcesData(artifactsNode);
            SynapseTestCaseFileReader.processConnectorResourcesData(artifactsNode);
            QName qualifiedMockServices = new QName("", "mock-services", "");
            OMElement mockServicesNode = importedXMLFile.getFirstChildWithName(qualifiedMockServices);
            SynapseTestCaseFileReader.processMockServicesData(mockServicesNode);
            return importedXMLFile.toString();
        }
        catch (IOException | XMLStreamException e) {
            SynapseTestCaseFileReader.getLog().error((CharSequence)"Artifact data reading failed ", (Throwable)e);
            return null;
        }
    }

    private static void processTestArtifactData(OMElement artifactsNode) throws IOException, XMLStreamException {
        String testArtifactFileAsString;
        QName qualifiedArtifact;
        QName qualifiedTestArtifact = new QName("", "test-artifact", "");
        OMElement testArtifactNode = artifactsNode.getFirstChildWithName(qualifiedTestArtifact);
        OMElement testArtifactFileNode = testArtifactNode.getFirstChildWithName(qualifiedArtifact = new QName("", "artifact", ""));
        if (!testArtifactFileNode.getText().isEmpty()) {
            String testArtifactFilePath = testArtifactFileNode.getText();
            File testArtifactFile = new File(".." + File.separator + testArtifactFilePath);
            testArtifactFileAsString = !testArtifactFile.exists() ? (!(testArtifactFile = new File(".." + File.separator + ".." + File.separator + testArtifactFilePath)).exists() ? FileUtils.readFileToString((File)new File(testArtifactFilePath)) : FileUtils.readFileToString((File)testArtifactFile)) : FileUtils.readFileToString((File)testArtifactFile);
        } else {
            throw new IOException("Test artifact does not contain configuration file path");
        }
        if (testArtifactFileAsString == null) {
            throw new IOException("Test artifact does not contain any configuration data");
        }
        OMElement testArtifactDataNode = AXIOMUtil.stringToOM((String)testArtifactFileAsString);
        testArtifactFileNode.removeChildren();
        testArtifactFileNode.addChild((OMNode)testArtifactDataNode);
    }

    private static void processSupportiveArtifactData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedSupportiveArtifact = new QName("", "supportive-artifacts", "");
        OMElement supportiveArtifactNode = artifactsNode.getFirstChildWithName(qualifiedSupportiveArtifact);
        Iterator artifactIterator = Collections.emptyIterator();
        if (supportiveArtifactNode != null) {
            artifactIterator = supportiveArtifactNode.getChildElements();
        }
        while (artifactIterator.hasNext()) {
            String supportiveArtifactFileAsString;
            OMElement artifact = (OMElement)artifactIterator.next();
            if (!artifact.getText().isEmpty()) {
                String artifactFilePath = artifact.getText();
                File supportiveArtifactFile = new File(".." + File.separator + artifactFilePath);
                supportiveArtifactFileAsString = !supportiveArtifactFile.exists() ? (!(supportiveArtifactFile = new File(".." + File.separator + ".." + File.separator + artifactFilePath)).exists() ? FileUtils.readFileToString((File)new File(artifactFilePath)) : FileUtils.readFileToString((File)supportiveArtifactFile)) : FileUtils.readFileToString((File)supportiveArtifactFile);
            } else {
                throw new IOException("Supportive artifact does not contain configuration file path");
            }
            if (supportiveArtifactFileAsString != null) {
                OMElement supportiveArtifactDataNode = AXIOMUtil.stringToOM((String)supportiveArtifactFileAsString);
                artifact.removeChildren();
                artifact.addChild((OMNode)supportiveArtifactDataNode);
                continue;
            }
            throw new IOException("Supportive artifact does not contain any configuration data");
        }
    }

    private static void processRegistryResourcesData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedRegistryResources = new QName("", "registry-resources", "");
        OMElement registryResourcesNode = artifactsNode.getFirstChildWithName(qualifiedRegistryResources);
        Iterator resourceIterator = Collections.emptyIterator();
        if (registryResourcesNode != null) {
            resourceIterator = registryResourcesNode.getChildElements();
        }
        while (resourceIterator.hasNext()) {
            String registryResourceFileAsString;
            QName qualifiedRegistryResourcesFile;
            OMElement resource = (OMElement)resourceIterator.next();
            OMElement registryResourcesFileNode = resource.getFirstChildWithName(qualifiedRegistryResourcesFile = new QName("", "artifact", ""));
            if (!registryResourcesFileNode.getText().isEmpty()) {
                String registryFilePath = registryResourcesFileNode.getText();
                File registryResourceFile = new File(".." + File.separator + registryFilePath);
                registryResourceFileAsString = !registryResourceFile.exists() ? (!(registryResourceFile = new File(".." + File.separator + ".." + File.separator + registryFilePath)).exists() ? FileUtils.readFileToString((File)new File(registryFilePath)) : FileUtils.readFileToString((File)registryResourceFile)) : FileUtils.readFileToString((File)registryResourceFile);
            } else {
                throw new IOException("Registry resource does not contain configuration file path");
            }
            if (registryResourceFileAsString != null) {
                registryResourcesFileNode.setText(registryResourceFileAsString);
                continue;
            }
            throw new IOException("Registry resource does not contain any configuration data");
        }
    }

    private static void processConnectorResourcesData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedConnectorResources = new QName("", "connector-resources", "");
        OMElement connectorResourcesNode = artifactsNode.getFirstChildWithName(qualifiedConnectorResources);
        Iterator connectorIterator = Collections.emptyIterator();
        if (connectorResourcesNode != null) {
            connectorIterator = connectorResourcesNode.getChildElements();
        }
        while (connectorIterator.hasNext()) {
            String registryFilePath;
            OMElement resource = (OMElement)connectorIterator.next();
            if (!resource.getText().isEmpty()) {
                File connectorResourceFile = new File(".." + File.separator + resource.getText());
                registryFilePath = !connectorResourceFile.exists() ? (!(connectorResourceFile = new File(".." + File.separator + ".." + File.separator + resource.getText())).exists() ? resource.getText() : ".." + File.separator + resource.getText()) : ".." + File.separator + resource.getText();
            } else {
                throw new IOException("Connector resource does not contain configuration file path");
            }
            byte[] connectorInBytes = Files.readAllBytes(Paths.get(registryFilePath, new String[0]));
            byte[] encoded = Base64.encodeBase64((byte[])connectorInBytes);
            String encodedConnectorFile = new String(encoded);
            if (encodedConnectorFile != null) {
                resource.setText(encodedConnectorFile);
                continue;
            }
            throw new IOException("Connector resource does not contain any configuration data");
        }
    }

    private static void processMockServicesData(OMElement mockServicesNode) throws IOException, XMLStreamException {
        Iterator mockServiceIterator = Collections.emptyIterator();
        if (mockServicesNode != null) {
            mockServiceIterator = mockServicesNode.getChildElements();
        }
        ArrayList<OMElement> mockServiceDataNodeList = new ArrayList<OMElement>();
        while (mockServiceIterator.hasNext()) {
            String mockServiceFileDataAsString;
            OMElement mockServiceNode = (OMElement)mockServiceIterator.next();
            if (!mockServiceNode.getText().isEmpty()) {
                String mockServiceFilePath = mockServiceNode.getText();
                File mockServiceFile = new File(".." + File.separator + mockServiceFilePath);
                mockServiceFileDataAsString = !mockServiceFile.exists() ? (!(mockServiceFile = new File(".." + File.separator + ".." + File.separator + mockServiceFilePath)).exists() ? FileUtils.readFileToString((File)new File(mockServiceFilePath)) : FileUtils.readFileToString((File)mockServiceFile)) : FileUtils.readFileToString((File)mockServiceFile);
            } else {
                throw new IOException("Mock service file does not contain configuration file path");
            }
            if (mockServiceFileDataAsString != null) {
                OMElement mockServiceDataNode = AXIOMUtil.stringToOM((String)mockServiceFileDataAsString);
                mockServiceDataNodeList.add(mockServiceDataNode);
                continue;
            }
            throw new IOException("Mock service does not contain any configuration data");
        }
        mockServicesNode.removeChildren();
        for (OMElement child : mockServiceDataNodeList) {
            mockServicesNode.addChild((OMNode)child);
        }
    }

    private static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }
}

