/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.unittest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wso2.synapse.unittest.SynapseServer;
import org.wso2.synapse.unittest.UnitTestClient;
import org.wso2.synapse.unittest.summarytable.ConsoleDataTable;

@Mojo(name="synapse-unit-test")
public class UnitTestCasesMojo
extends AbstractMojo {
    @Parameter(property="testCasesFilePath")
    private String testCasesFilePath;
    @Parameter(property="server")
    private SynapseServer server;
    @Parameter(property="mavenTestSkip")
    private String mavenTestSkip;
    private static final String LOCAL_SERVER = "local";
    private static final String REMOTE_SERVER = "remote";
    private Date timeStarted;
    private String serverHost;
    private String serverPort;
    private boolean isUnitTestAgentStartTheServer = false;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean overallTestFailure = false;

    public void execute() throws MojoExecutionException {
        if (!Boolean.parseBoolean(this.mavenTestSkip)) {
            try {
                this.timeStarted = new Date();
                this.appendTestLogs();
                this.testCaseRunner();
            }
            catch (Exception e) {
                this.stopTestingServer();
                throw new MojoExecutionException("Exception occurred while running test cases: " + e.getMessage());
            }
            finally {
                if (this.isUnitTestAgentStartTheServer) {
                    this.stopTestingServer();
                }
            }
        }
    }

    private void checkTestParameters() throws IOException {
        boolean isParameterNotFound = false;
        if (this.server.getServerType() == null) {
            isParameterNotFound = true;
            this.getLog().error((CharSequence)"Please enter -DtestServerType=<local/remote> parameter value to execute tests");
        }
        if (this.server.getServerType() != null && this.server.getServerType().equals(LOCAL_SERVER) && this.server.getServerPath() == null) {
            isParameterNotFound = true;
            this.getLog().error((CharSequence)"Please enter -DtestServerPath=<path> parameter value to execute tests");
        }
        if (this.server.getServerType() != null && this.server.getServerType().equals(REMOTE_SERVER) && this.server.getServerHost() == null) {
            isParameterNotFound = true;
            this.getLog().error((CharSequence)"Please enter -DtestServerHost=<host-ip> parameter value to execute tests");
        }
        if (isParameterNotFound) {
            throw new IOException("Test parameters are not found");
        }
    }

    private void testCaseRunner() throws IOException {
        ArrayList<String> synapseTestCasePaths = this.getTestCasesFileNamesWithPaths(this.testCasesFilePath);
        this.getLog().info((CharSequence)("Detect " + synapseTestCasePaths.size() + " Synapse test case files to execute"));
        this.getLog().info((CharSequence)"");
        if (synapseTestCasePaths.size() > 0) {
            this.checkTestParameters();
            if (this.server.getServerPath() != null && this.server.getServerPath().equalsIgnoreCase("/")) {
                this.runLocalServer(((String)synapseTestCasePaths.get(0)).split("src")[0]);
            }
            this.startTestingServer();
        }
        HashMap<String, String> testSummaryData = new HashMap<String, String>();
        for (String synapseTestCaseFile : synapseTestCasePaths) {
            String responseFromUnitTestFramework = UnitTestClient.executeTests(synapseTestCaseFile, this.serverHost, this.serverPort);
            if (responseFromUnitTestFramework == null || responseFromUnitTestFramework.equals("no-test-cases")) {
                this.getLog().info((CharSequence)("No test cases found in " + synapseTestCaseFile + " unit test suite"));
                this.getLog().info((CharSequence)"");
                continue;
            }
            testSummaryData.put(synapseTestCaseFile, responseFromUnitTestFramework);
            this.getLog().info((CharSequence)("SynapseTestCaseFile " + synapseTestCaseFile + " tested successfully"));
        }
        this.getLog().info((CharSequence)"");
        if (!testSummaryData.isEmpty()) {
            Date timeStop = new Date();
            long duration = timeStop.getTime() - this.timeStarted.getTime();
            this.generateUnitTestReport(testSummaryData, duration);
            this.writeUnitTestReportToFile(testSummaryData, duration);
        }
        if (this.overallTestFailure) {
            throw new IOException("Overall unit test failed");
        }
    }

    private ArrayList<String> getTestCasesFileNamesWithPaths(String testFileFolder) {
        ArrayList<String> fileNamesWithPaths = new ArrayList<String>();
        if (testFileFolder.endsWith(".xml")) {
            fileNamesWithPaths.add(testFileFolder);
        } else if (testFileFolder.endsWith("${testFile}")) {
            File[] listOfFiles;
            String testFolderPath = testFileFolder.split("\\$")[0];
            File folder = new File(testFolderPath);
            for (File file : listOfFiles = folder.listFiles()) {
                String filename = file.getName();
                if (!filename.endsWith(".xml")) continue;
                fileNamesWithPaths.add(testFolderPath + filename);
            }
        }
        return fileNamesWithPaths;
    }

    private void appendTestLogs() {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"U N I T - T E S T S");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private void generateUnitTestReport(Map<String, String> summaryData, long duration) throws IOException {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"U N I T - T E S T  R E P O R T");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)("Start Time: " + this.dateFormat.format(this.timeStarted)));
        this.getLog().info((CharSequence)("Test Run Duration: " + TimeUnit.MILLISECONDS.toSeconds(duration) + " seconds"));
        this.getLog().info((CharSequence)"Test Summary: ");
        this.getLog().info((CharSequence)"");
        ArrayList<Boolean> testFailedSuccessList = new ArrayList<Boolean>();
        for (Map.Entry<String, String> summary : summaryData.entrySet()) {
            String fileSeperatePattern = Pattern.quote(System.getProperty("file.separator"));
            String[] filePathParams = summary.getKey().split(fileSeperatePattern);
            String testName = filePathParams[filePathParams.length - 1];
            this.getLog().info((CharSequence)("Test Suite Name: " + testName));
            this.getLog().info((CharSequence)"==============================================");
            JsonObject summaryJson = new JsonParser().parse(summary.getValue()).getAsJsonObject();
            Map.Entry<String, String> testFailPassCounts = this.getPassFailureTestCaseCounts(summaryJson);
            String passTestCaseCount = testFailPassCounts.getKey();
            String failureTestCaseCount = testFailPassCounts.getValue();
            this.getLog().info((CharSequence)("Pass Test Cases: " + passTestCaseCount));
            this.getLog().info((CharSequence)("Failure Test Cases: " + failureTestCaseCount));
            this.getLog().info((CharSequence)"");
            String[] summaryHeadersList = new String[]{"  TEST CASE  ", "  DEPLOYMENT  ", "  MEDIATION  ", "  ASSERTION  "};
            List<List<String>> testSummaryDataList = this.getTestCaseWiseSummary(summaryJson);
            this.printDetailedTable(testSummaryDataList, 4, summaryHeadersList);
            boolean isOverallTestFailed = this.generateTestFailureTable(summaryJson);
            testFailedSuccessList.add(isOverallTestFailed);
        }
        if (testFailedSuccessList.contains(true)) {
            this.overallTestFailure = true;
        }
    }

    private void writeUnitTestReportToFile(Map<String, String> summaryData, long duration) {
        File reportFile;
        File targetFolder = new File(Paths.get("target", new String[0]).toUri());
        if (!targetFolder.exists()) {
            targetFolder.mkdir();
        }
        if ((reportFile = new File(Paths.get("target", "unit-test-report.json").toUri())).exists()) {
            reportFile.delete();
        }
        JsonObject finalSummary = new JsonObject();
        for (Map.Entry<String, String> summary : summaryData.entrySet()) {
            String testFileName = summary.getKey();
            JsonObject summaryJson = new JsonParser().parse(summary.getValue()).getAsJsonObject();
            finalSummary.add(testFileName, (JsonElement)summaryJson);
        }
        finalSummary.addProperty("Time elapsed (ms)", (Number)duration);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = gson.toJson((JsonElement)finalSummary);
        try (FileWriter myWriter = new FileWriter(reportFile);){
            myWriter.write(prettyJson);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error in writing the unit test report to the file", (Throwable)e);
        }
    }

    private void startTestingServer() throws IOException {
        this.serverPort = this.server.getServerPort();
        if (this.serverPort == null || this.serverPort.isEmpty()) {
            this.server.setServerPort("9008");
            this.serverPort = this.server.getServerPort();
        }
        if (this.server.getServerType().equals(LOCAL_SERVER)) {
            this.serverHost = "127.0.0.1";
            String synapseServerPath = this.server.getServerPath();
            String[] cmd = new String[]{synapseServerPath, "-DsynapseTest", "-DsynapseTestPort=" + this.serverPort};
            Process processor = Runtime.getRuntime().exec(cmd);
            this.getLog().info((CharSequence)("Starting unit testing agent of path - " + synapseServerPath));
            this.getLog().info((CharSequence)"Waiting for testing agent initialization");
            this.getLog().info((CharSequence)"");
            if (!this.checkPortAvailability(Integer.parseInt(this.serverPort))) {
                this.getLog().error((CharSequence)("Another process has already occupied the port - " + this.serverPort));
                throw new IOException("Another process has already occupied the port - " + this.serverPort);
            }
            BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(processor.getInputStream()));
            String line = null;
            while ((line = inputBuffer.readLine()) != null) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)line);
                }
                if (!line.contains("Synapse unit testing agent has been established")) continue;
                this.isUnitTestAgentStartTheServer = true;
                break;
            }
            boolean isServerNotStarted = true;
            long timeoutExpiredMs = System.currentTimeMillis() + 120000L;
            while (isServerNotStarted) {
                long waitMillis = timeoutExpiredMs - System.currentTimeMillis();
                isServerNotStarted = this.checkPortAvailability(Integer.parseInt(this.serverPort));
                if (waitMillis > 0L) continue;
                processor.destroyForcibly();
                throw new IOException("Connection refused for service in port - " + this.serverPort);
            }
            inputBuffer.close();
        } else if (this.server.getServerType().equals(REMOTE_SERVER)) {
            this.serverHost = this.server.getServerHost();
        } else {
            this.getLog().info((CharSequence)("Given server type " + this.server.getServerType() + "is not an expected type"));
        }
    }

    private void stopTestingServer() {
        if (this.server.getServerType() != null && this.server.getServerType().equals(LOCAL_SERVER)) {
            try {
                BufferedReader bufferReader;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Stopping unit testing agent runs on port " + this.serverPort));
                }
                if (System.getProperty("os.name").toLowerCase().contains("win")) {
                    Runtime runTime = Runtime.getRuntime();
                    Process proc = runTime.exec("cmd /c netstat -ano | findstr " + this.serverPort);
                    bufferReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String stream = bufferReader.readLine();
                    if (stream != null) {
                        int index = stream.lastIndexOf(32);
                        String pid = stream.substring(index);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Unit testing agent runs with PID of " + pid));
                        }
                        runTime.exec("cmd /c Taskkill /PID" + pid + " /T /F");
                    }
                } else {
                    Process pr = Runtime.getRuntime().exec("lsof -t -i:" + this.serverPort);
                    bufferReader = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String pid = bufferReader.readLine();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Unit testing agent runs with PID of " + pid));
                    }
                    Runtime.getRuntime().exec("kill -9 " + pid);
                }
                bufferReader.close();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Unit testing agent stopped");
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error in closing the server", (Throwable)e);
            }
        }
    }

    private boolean checkPortAvailability(int port) {
        boolean isPortAvailable;
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(this.serverHost, port));
            isPortAvailable = false;
        }
        catch (IOException e) {
            isPortAvailable = true;
        }
        return isPortAvailable;
    }

    private Map.Entry<String, String> getPassFailureTestCaseCounts(JsonObject jsonSummary) {
        String failureTestCount;
        String passTestCount;
        if (jsonSummary.get("mediationStatus") != null && jsonSummary.get("mediationStatus").getAsString().equals("PASSED") && jsonSummary.get("testCases") != null && jsonSummary.get("testCases").getAsJsonArray().size() > 0) {
            JsonArray testCases = jsonSummary.get("testCases").getAsJsonArray();
            int passCount = 0;
            int failureCount = 0;
            for (int x = 0; x < testCases.size(); ++x) {
                JsonObject testJsonObject = testCases.get(x).getAsJsonObject();
                if (testJsonObject.get("assertionStatus").getAsString().equals("PASSED")) {
                    ++passCount;
                    continue;
                }
                ++failureCount;
            }
            passTestCount = String.valueOf(passCount);
            failureTestCount = String.valueOf(failureCount);
        } else {
            passTestCount = "N/A";
            failureTestCount = "N/A";
        }
        return new AbstractMap.SimpleEntry<String, String>(passTestCount, failureTestCount);
    }

    private List<List<String>> getTestCaseWiseSummary(JsonObject jsonSummary) {
        ArrayList<List<String>> allTestSummary = new ArrayList<List<String>>();
        if (jsonSummary.get("testCases") != null && jsonSummary.get("testCases").getAsJsonArray().size() > 0) {
            ArrayList<String> testSummary;
            JsonArray testCases = jsonSummary.get("testCases").getAsJsonArray();
            for (int x = 0; x < testCases.size(); ++x) {
                testSummary = new ArrayList<String>();
                JsonObject testJsonObject = testCases.get(x).getAsJsonObject();
                testSummary.add("Test Case - " + testJsonObject.get("testCaseName").getAsString());
                testSummary.add("   " + jsonSummary.get("deploymentStatus").getAsString());
                testSummary.add("   " + testJsonObject.get("mediationStatus").getAsString());
                testSummary.add("   " + testJsonObject.get("assertionStatus").getAsString());
                allTestSummary.add(testSummary);
            }
            if (!jsonSummary.get("mediationStatus").getAsString().equals("PASSED")) {
                testSummary = new ArrayList();
                testSummary.add("Test Case - " + jsonSummary.get("currentTestCase").getAsString());
                testSummary.add("   " + jsonSummary.get("deploymentStatus").getAsString());
                testSummary.add("   " + jsonSummary.get("mediationStatus").getAsString());
                testSummary.add("   SKIPPED");
                allTestSummary.add(testSummary);
            }
        } else {
            ArrayList<String> testSummary = new ArrayList<String>();
            testSummary.add("Test Case - Suite");
            testSummary.add("   " + jsonSummary.get("deploymentStatus").getAsString());
            testSummary.add("   " + jsonSummary.get("mediationStatus").getAsString());
            testSummary.add("   SKIPPED");
            allTestSummary.add(testSummary);
        }
        return allTestSummary;
    }

    private boolean generateTestFailureTable(JsonObject jsonSummary) {
        boolean isFailureOccurred = false;
        ArrayList<List<String>> errorRowsList = new ArrayList<List<String>>();
        ArrayList<List<String>> assertErrors = new ArrayList<List<String>>();
        if (jsonSummary.get("testCases") != null && jsonSummary.get("testCases").getAsJsonArray().size() > 0) {
            JsonArray testCases = jsonSummary.get("testCases").getAsJsonArray();
            for (int x = 0; x < testCases.size(); ++x) {
                ArrayList<String> failureSummary = new ArrayList<String>();
                JsonObject testJsonObject = testCases.get(x).getAsJsonObject();
                if (!testJsonObject.get("mediationStatus").getAsString().equals("PASSED")) {
                    isFailureOccurred = true;
                    failureSummary.add("Test Case - " + testJsonObject.get("testCaseName").getAsString());
                    failureSummary.add("   MEDIATION");
                    failureSummary.add(testJsonObject.get("exception").getAsString());
                    errorRowsList.add(failureSummary);
                    continue;
                }
                if (testJsonObject.get("assertionStatus").getAsString().equals("PASSED")) continue;
                isFailureOccurred = true;
                JsonArray failureAssertions = testJsonObject.getAsJsonArray("failureAssertions");
                if (failureAssertions == null) {
                    failureSummary.add("Test Case - " + testJsonObject.get("testCaseName").getAsString());
                    failureSummary.add("   ASSERTION");
                    failureSummary.add(testJsonObject.get("exception").getAsString());
                    errorRowsList.add(failureSummary);
                    continue;
                }
                for (int item = 0; item < failureAssertions.size(); ++item) {
                    JsonObject assertFailures = failureAssertions.get(item).getAsJsonObject();
                    ArrayList<String> assertionSummary = new ArrayList<String>();
                    String testCaseName = "Test Case - " + testJsonObject.get("testCaseName").getAsString();
                    assertionSummary.add(testCaseName);
                    assertionSummary.add("   ASSERTION");
                    assertionSummary.add(assertFailures.get("message").getAsString());
                    errorRowsList.add(assertionSummary);
                    ArrayList<String> failureAssertionInDetail = new ArrayList<String>();
                    failureAssertionInDetail.add(testCaseName);
                    failureAssertionInDetail.add(assertFailures.get("assertionType").getAsString() + " - " + assertFailures.get("assertionExpression").getAsString());
                    String assertionErrorMessage = "Actual Response: \n" + this.splitLongStrings(assertFailures.get("actual").getAsString()) + "\n";
                    if (!assertFailures.get("expected").isJsonNull()) {
                        assertionErrorMessage = assertionErrorMessage + "Expected Response: \n" + this.splitLongStrings(assertFailures.get("expected").getAsString());
                    }
                    if (!assertFailures.get("assertionDescription").isJsonNull()) {
                        assertionErrorMessage = assertionErrorMessage + "\nDescription: \n" + this.splitLongStrings(assertFailures.get("assertionDescription").getAsString());
                    }
                    failureAssertionInDetail.add(assertionErrorMessage);
                    assertErrors.add(failureAssertionInDetail);
                }
            }
            if (!jsonSummary.get("mediationStatus").getAsString().equals("PASSED")) {
                isFailureOccurred = true;
                ArrayList<String> failureSummary = new ArrayList<String>();
                failureSummary.add("Test Case - " + jsonSummary.get("currentTestCase").getAsString());
                failureSummary.add("   MEDIATION");
                failureSummary.add(jsonSummary.get("mediationException").getAsString());
                errorRowsList.add(failureSummary);
            }
        } else {
            ArrayList<String> testSummary = new ArrayList<String>();
            if (!jsonSummary.get("deploymentStatus").getAsString().equals("PASSED")) {
                isFailureOccurred = true;
                testSummary.add("Test Case - Suite");
                testSummary.add("   DEPLOYMENT");
                if (jsonSummary.get("deploymentException") != null) {
                    testSummary.add(jsonSummary.get("deploymentException").getAsString());
                } else {
                    testSummary.add(jsonSummary.get("deploymentDescription").getAsString());
                }
                errorRowsList.add(testSummary);
            } else if (!jsonSummary.get("mediationStatus").getAsString().equals("PASSED")) {
                isFailureOccurred = true;
                testSummary.add("Test Case - " + jsonSummary.get("currentTestCase").getAsString());
                testSummary.add("   MEDIATION");
                testSummary.add(jsonSummary.get("mediationException").getAsString());
                errorRowsList.add(testSummary);
            }
        }
        if (isFailureOccurred) {
            this.getLog().info((CharSequence)"Failed Test Case(s): ");
            String[] errorHeadersList = new String[]{"  TEST CASE  ", "  FAILURE STATE  ", "      EXCEPTION / ERROR MESSAGE     "};
            this.printDetailedTable(errorRowsList, 3, errorHeadersList);
            if (!assertErrors.isEmpty()) {
                this.getLog().info((CharSequence)"Failed Assertion(s): ");
                String[] assertErrorHeadersList = new String[]{"  TEST CASE  ", "  ASSERT EXPRESSION  ", "      FAILURE     "};
                this.printDetailedTable(assertErrors, 3, assertErrorHeadersList);
            }
        }
        return isFailureOccurred;
    }

    private String splitLongStrings(String text) {
        if (text.length() < 100) {
            return text + "\n";
        }
        int maxStringLength = 100;
        StringBuilder multilineConvertedString = new StringBuilder();
        for (int start = 0; start < text.length(); start += maxStringLength) {
            String currentLine = text.substring(start, Math.min(text.length(), start + maxStringLength));
            if (currentLine.contains("\n")) {
                multilineConvertedString.append(currentLine);
                continue;
            }
            multilineConvertedString.append(currentLine).append("\n");
        }
        return multilineConvertedString.toString();
    }

    private void printDetailedTable(List<List<String>> detailList, int columnSize, String[] errorHeadersList) {
        String[] errorTableLines;
        String[][] errorRowsArray = new String[detailList.size()][columnSize];
        for (int x = 0; x < detailList.size(); ++x) {
            List<String> innerList = detailList.get(x);
            String[] innerArray = new String[columnSize];
            innerArray = innerList.toArray(innerArray);
            errorRowsArray[x] = innerArray;
        }
        String errorTableString = ConsoleDataTable.of(errorHeadersList, errorRowsArray);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            String windowsDefaultLineSeparator = System.getProperty("\\r?\\n");
            if (windowsDefaultLineSeparator == null) {
                windowsDefaultLineSeparator = "\n";
            }
            errorTableLines = errorTableString.split(windowsDefaultLineSeparator);
        } else {
            errorTableLines = errorTableString.split(System.getProperty("line.separator"));
        }
        for (String line : errorTableLines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }

    private void runLocalServer(String projectRootPath) {
        try {
            Path fullFilePath;
            String userHome = System.getProperty("os.name").toLowerCase().contains("win") ? System.getenv("USERPROFILE") : System.getenv("HOME");
            Path miDownloadPath = Paths.get(userHome, ".m2", "repository", "org", "wso2", "ei", "wso2mi", this.server.getServerVersion());
            URL downloadUrl = this.server.getServerDownloadLink() == null ? new URL("https://github.com/wso2/micro-integrator/releases/download/v" + this.server.getServerVersion() + "/wso2mi-" + this.server.getServerVersion() + ".zip") : new URL(this.server.getServerDownloadLink());
            if (Files.notExists(miDownloadPath, new LinkOption[0])) {
                Files.createDirectories(miDownloadPath, new FileAttribute[0]);
            }
            if (Files.notExists(fullFilePath = Paths.get(miDownloadPath.toString(), "wso2mi-" + this.server.getServerVersion() + ".zip"), new LinkOption[0])) {
                this.getLog().info((CharSequence)("Downloading wso2mi-" + this.server.getServerVersion() + " server to \"" + miDownloadPath + "\" for testing unit test ..."));
                this.downloadMiPack(downloadUrl.toString(), fullFilePath.toString());
            }
            this.unzipMiPack(fullFilePath.toString(), miDownloadPath.toString());
            FileUtils.copyDirectory((File)new File(Paths.get(projectRootPath, "deployment", "libs").toString()), (File)new File(Paths.get(miDownloadPath.toString(), "wso2mi-" + this.server.getServerVersion(), "lib").toString()));
            String scriptPath = System.getProperty("os.name").toLowerCase().contains("win") ? Paths.get(miDownloadPath.toString(), "wso2mi-" + this.server.getServerVersion(), "bin", "micro-integrator.bat").toString() : Paths.get(miDownloadPath.toString(), "wso2mi-" + this.server.getServerVersion(), "bin", "micro-integrator.sh").toString();
            File file = new File(scriptPath);
            file.setExecutable(true);
            this.server.setServerPath(scriptPath);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Local server startup failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            this.getLog().error((CharSequence)("Entry is outside of the target dir: " + zipEntry.getName()));
        }
        return destFile;
    }

    private void downloadMiPack(String downloadFileUrl, String outputFile) {
        block31: {
            try {
                URL url = new URL(downloadFileUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    try (InputStream inputStream = connection.getInputStream();
                         FileOutputStream outputStream = new FileOutputStream(outputFile);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("An error occurred when downloading MI pack: " + e.getMessage()));
                    }
                    this.getLog().info((CharSequence)("MI pack downloaded successfully to " + outputFile));
                    break block31;
                }
                this.getLog().error((CharSequence)("Failed to download MI pack. Error code: " + responseCode));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("An error occurred when downloading MI pack: " + e.getMessage()));
            }
        }
    }

    private void unzipMiPack(String fullFilePath, String miDownloadPath) {
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(Paths.get(fullFilePath, new String[0]), new OpenOption[0]));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File newFile = this.newFile(new File(miDownloadPath), zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        this.getLog().error((CharSequence)("Failed to create directory for unzipping pack: " + newFile));
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        this.getLog().error((CharSequence)("Failed to create directory for unzipping pack: " + parent));
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zipInputStream.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"An error occurred when unzipping MI pack: ", (Throwable)e);
        }
    }
}

