/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.unittest;

import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.wso2.synapse.unittest.SynapseTestCaseFileReader;
import org.wso2.synapse.unittest.TCPClient;

class UnitTestClient {
    private static Log log;

    private UnitTestClient() {
    }

    static String executeTests(String synapseTestCaseFilePath, String synapseHost, String synapsePort) throws IOException {
        String responseFromServer = null;
        String deployableMessage = null;
        try {
            deployableMessage = SynapseTestCaseFileReader.processArtifactData(synapseTestCaseFilePath);
            if (deployableMessage != null && deployableMessage.equals("no-test-cases")) {
                return deployableMessage;
            }
        }
        catch (Exception e) {
            UnitTestClient.getLog().error((CharSequence)"Error while executing client", (Throwable)e);
        }
        if (deployableMessage != null) {
            TCPClient tcpClient = new TCPClient(synapseHost, synapsePort);
            if (!tcpClient.isSocketInitialized()) {
                throw new IOException("Error while sending test data to the unit testing server. Hence aborting the testing operation");
            }
            tcpClient.writeData(deployableMessage);
            responseFromServer = tcpClient.readData();
            tcpClient.closeSocket();
        } else {
            UnitTestClient.getLog().error((CharSequence)"Error while creating a deployable message with test suites");
        }
        return responseFromServer;
    }

    private static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }
}

