/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.unittest;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.Base64;

class SynapseTestCaseFileReader {
    private static Log log;

    private SynapseTestCaseFileReader() {
    }

    static String processArtifactData(String synapseTestCaseFilePath) {
        try {
            QName qualifiedTestCases;
            OMElement testCasesNode;
            Iterator testCaseIterator;
            String synapseTestCaseFileAsString = FileUtils.readFileToString((File)new File(synapseTestCaseFilePath));
            OMElement importedXMLFile = AXIOMUtil.stringToOM((String)synapseTestCaseFileAsString);
            if (SynapseTestCaseFileReader.getLog().isDebugEnabled()) {
                SynapseTestCaseFileReader.getLog().debug((CharSequence)"Checking SynapseTestCase file contains artifact data");
            }
            if (!(testCaseIterator = (testCasesNode = importedXMLFile.getFirstChildWithName(qualifiedTestCases = new QName("", "test-cases", ""))).getChildElements()).hasNext()) {
                return "no-test-cases";
            }
            QName qualifiedArtifacts = new QName("", "artifacts", "");
            OMElement artifactsNode = importedXMLFile.getFirstChildWithName(qualifiedArtifacts);
            SynapseTestCaseFileReader.processTestArtifactData(artifactsNode);
            SynapseTestCaseFileReader.processSupportiveArtifactData(artifactsNode);
            SynapseTestCaseFileReader.processRegistryResourcesData(artifactsNode);
            SynapseTestCaseFileReader.processConnectorResourcesData(artifactsNode);
            QName qualifiedMockServices = new QName("", "mock-services", "");
            OMElement mockServicesNode = importedXMLFile.getFirstChildWithName(qualifiedMockServices);
            SynapseTestCaseFileReader.processMockServicesData(mockServicesNode);
            return importedXMLFile.toString();
        }
        catch (IOException | XMLStreamException e) {
            SynapseTestCaseFileReader.getLog().error((CharSequence)"Artifact data reading failed ", (Throwable)e);
            return null;
        }
    }

    private static void processTestArtifactData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedArtifact;
        QName qualifiedTestArtifact = new QName("", "test-artifact", "");
        OMElement testArtifactNode = artifactsNode.getFirstChildWithName(qualifiedTestArtifact);
        OMElement testArtifactFileNode = testArtifactNode.getFirstChildWithName(qualifiedArtifact = new QName("", "artifact", ""));
        if (testArtifactFileNode.getText().isEmpty()) {
            throw new IOException("Test artifact does not contain configuration file path");
        }
        String testArtifactFilePath = testArtifactFileNode.getText();
        String testArtifactFileAsString = FileUtils.readFileToString((File)new File(".." + File.separator + testArtifactFilePath));
        if (testArtifactFileAsString == null) {
            throw new IOException("Test artifact does not contain any configuration data");
        }
        OMElement testArtifactDataNode = AXIOMUtil.stringToOM((String)testArtifactFileAsString);
        testArtifactFileNode.removeChildren();
        testArtifactFileNode.addChild((OMNode)testArtifactDataNode);
    }

    private static void processSupportiveArtifactData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedSupportiveArtifact = new QName("", "supportive-artifacts", "");
        OMElement supportiveArtifactNode = artifactsNode.getFirstChildWithName(qualifiedSupportiveArtifact);
        Iterator artifactIterator = Collections.emptyIterator();
        if (supportiveArtifactNode != null) {
            artifactIterator = supportiveArtifactNode.getChildElements();
        }
        while (artifactIterator.hasNext()) {
            OMElement artifact = (OMElement)artifactIterator.next();
            if (artifact.getText().isEmpty()) {
                throw new IOException("Supportive artifact does not contain configuration file path");
            }
            String artifactFilePath = artifact.getText();
            String supportiveArtifactFileAsString = FileUtils.readFileToString((File)new File(".." + File.separator + artifactFilePath));
            if (supportiveArtifactFileAsString != null) {
                OMElement supportiveArtifactDataNode = AXIOMUtil.stringToOM((String)supportiveArtifactFileAsString);
                artifact.removeChildren();
                artifact.addChild((OMNode)supportiveArtifactDataNode);
                continue;
            }
            throw new IOException("Supportive artifact does not contain any configuration data");
        }
    }

    private static void processRegistryResourcesData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedRegistryResources = new QName("", "registry-resources", "");
        OMElement registryResourcesNode = artifactsNode.getFirstChildWithName(qualifiedRegistryResources);
        Iterator resourceIterator = Collections.emptyIterator();
        if (registryResourcesNode != null) {
            resourceIterator = registryResourcesNode.getChildElements();
        }
        while (resourceIterator.hasNext()) {
            QName qualifiedRegistryResourcesFile;
            OMElement resource = (OMElement)resourceIterator.next();
            OMElement registryResourcesFileNode = resource.getFirstChildWithName(qualifiedRegistryResourcesFile = new QName("", "artifact", ""));
            if (registryResourcesFileNode.getText().isEmpty()) {
                throw new IOException("Registry resource does not contain configuration file path");
            }
            String registryFilePath = registryResourcesFileNode.getText();
            String registryResourceFileAsString = FileUtils.readFileToString((File)new File(".." + File.separator + registryFilePath));
            if (registryResourceFileAsString != null) {
                if (registryResourceFileAsString.startsWith("<")) {
                    OMElement registryArtifactDataNode = AXIOMUtil.stringToOM((String)registryResourceFileAsString);
                    registryResourcesFileNode.removeChildren();
                    registryResourcesFileNode.addChild((OMNode)registryArtifactDataNode);
                    continue;
                }
                registryResourcesFileNode.setText(registryResourceFileAsString);
                continue;
            }
            throw new IOException("Registry resource does not contain any configuration data");
        }
    }

    private static void processConnectorResourcesData(OMElement artifactsNode) throws IOException, XMLStreamException {
        QName qualifiedConnectorResources = new QName("", "connector-resources", "");
        OMElement connectorResourcesNode = artifactsNode.getFirstChildWithName(qualifiedConnectorResources);
        Iterator connectorIterator = Collections.emptyIterator();
        if (connectorResourcesNode != null) {
            connectorIterator = connectorResourcesNode.getChildElements();
        }
        while (connectorIterator.hasNext()) {
            OMElement resource = (OMElement)connectorIterator.next();
            if (resource.getText().isEmpty()) {
                throw new IOException("Connector resource does not contain configuration file path");
            }
            String registryFilePath = ".." + File.separator + resource.getText();
            byte[] connectorInBytes = Files.readAllBytes(Paths.get(registryFilePath, new String[0]));
            byte[] encoded = Base64.encodeBase64((byte[])connectorInBytes);
            String encodedConnectorFile = new String(encoded);
            if (encodedConnectorFile != null) {
                resource.setText(encodedConnectorFile);
                continue;
            }
            throw new IOException("Connector resource does not contain any configuration data");
        }
    }

    private static void processMockServicesData(OMElement mockServicesNode) throws IOException, XMLStreamException {
        Iterator mockServiceIterator = Collections.emptyIterator();
        if (mockServicesNode != null) {
            mockServiceIterator = mockServicesNode.getChildElements();
        }
        ArrayList<OMElement> mockServiceDataNodeList = new ArrayList<OMElement>();
        while (mockServiceIterator.hasNext()) {
            OMElement mockServiceNode = (OMElement)mockServiceIterator.next();
            if (mockServiceNode.getText().isEmpty()) {
                throw new IOException("Mock service file does not contain configuration file path");
            }
            String mockServiceFilePath = mockServiceNode.getText();
            String mockServiceFileDataAsString = FileUtils.readFileToString((File)new File(".." + File.separator + mockServiceFilePath));
            if (mockServiceFileDataAsString != null) {
                OMElement mockServiceDataNode = AXIOMUtil.stringToOM((String)mockServiceFileDataAsString);
                mockServiceDataNodeList.add(mockServiceDataNode);
                continue;
            }
            throw new IOException("Mock service does not contain any configuration data");
        }
        mockServicesNode.removeChildren();
        for (OMElement child : mockServiceDataNodeList) {
            mockServicesNode.addChild((OMNode)child);
        }
    }

    private static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }
}

