/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.unittest;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wso2.synapse.unittest.SynapseServer;
import org.wso2.synapse.unittest.UnitTestClient;
import org.wso2.synapse.unittest.summarytable.ConsoleDataTable;

@Mojo(name="synapse-unit-test")
public class UnitTestCasesMojo
extends AbstractMojo {
    @Parameter(property="testCasesFilePath")
    private String testCasesFilePath;
    @Parameter(property="server")
    private SynapseServer server;
    private static final String LOCAL_SERVER = "local";
    private static final String REMOTE_SERVER = "remote";
    private Date timeStarted;
    private String serverHost;
    private String serverPort;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void execute() throws MojoExecutionException {
        try {
            this.timeStarted = new Date();
            this.appendTestLogs();
            this.testCaseRunner();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occurred while running test cases " + e.getMessage());
        }
        finally {
            this.stopTestingServer();
        }
    }

    private void testCaseRunner() throws IOException {
        ArrayList<String> synapseTestCasePaths = this.getTestCasesFileNamesWithPaths(this.testCasesFilePath);
        this.getLog().info((CharSequence)("Detect " + synapseTestCasePaths.size() + " Synapse test case files to execute\n"));
        this.getLog().info((CharSequence)"");
        if (!synapseTestCasePaths.isEmpty()) {
            this.startTestingServer();
        }
        HashMap<String, String> testSummaryData = new HashMap<String, String>();
        for (String synapseTestCaseFile : synapseTestCasePaths) {
            String responseFromUnitTestFramework = UnitTestClient.executeTests(synapseTestCaseFile, this.serverHost, this.serverPort);
            if (responseFromUnitTestFramework == null || responseFromUnitTestFramework.equals("no-test-cases")) {
                this.getLog().info((CharSequence)("No test cases found in " + synapseTestCaseFile + " unit test suite"));
                this.getLog().info((CharSequence)"");
                continue;
            }
            testSummaryData.put(synapseTestCaseFile, responseFromUnitTestFramework);
            this.getLog().info((CharSequence)("SynapseTestCaseFile " + synapseTestCaseFile + " tested successfully"));
        }
        this.getLog().info((CharSequence)"");
        this.generateUnitTestReport(testSummaryData);
    }

    private ArrayList<String> getTestCasesFileNamesWithPaths(String testFileFolder) {
        ArrayList<String> fileNamesWithPaths = new ArrayList<String>();
        if (testFileFolder.endsWith(".xml")) {
            fileNamesWithPaths.add(testFileFolder);
        } else if (testFileFolder.endsWith("${testFile}")) {
            File[] listOfFiles;
            String testFolderPath = testFileFolder.split("\\$")[0];
            File folder = new File(testFolderPath);
            for (File file : listOfFiles = folder.listFiles()) {
                String filename = file.getName();
                if (!filename.endsWith(".xml")) continue;
                fileNamesWithPaths.add(testFolderPath + filename);
            }
        }
        return fileNamesWithPaths;
    }

    private void appendTestLogs() {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"U N I T - T E S T S");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private void generateUnitTestReport(Map<String, String> summaryData) throws IOException {
        if (summaryData.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"U N I T - T E S T  R E P O R T");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)("Start Time: " + this.dateFormat.format(this.timeStarted)));
        Date timeStop = new Date();
        long duration = timeStop.getTime() - this.timeStarted.getTime();
        this.getLog().info((CharSequence)("Test Run Duration: " + TimeUnit.MILLISECONDS.toSeconds(duration) + " seconds"));
        this.getLog().info((CharSequence)"Test Summary: ");
        this.getLog().info((CharSequence)"");
        ArrayList<Boolean> testFailedSuccessList = new ArrayList<Boolean>();
        for (Map.Entry<String, String> summary : summaryData.entrySet()) {
            String fileSeperatePattern = Pattern.quote(System.getProperty("file.separator"));
            String[] filePathParams = summary.getKey().split(fileSeperatePattern);
            String testName = filePathParams[filePathParams.length - 1];
            this.getLog().info((CharSequence)("Test Suite Name: " + testName));
            this.getLog().info((CharSequence)"==============================================");
            JsonObject summaryJson = new JsonParser().parse(summary.getValue()).getAsJsonObject();
            Map.Entry<String, String> testFailPassCounts = this.getPassFailureTestCaseCounts(summaryJson);
            String passTestCaseCount = testFailPassCounts.getKey();
            String failureTestCaseCount = testFailPassCounts.getValue();
            this.getLog().info((CharSequence)("Pass Test Cases: " + passTestCaseCount));
            this.getLog().info((CharSequence)("Failure Test Cases: " + failureTestCaseCount));
            this.getLog().info((CharSequence)"");
            String[] summaryHeadersList = new String[]{"  TEST CASE  ", "  DEPLOYMENT  ", "  MEDIATION  ", "  ASSERTION  "};
            String[][] testSummaryDataList = this.getTestCaseWiseSummary(summaryJson);
            String summaryTableString = ConsoleDataTable.of(summaryHeadersList, testSummaryDataList);
            String[] tableOutputLines = System.getProperty("os.name").toLowerCase().contains("win") ? summaryTableString.split(System.getProperty("\\r?\\n")) : summaryTableString.split(System.getProperty("line.separator"));
            for (String line : tableOutputLines) {
                this.getLog().info((CharSequence)line);
            }
            this.getLog().info((CharSequence)"");
            boolean isOverallTestFailed = this.generateTestFailureTable(summaryJson);
            testFailedSuccessList.add(isOverallTestFailed);
        }
        if (testFailedSuccessList.contains(true)) {
            throw new IOException("Overall unit test failed");
        }
    }

    private void startTestingServer() throws IOException {
        this.serverPort = this.server.getServerPort();
        if (this.serverPort == null || this.serverPort.isEmpty()) {
            this.server.setServerPort("9008");
            this.serverPort = this.server.getServerPort();
        }
        if (this.server.getServerType().equals(LOCAL_SERVER)) {
            this.serverHost = "127.0.0.1";
            String synapseServerPath = this.server.getServerPath();
            String[] cmd = new String[]{synapseServerPath, "-DsynapseTest", "-DsynapseTestPort=" + this.serverPort};
            Process processor = Runtime.getRuntime().exec(cmd);
            this.getLog().info((CharSequence)("Starting unit testing agent of path - " + synapseServerPath));
            this.getLog().info((CharSequence)"Waiting for testing agent initialization");
            this.getLog().info((CharSequence)"");
            BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(processor.getInputStream()));
            boolean isServerNotStarted = true;
            long timeoutExpiredMs = System.currentTimeMillis() + 120000L;
            while (isServerNotStarted) {
                long waitMillis = timeoutExpiredMs - System.currentTimeMillis();
                isServerNotStarted = this.checkPortAvailability(Integer.parseInt(this.serverPort));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().info((CharSequence)inputBuffer.readLine());
                }
                if (waitMillis > 0L) continue;
                throw new IOException("Connection refused for service in port - " + this.serverPort);
            }
            inputBuffer.close();
        } else if (this.server.getServerType().equals(REMOTE_SERVER)) {
            this.serverHost = this.server.getServerHost();
        } else {
            this.getLog().info((CharSequence)("Given server type " + this.server.getServerType() + "is not an expected type"));
        }
    }

    private void stopTestingServer() {
        if (this.server.getServerType().equals(LOCAL_SERVER)) {
            try {
                BufferedReader bufferReader;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Stopping unit testing agent runs on port " + this.serverPort));
                }
                if (System.getProperty("os.name").toLowerCase().contains("win")) {
                    Runtime runTime = Runtime.getRuntime();
                    Process proc = runTime.exec("cmd /c netstat -ano | findstr " + this.serverPort);
                    bufferReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String stream = bufferReader.readLine();
                    if (stream != null) {
                        int index = stream.lastIndexOf(32);
                        String pid = stream.substring(index);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Unit testing agent runs with PID of " + pid));
                        }
                        runTime.exec("cmd /c Taskkill /PID" + pid + " /T /F");
                    }
                } else {
                    Process pr = Runtime.getRuntime().exec("lsof -t -i:" + this.serverPort);
                    bufferReader = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String pid = bufferReader.readLine();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Unit testing agent runs with PID of " + pid));
                    }
                    Runtime.getRuntime().exec("kill -9 " + pid);
                }
                bufferReader.close();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Unit testing agent stopped");
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error in closing the server", (Throwable)e);
            }
        }
    }

    private boolean checkPortAvailability(int port) {
        boolean isPortAvailable;
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(this.serverHost, port));
            isPortAvailable = false;
        }
        catch (IOException e) {
            isPortAvailable = true;
        }
        return isPortAvailable;
    }

    private Map.Entry<String, String> getPassFailureTestCaseCounts(JsonObject jsonSummary) {
        String failureTestCount;
        String passTestCount;
        if (jsonSummary.get("mediationStatus") != null && jsonSummary.get("mediationStatus").getAsString().equals("PASSED") && jsonSummary.get("testCases") != null && jsonSummary.get("testCases").getAsJsonArray().size() > 0) {
            JsonArray testCases = jsonSummary.get("testCases").getAsJsonArray();
            int passCount = 0;
            int failureCount = 0;
            for (int x = 0; x < testCases.size(); ++x) {
                JsonObject testJsonObject = testCases.get(x).getAsJsonObject();
                if (testJsonObject.get("assertionStatus").getAsString().equals("PASSED")) {
                    ++passCount;
                    continue;
                }
                ++failureCount;
            }
            passTestCount = String.valueOf(passCount);
            failureTestCount = String.valueOf(failureCount);
        } else {
            passTestCount = "N/A";
            failureTestCount = "N/A";
        }
        return new AbstractMap.SimpleEntry<String, String>(passTestCount, failureTestCount);
    }

    private String[][] getTestCaseWiseSummary(JsonObject jsonSummary) {
        int x;
        ArrayList allTestSummary = new ArrayList();
        if (jsonSummary.get("testCases") != null && jsonSummary.get("testCases").getAsJsonArray().size() > 0) {
            ArrayList<String> testSummary;
            JsonArray testCases = jsonSummary.get("testCases").getAsJsonArray();
            for (x = 0; x < testCases.size(); ++x) {
                testSummary = new ArrayList<String>();
                JsonObject testJsonObject = testCases.get(x).getAsJsonObject();
                testSummary.add("Test Case - " + testJsonObject.get("testCaseName").getAsString());
                testSummary.add("   " + jsonSummary.get("deploymentStatus").getAsString());
                testSummary.add("   " + testJsonObject.get("mediationStatus").getAsString());
                testSummary.add("   " + testJsonObject.get("assertionStatus").getAsString());
                allTestSummary.add(testSummary);
            }
            if (!jsonSummary.get("mediationStatus").getAsString().equals("PASSED")) {
                testSummary = new ArrayList();
                testSummary.add("Test Case - " + jsonSummary.get("currentTestCase").getAsString());
                testSummary.add("   " + jsonSummary.get("deploymentStatus").getAsString());
                testSummary.add("   " + jsonSummary.get("mediationStatus").getAsString());
                testSummary.add("   SKIPPED");
                allTestSummary.add(testSummary);
            }
        } else {
            ArrayList<String> testSummary = new ArrayList<String>();
            testSummary.add("Test Case - Suite");
            testSummary.add("   " + jsonSummary.get("deploymentStatus").getAsString());
            testSummary.add("   " + jsonSummary.get("mediationStatus").getAsString());
            testSummary.add("   SKIPPED");
            allTestSummary.add(testSummary);
        }
        String[][] allSummaryArray = new String[allTestSummary.size()][4];
        for (x = 0; x < allTestSummary.size(); ++x) {
            List innerList = (List)allTestSummary.get(x);
            String[] innerArray = new String[4];
            innerArray = innerList.toArray(innerArray);
            allSummaryArray[x] = innerArray;
        }
        return allSummaryArray;
    }

    private boolean generateTestFailureTable(JsonObject jsonSummary) {
        int x;
        boolean isFailureOccurred = false;
        String[] errorHeadersList = new String[]{"  TEST CASE  ", "  FAILURE STATE  ", "      EXCEPTION / ERROR MESSAGE     "};
        ArrayList errorRowsList = new ArrayList();
        if (jsonSummary.get("testCases") != null && jsonSummary.get("testCases").getAsJsonArray().size() > 0) {
            JsonArray testCases = jsonSummary.get("testCases").getAsJsonArray();
            for (x = 0; x < testCases.size(); ++x) {
                ArrayList<String> failureSummary = new ArrayList<String>();
                JsonObject testJsonObject = testCases.get(x).getAsJsonObject();
                if (!testJsonObject.get("mediationStatus").getAsString().equals("PASSED")) {
                    isFailureOccurred = true;
                    failureSummary.add("Test Case - " + testJsonObject.get("testCaseName").getAsString());
                    failureSummary.add("   MEDIATION");
                    failureSummary.add(testJsonObject.get("exception").getAsString());
                    errorRowsList.add(failureSummary);
                    continue;
                }
                if (testJsonObject.get("assertionStatus").getAsString().equals("PASSED")) continue;
                isFailureOccurred = true;
                failureSummary.add("Test Case - " + testJsonObject.get("testCaseName").getAsString());
                failureSummary.add("   ASSERTION");
                failureSummary.add(testJsonObject.get("exception").getAsString());
                errorRowsList.add(failureSummary);
            }
            if (!jsonSummary.get("mediationStatus").getAsString().equals("PASSED")) {
                isFailureOccurred = true;
                ArrayList<String> failureSummary = new ArrayList<String>();
                failureSummary.add("Test Case - " + jsonSummary.get("currentTestCase").getAsString());
                failureSummary.add("   MEDIATION");
                failureSummary.add(jsonSummary.get("mediationException").getAsString());
                errorRowsList.add(failureSummary);
            }
        } else {
            ArrayList<String> testSummary = new ArrayList<String>();
            if (!jsonSummary.get("deploymentStatus").getAsString().equals("PASSED")) {
                isFailureOccurred = true;
                testSummary.add("Test Case - Suite");
                testSummary.add("   DEPLOYMENT");
                if (jsonSummary.get("deploymentException") != null) {
                    testSummary.add(jsonSummary.get("deploymentException").getAsString());
                } else {
                    testSummary.add(jsonSummary.get("deploymentDescription").getAsString());
                }
                errorRowsList.add(testSummary);
            } else if (!jsonSummary.get("mediationStatus").getAsString().equals("PASSED")) {
                isFailureOccurred = true;
                testSummary.add("Test Case - " + jsonSummary.get("currentTestCase").getAsString());
                testSummary.add("   MEDIATION");
                testSummary.add(jsonSummary.get("mediationException").getAsString());
                errorRowsList.add(testSummary);
            }
        }
        if (isFailureOccurred) {
            this.getLog().info((CharSequence)"Failed Test Case(s): ");
            String[][] errorRowsArray = new String[errorRowsList.size()][3];
            for (x = 0; x < errorRowsList.size(); ++x) {
                List innerList = (List)errorRowsList.get(x);
                String[] innerArray = new String[3];
                innerArray = innerList.toArray(innerArray);
                errorRowsArray[x] = innerArray;
            }
            String errorTableString = ConsoleDataTable.of(errorHeadersList, errorRowsArray);
            String[] errorTableLines = System.getProperty("os.name").toLowerCase().contains("win") ? errorTableString.split(System.getProperty("\\r?\\n")) : errorTableString.split(System.getProperty("line.separator"));
            for (String line : errorTableLines) {
                this.getLog().info((CharSequence)line);
            }
            this.getLog().info((CharSequence)"");
        }
        return isFailureOccurred;
    }
}

