/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.unittest;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.wso2.synapse.unittest.SynapseTestCaseFileReader;
import org.wso2.synapse.unittest.TCPClient;

class UnitTestClient {
    private static Log log;

    private UnitTestClient() {
    }

    static String executeTests(String synapseTestCaseFilePath, String synapseHost, String synapsePort) {
        String responseFromServer = null;
        try {
            String deployableMessage = SynapseTestCaseFileReader.processArtifactData(synapseTestCaseFilePath);
            if (deployableMessage != null && deployableMessage.equals("no-test-cases")) {
                return deployableMessage;
            }
            if (deployableMessage != null) {
                TCPClient tcpClient = new TCPClient(synapseHost, synapsePort);
                tcpClient.writeData(deployableMessage);
                responseFromServer = tcpClient.readData();
                tcpClient.closeSocket();
            } else {
                UnitTestClient.getLog().error((CharSequence)"Error in creating deployable message");
            }
            return responseFromServer;
        }
        catch (Exception e) {
            UnitTestClient.getLog().error((CharSequence)"Error while executing client", (Throwable)e);
            UnitTestClient.getLog().info((CharSequence)"Unit testing client stopped");
            return responseFromServer;
        }
    }

    private static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }
}

