/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.CAppHandler;
import org.wso2.maven.Model.ArchiveException;
import org.wso2.maven.Model.ArtifactDependency;

@Mojo(name="WSO2ESBDeployableArchive")
public class CARMojo
extends AbstractMojo {
    private File projectBuildDir;
    private File archiveLocation;
    private String archiveName;
    private String cAppName;
    private MavenProject project;
    private String classifier;

    public void execute() throws MojoExecutionException {
        this.appendLogs();
        try {
            String archiveDirectory = this.getArchiveFile("").getAbsolutePath();
            boolean createdArchiveDirectory = FileUtils.createDirectories((String)archiveDirectory);
            if (createdArchiveDirectory) {
                CAppHandler cAppHandler = new CAppHandler(this.cAppName);
                ArrayList<ArtifactDependency> dependencies = new ArrayList<ArtifactDependency>();
                cAppHandler.processConfigArtifactXmlFile(this.projectBuildDir, archiveDirectory, dependencies);
                cAppHandler.processRegistryResourceArtifactXmlFile(this.projectBuildDir, archiveDirectory, dependencies);
                cAppHandler.createDependencyArtifactsXmlFile(archiveDirectory, dependencies, this.project);
                File fileToZip = new File(archiveDirectory);
                File carFile = this.getArchiveFile(".car");
                this.zipFolder(fileToZip.getPath(), carFile.getPath());
                this.project.getArtifact().setFile(carFile);
                this.recursiveDelete(fileToZip);
            } else {
                this.getLog().error((CharSequence)"Could not create corresponding archive directory.");
            }
        }
        catch (IOException | XMLStreamException | ArchiveException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void appendLogs() {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"Building Synapse Config Project");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private File getArchiveFile(String fileExtension) {
        if (this.archiveName != null && !this.archiveName.trim().equals("")) {
            File archiveFile = new File(this.archiveLocation, this.archiveName + fileExtension);
            return archiveFile;
        }
        String archiveFilename = this.project.getArtifactId() + "_" + this.project.getVersion() + (this.classifier != null ? "-" + this.classifier : "") + fileExtension;
        File archiveFile = new File(this.archiveLocation, archiveFilename);
        return archiveFile;
    }

    private void zipFolder(String srcFolder, String destZipFile) throws ArchiveException {
        try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
             ZipOutputStream zip = new ZipOutputStream(fileWriter);){
            this.addFolderContentsToZip(srcFolder, zip);
            zip.flush();
        }
        catch (IOException ex) {
            throw new ArchiveException("Error occurred while creating CAR file.", ex);
        }
    }

    private void addFolderContentsToZip(String srcFolder, ZipOutputStream zip) throws ArchiveException {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        if (fileList == null) {
            return;
        }
        try {
            for (int i = 0; fileList.length != i; ++i) {
                if (new File(folder, fileList[i]).isDirectory()) {
                    zip.putNextEntry(new ZipEntry(fileList[i] + "/"));
                    zip.closeEntry();
                }
                this.addToZip("", srcFolder + "/" + fileList[i], zip);
            }
        }
        catch (IOException ex) {
            throw new ArchiveException("Error occurred while creating CAR file.", ex);
        }
    }

    private void addToZip(String path, String srcFile, ZipOutputStream zip) throws ArchiveException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            byte[] buf = new byte[1024];
            try (FileInputStream in = new FileInputStream(srcFile);){
                int len;
                if (path.trim().equals("")) {
                    zip.putNextEntry(new ZipEntry(folder.getName()));
                } else {
                    zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
                }
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (IOException ex) {
                throw new ArchiveException("Error occurred while creating CAR file.", ex);
            }
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws ArchiveException {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        if (fileList == null) {
            return;
        }
        try {
            for (int i = 0; fileList.length != i; ++i) {
                String newPath = folder.getName();
                if (!path.equalsIgnoreCase("")) {
                    newPath = path + "/" + newPath;
                }
                if (new File(folder, fileList[i]).isDirectory()) {
                    zip.putNextEntry(new ZipEntry(newPath + "/" + fileList[i] + "/"));
                }
                this.addToZip(newPath, srcFolder + "/" + fileList[i], zip);
            }
        }
        catch (IOException ex) {
            throw new ArchiveException("Error occurred while creating CAR file.", ex);
        }
    }

    private void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.recursiveDelete(f);
            }
        }
        file.delete();
    }
}

