/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.Model.Artifact;
import org.wso2.maven.Model.ArtifactDependency;
import org.wso2.maven.core.model.AbstractXMLDoc;

class CAppHandler
extends AbstractXMLDoc {
    private static final String SYNAPSE_CONFIG_FOLDER = Paths.get("src", "main", "synapse-config").toString();
    private static final String REGISTRY_RESOURCES_FOLDER = Paths.get("src", "main", "registry-resources").toString();

    CAppHandler() {
    }

    void processConfigArtifactXmlFile(File projectBaseDir, String archiveDirectory, List<ArtifactDependency> dependencies) throws IOException, XMLStreamException, MojoExecutionException {
        String configArtifactXmlFileAsString = FileUtils.readFileToString((File)new File(Paths.get(projectBaseDir.getAbsolutePath(), SYNAPSE_CONFIG_FOLDER, "artifact.xml").toString()));
        OMElement artifactsElement = this.getElement(configArtifactXmlFileAsString);
        List artifactChildElements = this.getChildElements(artifactsElement, "artifact");
        for (OMElement artifact : artifactChildElements) {
            Artifact artifactObject = this.createArtifactObject(artifact, this.getAttribute(artifact, "name") + "-" + this.getAttribute(artifact, "version") + ".xml");
            dependencies.add(new ArtifactDependency(artifactObject.getName(), artifactObject.getVersion(), artifactObject.getServerRole(), true));
            String artifactFolderName = artifactObject.getName() + "_" + artifactObject.getVersion();
            String artifactFileName = artifactObject.getName() + "-" + artifactObject.getVersion() + ".xml";
            String artifactDataAsString = this.createArtifactData(artifactObject);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(Paths.get(archiveDirectory, artifactFolderName).toString(), "artifact.xml"), (String)artifactDataAsString);
            String copyArtifactFileFrom = Paths.get(projectBaseDir.getAbsolutePath(), SYNAPSE_CONFIG_FOLDER, this.getFirstChildWithName(artifact, "file").getText()).toString();
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.copy((File)new File(copyArtifactFileFrom), (File)new File(Paths.get(archiveDirectory, artifactFolderName, artifactFileName).toString()));
        }
    }

    void processRegistryResourceArtifactXmlFile(File projectBaseDir, String archiveDirectory, List<ArtifactDependency> dependencies) throws IOException, XMLStreamException, MojoExecutionException {
        String registryArtifactXmlFileAsString = FileUtils.readFileToString((File)new File(Paths.get(projectBaseDir.getAbsolutePath(), REGISTRY_RESOURCES_FOLDER, "artifact.xml").toString()));
        OMElement artifactsElement = this.getElement(registryArtifactXmlFileAsString);
        List artifactChildElements = this.getChildElements(artifactsElement, "artifact");
        for (OMElement artifact : artifactChildElements) {
            Artifact registryObject = this.createArtifactObject(artifact, this.getAttribute(artifact, "name") + "-info.xml");
            OMElement itemElement = this.getFirstChildWithName(artifact, "item");
            String registryResourceFileName = this.getFirstChildWithName(itemElement, "file").getText();
            dependencies.add(new ArtifactDependency(registryObject.getName(), registryObject.getVersion(), registryObject.getServerRole(), true));
            String artifactFolderName = registryObject.getName() + "_" + registryObject.getVersion();
            String artifactDataAsString = this.createArtifactData(registryObject);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(Paths.get(archiveDirectory, artifactFolderName).toString(), "artifact.xml"), (String)artifactDataAsString);
            String copyArtifactFileFrom = Paths.get(projectBaseDir.getAbsolutePath(), REGISTRY_RESOURCES_FOLDER, registryResourceFileName).toString();
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.copy((File)new File(copyArtifactFileFrom), (File)new File(Paths.get(archiveDirectory, artifactFolderName, "resources", registryResourceFileName).toString()));
            String registryResourceData = this.createRegistryResourceData(this.getFirstChildWithName(artifact, "item"));
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(Paths.get(archiveDirectory, artifactFolderName).toString(), registryObject.getName() + "-info.xml"), (String)registryResourceData);
        }
    }

    private Artifact createArtifactObject(OMElement artifact, String artifactFileLocation) {
        Artifact artifactObject = new Artifact();
        artifactObject.setName(this.getAttribute(artifact, "name"));
        artifactObject.setType(this.getAttribute(artifact, "type"));
        artifactObject.setVersion(this.getAttribute(artifact, "version"));
        artifactObject.setServerRole(this.getAttribute(artifact, "serverRole"));
        artifactObject.setFile(artifactFileLocation);
        return artifactObject;
    }

    private String createArtifactData(Artifact artifact) throws MojoExecutionException {
        OMElement artifactElement = this.getElement("artifact", "");
        artifactElement = this.addAttribute(artifactElement, "name", artifact.getName());
        artifactElement = this.addAttribute(artifactElement, "version", artifact.getVersion());
        artifactElement = this.addAttribute(artifactElement, "type", artifact.getType());
        artifactElement = this.addAttribute(artifactElement, "serverRole", artifact.getServerRole());
        OMElement fileChildElement = this.getElement("file", artifact.getFile());
        artifactElement.addChild((OMNode)fileChildElement);
        return this.serialize(artifactElement);
    }

    private String createRegistryResourceData(OMElement item) throws MojoExecutionException {
        OMElement resourcesElement = this.getElement("resources", "");
        resourcesElement.addChild((OMNode)item);
        return this.serialize(resourcesElement);
    }

    void createDependencyArtifactsXmlFile(String archiveDirectory, List<ArtifactDependency> dependencies, MavenProject project) throws MojoExecutionException, IOException {
        OMElement artifactsElement = this.getElement("artifacts", "");
        OMElement artifactElement = this.getElement("artifact", "");
        artifactElement = this.addAttribute(artifactElement, "name", this.getCAppName(project));
        artifactElement = this.addAttribute(artifactElement, "version", project.getVersion());
        artifactElement = this.addAttribute(artifactElement, "type", "carbon/application");
        for (ArtifactDependency dependency : dependencies) {
            OMElement dependencyElement = this.getElement("dependency", "");
            dependencyElement = this.addAttribute(dependencyElement, "artifact", dependency.getArtifact());
            dependencyElement = this.addAttribute(dependencyElement, "version", dependency.getVersion());
            dependencyElement = this.addAttribute(dependencyElement, "include", dependency.getInclude().toString());
            if (dependency.getServerRole() != null) {
                dependencyElement = this.addAttribute(dependencyElement, "serverRole", dependency.getServerRole());
            }
            artifactElement.addChild((OMNode)dependencyElement);
        }
        artifactsElement.addChild((OMNode)artifactElement);
        String artifactsXmlFileDataAsString = this.serialize(artifactsElement);
        org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(archiveDirectory, "artifacts.xml"), (String)artifactsXmlFileDataAsString);
    }

    private String getCAppName(MavenProject project) {
        return project.getArtifactId() + "CompositeApplication_" + project.getVersion();
    }

    protected void deserialize(OMElement documentElement) throws Exception {
    }

    protected String serialize() throws Exception {
        return null;
    }

    private String serialize(OMElement element) throws MojoExecutionException {
        OMDocument document = factory.createOMDocument();
        document.addChild((OMNode)element);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            CAppHandler.prettify((OMElement)element, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error serializing", e);
        }
        return outputStream.toString();
    }

    protected String getDefaultName() {
        return null;
    }
}

