/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugin.sequence;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

public class SequenceMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File artifact;
    private String extension;
    private String fileName;
    private boolean enableArchive;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File destFolder = new File(this.project.getBuild().getDirectory());
        String newPath = null;
        if (this.fileName != null) {
            newPath = destFolder.getAbsolutePath() + File.separator + this.fileName;
        } else if (this.extension != null) {
            String fileNameWithoutExtension = this.artifact.getName().split("\\.")[0];
            newPath = destFolder.getAbsolutePath() + File.separator + fileNameWithoutExtension + "." + this.extension;
        } else {
            newPath = destFolder.getAbsolutePath() + File.separator + this.artifact.getName();
        }
        File result = new File(newPath);
        if (!this.artifact.exists()) {
            throw new MojoExecutionException(this.artifact.getAbsolutePath() + " doesn't exist.");
        }
        try {
            FileUtils.copyFile((File)this.artifact, (File)result);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when copying " + this.artifact.getName() + " to " + result.getName() + "\n" + e.getMessage());
        }
        if (result == null || !result.exists()) {
            throw new MojoExecutionException(result + " is null or doesn't exist");
        }
        this.project.getArtifact().setFile(result);
        if (this.enableArchive) {
            // empty if block
        }
    }
}

